/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cxf.client;

import java.util.HashMap;
import java.util.Map;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.apache.geronimo.cxf.client.CXFPasswordHandler;
import org.apache.geronimo.jaxws.client.EndpointInfo;
import org.apache.geronimo.jaxws.client.PortMethodInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CXFPortMethodInterceptor
extends PortMethodInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(CXFPortMethodInterceptor.class);
    private static final String IN_PREFIX = "wss4j.in.";
    private static final String OUT_PREFIX = "wss4j.out.";
    private static final String[] ACTIONS = new String[]{"UsernameToken", "Signature", "Encrypt"};

    public CXFPortMethodInterceptor(Map<Object, EndpointInfo> seiInfoMap) {
        super(seiInfoMap);
    }

    protected void setProperties(BindingProvider proxy, EndpointInfo info, Map<String, Object> props) {
        if (info == null) {
            return;
        }
        HashMap<String, Object> wss4jInProps = new HashMap<String, Object>();
        HashMap<String, Object> wss4jOutProps = new HashMap<String, Object>();
        HashMap<String, Object> otherProps = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key.startsWith(IN_PREFIX)) {
                key = key.substring(IN_PREFIX.length());
                wss4jInProps.put(key, value);
                continue;
            }
            if (key.startsWith(OUT_PREFIX)) {
                key = key.substring(OUT_PREFIX.length());
                wss4jOutProps.put(key, value);
                continue;
            }
            otherProps.put(key, value);
        }
        super.setProperties(proxy, info, otherProps);
        if (proxy instanceof Dispatch) {
            if (!wss4jInProps.isEmpty() || !wss4jOutProps.isEmpty()) {
                LOG.warn("wss4j properties are not supported for Dispatch clients");
            }
            return;
        }
        Client client = ClientProxy.getClient((Object)proxy);
        Endpoint cxfEndpoint = client.getEndpoint();
        if (!wss4jOutProps.isEmpty()) {
            CXFPortMethodInterceptor.updateSecurityProperties(wss4jOutProps);
            WSS4JOutInterceptor wssOut = new WSS4JOutInterceptor(wss4jOutProps);
            cxfEndpoint.getOutInterceptors().add(wssOut);
        }
        if (!wss4jInProps.isEmpty()) {
            WSS4JInInterceptor wssIn = new WSS4JInInterceptor(wss4jInProps);
            cxfEndpoint.getInInterceptors().add(wssIn);
        }
    }

    private static void updateSecurityProperties(Map<String, Object> properties) {
        String action = (String)properties.get("action");
        if (CXFPortMethodInterceptor.containsValue(action, ACTIONS) && !properties.containsKey("passwordCallbackClass")) {
            CXFPasswordHandler handler = new CXFPasswordHandler();
            handler.addPassword((String)properties.get("user"), (String)properties.get("password"));
            handler.addPassword((String)properties.get("signatureUser"), (String)properties.get("signaturePassword"));
            handler.addPassword((String)properties.get("encryptionUser"), (String)properties.get("encryptionPassword"));
            properties.put("passwordCallbackRef", handler);
        }
    }

    private static boolean containsValue(String property, String[] values) {
        if (property != null) {
            String[] entries = property.split(" ");
            for (String value : values) {
                for (String entry : entries) {
                    if (!value.equals(entry)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

