/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cxf.pojo;

import java.net.URL;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.cxf.Bus;
import org.apache.cxf.jaxws.context.WebServiceContextImpl;
import org.apache.geronimo.cxf.CXFCatalogUtils;
import org.apache.geronimo.cxf.CXFWebServiceContainer;
import org.apache.geronimo.cxf.pojo.POJOWebServiceContainer;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.jaxws.JAXWSUtils;
import org.apache.geronimo.jaxws.JNDIResolver;
import org.apache.geronimo.jaxws.PortInfo;
import org.apache.geronimo.jaxws.ServerJNDIResolver;
import org.apache.geronimo.jaxws.annotations.AnnotationHolder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.naming.enc.EnterpriseNamingContext;
import org.apache.geronimo.naming.reference.SimpleReference;
import org.apache.geronimo.transaction.GeronimoUserTransaction;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.apache.geronimo.webservices.WebServiceContainerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class POJOWebServiceContainerFactoryGBean
implements WebServiceContainerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(POJOWebServiceContainerFactoryGBean.class);
    private final Bus bus;
    private final Class servletClass;
    private final URL configurationBaseUrl;
    public static final GBeanInfo GBEAN_INFO;

    public POJOWebServiceContainerFactoryGBean(PortInfo portInfo, String endpointClassName, ClassLoader classLoader, Map componentContext, Kernel kernel, TransactionManager transactionManager, URL configurationBaseUrl, AnnotationHolder holder, String contextRoot) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Context context = null;
        if (componentContext != null) {
            componentContext.put("env/WebServiceContext", new WebServiceContextReference());
            GeronimoUserTransaction userTransaction = new GeronimoUserTransaction(transactionManager);
            try {
                context = EnterpriseNamingContext.createEnterpriseNamingContext((Map)componentContext, (UserTransaction)userTransaction, (Kernel)kernel, (ClassLoader)classLoader);
            }
            catch (NamingException e) {
                LOG.warn("Failed to create naming context", (Throwable)e);
            }
        }
        this.bus = CXFWebServiceContainer.getBus();
        this.configurationBaseUrl = configurationBaseUrl;
        this.servletClass = classLoader.loadClass(endpointClassName);
        this.bus.setExtension((Object)new ServerJNDIResolver(context), JNDIResolver.class);
        this.bus.setExtension((Object)portInfo, PortInfo.class);
        this.bus.setExtension((Object)context, Context.class);
        this.bus.setExtension((Object)holder, AnnotationHolder.class);
        URL catalog = JAXWSUtils.getOASISCatalogURL((URL)this.configurationBaseUrl, (ClassLoader)classLoader, (String)"WEB-INF/jax-ws-catalog.xml");
        if (catalog != null) {
            CXFCatalogUtils.loadOASISCatalog(this.bus, catalog);
        }
    }

    public WebServiceContainer getWebServiceContainer() {
        return new POJOWebServiceContainer(this.bus, this.configurationBaseUrl, this.servletClass);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(POJOWebServiceContainerFactoryGBean.class, (String)"GBean");
        infoBuilder.addAttribute("portInfo", PortInfo.class, true, true);
        infoBuilder.addAttribute("endpointClassName", String.class, true, true);
        infoBuilder.addAttribute("classLoader", ClassLoader.class, false);
        infoBuilder.addAttribute("componentContext", Map.class, true, true);
        infoBuilder.addAttribute("kernel", Kernel.class, false);
        infoBuilder.addReference("TransactionManager", TransactionManager.class, "JTAResource");
        infoBuilder.addAttribute("configurationBaseUrl", URL.class, true);
        infoBuilder.addAttribute("holder", AnnotationHolder.class, true);
        infoBuilder.addAttribute("contextRoot", String.class, true, true);
        infoBuilder.setConstructor(new String[]{"portInfo", "endpointClassName", "classLoader", "componentContext", "kernel", "TransactionManager", "configurationBaseUrl", "holder", "contextRoot"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }

    private static class WebServiceContextReference
    extends SimpleReference {
        private WebServiceContextReference() {
        }

        public Object getContent() throws NamingException {
            return new WebServiceContextImpl();
        }
    }
}

