/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cxf;

import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;
import org.apache.cxf.jaxws.javaee.HandlerChainType;
import org.apache.cxf.jaxws.javaee.HandlerChainsType;
import org.apache.geronimo.cxf.GeronimoHandlerChainBuilder;
import org.apache.geronimo.jaxws.annotations.AnnotationException;
import org.apache.geronimo.jaxws.annotations.AnnotationProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CXFHandlerResolver
implements HandlerResolver {
    private HandlerChainsType handlerChains;
    private ClassLoader classLoader;
    private Class serviceClass;
    private AnnotationProcessor annotationProcessor;

    public CXFHandlerResolver(ClassLoader classLoader, Class serviceClass, HandlerChainsType handlerChains, AnnotationProcessor annotationProcessor) {
        this.classLoader = classLoader;
        this.serviceClass = serviceClass;
        this.handlerChains = handlerChains;
        this.annotationProcessor = annotationProcessor;
    }

    public List<Handler> getHandlerChain(PortInfo portInfo) {
        GeronimoHandlerChainBuilder builder = new GeronimoHandlerChainBuilder(this.classLoader, portInfo);
        List handlers = null;
        if (this.handlerChains == null) {
            handlers = builder.buildHandlerChainFromClass(this.serviceClass);
        } else {
            handlers = new ArrayList();
            for (HandlerChainType handlerChain : this.handlerChains.getHandlerChain()) {
                handlers.addAll(builder.buildHandlerChainFromConfiguration(handlerChain));
            }
            handlers = builder.sortHandlers(handlers);
        }
        if (this.annotationProcessor != null) {
            try {
                for (Handler handler : handlers) {
                    this.annotationProcessor.processAnnotations((Object)handler);
                    this.annotationProcessor.invokePostConstruct((Object)handler);
                }
            }
            catch (AnnotationException e) {
                throw new WebServiceException("Handler annotation failed", (Throwable)e);
            }
        }
        return handlers;
    }
}

