/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cxf.pojo;

import java.net.URL;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.Bus;
import org.apache.geronimo.cxf.CXFCatalogUtils;
import org.apache.geronimo.cxf.CXFWebServiceContainer;
import org.apache.geronimo.cxf.pojo.POJOWebServiceContainer;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.jaxws.JNDIResolver;
import org.apache.geronimo.jaxws.PortInfo;
import org.apache.geronimo.jaxws.ServerJNDIResolver;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.naming.enc.EnterpriseNamingContext;
import org.apache.geronimo.transaction.GeronimoUserTransaction;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.apache.geronimo.webservices.WebServiceContainerFactory;

public class POJOWebServiceContainerFactoryGBean
implements WebServiceContainerFactory {
    private static final Log LOG = LogFactory.getLog(POJOWebServiceContainerFactoryGBean.class);
    private final Bus bus;
    private final Object endpointInstance;
    private final URL configurationBaseUrl;
    public static final GBeanInfo GBEAN_INFO;

    public POJOWebServiceContainerFactoryGBean(PortInfo portInfo, String endpointClassName, ClassLoader classLoader, Map componentContext, Kernel kernel, TransactionManager transactionManager, URL configurationBaseUrl) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Context context = null;
        if (componentContext != null) {
            GeronimoUserTransaction userTransaction = new GeronimoUserTransaction(transactionManager);
            try {
                context = EnterpriseNamingContext.createEnterpriseNamingContext((Map)componentContext, (UserTransaction)userTransaction, (Kernel)kernel, (ClassLoader)classLoader);
            }
            catch (NamingException e) {
                LOG.warn((Object)"Failed to create naming context", (Throwable)e);
            }
        }
        this.bus = CXFWebServiceContainer.getBus();
        this.configurationBaseUrl = configurationBaseUrl;
        Class<?> endpointClass = classLoader.loadClass(endpointClassName);
        this.endpointInstance = endpointClass.newInstance();
        this.bus.setExtension((Object)new ServerJNDIResolver(context), JNDIResolver.class);
        this.bus.setExtension((Object)portInfo, PortInfo.class);
        CXFCatalogUtils.loadOASISCatalog(this.bus, this.configurationBaseUrl, "WEB-INF/jax-ws-catalog.xml");
    }

    public WebServiceContainer getWebServiceContainer() {
        return new POJOWebServiceContainer(this.bus, this.configurationBaseUrl, this.endpointInstance);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(POJOWebServiceContainerFactoryGBean.class, (String)"GBean");
        infoBuilder.addAttribute("portInfo", PortInfo.class, true, true);
        infoBuilder.addAttribute("endpointClassName", String.class, true, true);
        infoBuilder.addAttribute("classLoader", ClassLoader.class, false);
        infoBuilder.addAttribute("componentContext", Map.class, true, true);
        infoBuilder.addAttribute("kernel", Kernel.class, false);
        infoBuilder.addReference("TransactionManager", TransactionManager.class, "TransactionManager");
        infoBuilder.addAttribute("configurationBaseUrl", URL.class, true);
        infoBuilder.setConstructor(new String[]{"portInfo", "endpointClassName", "classLoader", "componentContext", "kernel", "TransactionManager", "configurationBaseUrl"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

