/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cxf;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.extension.ExtensionManagerBus;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.geronimo.cxf.CXFEndpoint;
import org.apache.geronimo.cxf.GeronimoDestination;
import org.apache.geronimo.cxf.GeronimoDestinationFactory;
import org.apache.geronimo.cxf.GeronimoQueryHandler;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.apache.geronimo.webservices.saaj.SAAJUniverse;

public abstract class CXFWebServiceContainer
implements WebServiceContainer {
    private static final Log LOG = LogFactory.getLog(CXFWebServiceContainer.class);
    protected final GeronimoDestination destination;
    protected final Bus bus;
    protected final CXFEndpoint endpoint;
    protected URL configurationBaseUrl;

    public CXFWebServiceContainer(Bus bus, URL configurationBaseUrl, Object target) {
        this.bus = bus;
        this.configurationBaseUrl = configurationBaseUrl;
        ArrayList<String> ids = new ArrayList<String>();
        ids.add("http://schemas.xmlsoap.org/wsdl/soap/");
        DestinationFactoryManager destinationFactoryManager = (DestinationFactoryManager)bus.getExtension(DestinationFactoryManager.class);
        GeronimoDestinationFactory factory = new GeronimoDestinationFactory(bus);
        factory.setTransportIds(ids);
        destinationFactoryManager.registerDestinationFactory("http://cxf.apache.org/transports/http/configuration", (DestinationFactory)factory);
        destinationFactoryManager.registerDestinationFactory("http://cxf.apache.org/bindings/xformat", (DestinationFactory)factory);
        destinationFactoryManager.registerDestinationFactory("http://www.w3.org/2003/05/soap/bindings/HTTP/", (DestinationFactory)factory);
        destinationFactoryManager.registerDestinationFactory("http://schemas.xmlsoap.org/soap/http", (DestinationFactory)factory);
        destinationFactoryManager.registerDestinationFactory("http://schemas.xmlsoap.org/wsdl/http/", (DestinationFactory)factory);
        destinationFactoryManager.registerDestinationFactory("http://schemas.xmlsoap.org/wsdl/soap/http", (DestinationFactory)factory);
        this.endpoint = this.publishEndpoint(target);
        this.destination = (GeronimoDestination)this.endpoint.getServer().getDestination();
    }

    public void invoke(WebServiceContainer.Request request, WebServiceContainer.Response response) throws Exception {
        if (request.getMethod() == 1) {
            this.processGET(request, response);
        } else {
            this.processPOST(request, response);
        }
    }

    protected void processGET(WebServiceContainer.Request request, WebServiceContainer.Response response) throws Exception {
        if (request.getParameter("xsd") != null || request.getParameter("XSD") != null) {
            this.getWsdl(request, response);
        } else {
            EndpointInfo ei = this.destination.getEndpointInfo();
            response.setContentType("text/html");
            PrintWriter pw = new PrintWriter(response.getOutputStream());
            pw.write("<html><title>Web Service</title><body>");
            pw.write("Hi, this is '" + ei.getService().getName().getLocalPart() + "' web service.");
            pw.write("</body></html>");
            pw.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processPOST(WebServiceContainer.Request request, WebServiceContainer.Response response) throws Exception {
        SAAJUniverse universe = new SAAJUniverse();
        universe.set(SAAJUniverse.DEFAULT);
        try {
            this.destination.invoke(request, response);
        }
        finally {
            universe.unset();
        }
    }

    public void getWsdl(WebServiceContainer.Request request, WebServiceContainer.Response response) throws Exception {
        GeronimoQueryHandler queryHandler = new GeronimoQueryHandler(this.bus);
        URI requestURI = request.getURI();
        EndpointInfo ei = this.destination.getEndpointInfo();
        OutputStream out = response.getOutputStream();
        String baseUri = requestURI.toString();
        response.setContentType("text/xml");
        queryHandler.writeResponse(baseUri, null, ei, out);
    }

    public void destroy() {
        if (this.endpoint != null) {
            this.endpoint.stop();
        }
    }

    protected abstract CXFEndpoint publishEndpoint(Object var1);

    public static Bus getBus() {
        BusFactory.getDefaultBus();
        return new ExtensionManagerBus();
    }
}

