/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.concurrent.impl.handlers;

import java.util.ArrayList;
import java.util.Iterator;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.transaction.UserTransaction;
import org.apache.geronimo.concurrent.impl.handlers.TransactionContextHandler;
import org.apache.geronimo.transaction.GeronimoUserTransaction;
import org.apache.xbean.naming.context.ContextFlyweight;
import org.apache.xbean.naming.context.ContextUtil;
import org.apache.xbean.naming.reference.SimpleReference;

public class UserTransactionContext
extends ContextFlyweight {
    private static final String USER_TRANSACTION = "UserTransaction";
    private Context componentContext;

    public UserTransactionContext(Context componentContext) {
        this.componentContext = componentContext;
    }

    public static boolean hasUserTransaction(Context componentContext) {
        UserTransaction userTransaction = UserTransactionContext.getUserTransaction(componentContext);
        return userTransaction != null;
    }

    public static UserTransaction getUserTransaction(Context componentContext) {
        try {
            return (UserTransaction)componentContext.lookup(USER_TRANSACTION);
        }
        catch (NamingException e) {
            return null;
        }
    }

    protected Context getContext() throws NamingException {
        return this.componentContext;
    }

    public Object lookup(Name name) throws NamingException {
        if (name != null && name.size() == 1 && name.get(0).equals(USER_TRANSACTION)) {
            return this.getUserTransaction();
        }
        return super.lookup(name);
    }

    public Object lookup(String name) throws NamingException {
        if (name != null && name.equals(USER_TRANSACTION)) {
            return this.getUserTransaction();
        }
        return super.lookup(name);
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        return this.list(this.getNameParser(name).parse(name));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (name.isEmpty()) {
            return this.list();
        }
        Object target = null;
        try {
            target = super.lookup(name);
        }
        catch (NamingException e) {
            throw new NotContextException(name.toString());
        }
        if (target == this) {
            return this.list();
        }
        if (target instanceof Context) {
            return ((Context)target).list("");
        }
        throw new NotContextException("The name " + name + " cannot be listed");
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        return this.listBindings(this.getNameParser(name).parse(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (name.isEmpty()) {
            return this.listBindings();
        }
        Object target = null;
        try {
            target = super.lookup(name);
        }
        catch (NamingException e) {
            throw new NotContextException(name.toString());
        }
        if (target == this) {
            return this.listBindings();
        }
        if (target instanceof Context) {
            return ((Context)target).listBindings("");
        }
        throw new NotContextException("The name " + name + " cannot be listed");
    }

    private NamingEnumeration listBindings() throws NamingException {
        NamingEnumeration e = super.listBindings("");
        ArrayList<Binding> list = new ArrayList<Binding>();
        while (e.hasMore()) {
            Binding binding = (Binding)e.next();
            list.add(binding);
        }
        list.add((Binding)new ContextUtil.ReadOnlyBinding(USER_TRANSACTION, (Object)new UserTransactionReference(), (Context)((Object)this)));
        return new ListNamingEnumeration(list.iterator());
    }

    private NamingEnumeration list() throws NamingException {
        NamingEnumeration e = super.list("");
        ArrayList<NameClassPair> list = new ArrayList<NameClassPair>();
        while (e.hasMore()) {
            NameClassPair nameClassPair = (NameClassPair)e.next();
            list.add(nameClassPair);
        }
        list.add(new NameClassPair(USER_TRANSACTION, UserTransaction.class.getName()));
        return new ListNamingEnumeration(list.iterator());
    }

    private Object getUserTransaction() throws NamingException {
        return new GeronimoUserTransaction(TransactionContextHandler.getTransactionManager());
    }

    private static class ListNamingEnumeration
    implements NamingEnumeration {
        private Iterator iter;

        public ListNamingEnumeration(Iterator iter) {
            this.iter = iter;
        }

        public void close() throws NamingException {
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public boolean hasMoreElements() {
            return this.iter.hasNext();
        }

        public Object nextElement() {
            return this.iter.next();
        }
    }

    private class UserTransactionReference
    extends SimpleReference {
        private UserTransactionReference() {
        }

        public Object getContent() throws NamingException {
            return UserTransactionContext.this.getUserTransaction();
        }

        public String getClassName() {
            return UserTransaction.class.getName();
        }
    }
}

