/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.concurrent.impl.handlers;

import java.util.Map;
import javax.security.jacc.PolicyContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.concurrent.ManagedContextHandler;
import org.apache.geronimo.security.Callers;
import org.apache.geronimo.security.ContextManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityContextHandler
implements ManagedContextHandler {
    private static final Log LOG = LogFactory.getLog(SecurityContextHandler.class);
    private static final String OLD_CALLERS = SecurityContextHandler.class.getName() + ".oldCallers";
    private static final String OLD_CONTEXT_ID = SecurityContextHandler.class.getName() + ".oldContextId";
    private static final String NEW_CALLERS = SecurityContextHandler.class.getName() + ".newCallers";
    private static final String NEW_CONTEXT_ID = SecurityContextHandler.class.getName() + ".newContextId";

    public void saveContext(Map<String, Object> context) {
        LOG.debug((Object)"saveContext");
        context.put(NEW_CONTEXT_ID, PolicyContext.getContextID());
        context.put(NEW_CALLERS, ContextManager.getCallers());
    }

    public void setContext(Map<String, Object> threadContext) {
        LOG.debug((Object)"setContext");
        threadContext.put(OLD_CONTEXT_ID, PolicyContext.getContextID());
        threadContext.put(OLD_CALLERS, ContextManager.getCallers());
        String contextId = (String)threadContext.get(NEW_CONTEXT_ID);
        Callers callers = (Callers)threadContext.get(NEW_CALLERS);
        PolicyContext.setContextID((String)contextId);
        ContextManager.popCallers((Callers)callers);
    }

    public void unsetContext(Map<String, Object> threadContext) {
        LOG.debug((Object)"unsetContext");
        String contextId = (String)threadContext.get(OLD_CONTEXT_ID);
        Callers callers = (Callers)threadContext.get(OLD_CALLERS);
        PolicyContext.setContextID((String)contextId);
        ContextManager.popCallers((Callers)callers);
    }
}

