/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.concurrent.impl.executor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.concurrent.impl.GBeanBuilder;
import org.apache.geronimo.concurrent.impl.executor.ServerManagedScheduledExecutorServiceGBean;
import org.apache.geronimo.concurrent.impl.thread.GeronimoManagedThreadFactorySource;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.Kernel;

public class ServerManagedScheduledExecutorServiceWrapperGBean
extends GBeanBuilder
implements GBeanLifecycle {
    private static final Log LOG = LogFactory.getLog(ServerManagedScheduledExecutorServiceWrapperGBean.class);
    public static final GBeanInfo GBEAN_INFO;
    private AbstractName name;
    private int corePoolSize;
    private String[] contextHandlerClasses;
    private AbstractName executorServiceName;
    private ServerManagedScheduledExecutorServiceGBean executorServiceGBean;

    public ServerManagedScheduledExecutorServiceWrapperGBean(Kernel kernel, AbstractName name, ClassLoader classLoader, int corePoolSize, GeronimoManagedThreadFactorySource threadFactorySource, String[] contextHandlerClasses) {
        super(kernel, classLoader);
        this.name = name;
        this.contextHandlerClasses = contextHandlerClasses;
        this.corePoolSize = corePoolSize;
    }

    public void doStart() throws Exception {
        String threadName = (String)this.name.getName().get("name");
        this.executorServiceName = this.kernel.getNaming().createRootName(this.name.getArtifact(), threadName, "ManagedExecutorService");
        GBeanData executorServiceData = new GBeanData(this.executorServiceName, ServerManagedScheduledExecutorServiceGBean.getGBeanInfo());
        executorServiceData.setAttribute("contextHandlers", (Object)this.contextHandlerClasses);
        executorServiceData.setAttribute("corePoolSize", (Object)this.corePoolSize);
        GBeanData wrapperData = this.kernel.getGBeanData(this.name);
        executorServiceData.setReferencePatterns("threadFactory", wrapperData.getReferencePatterns("threadFactory"));
        this.addGBeanKernel(this.executorServiceName, executorServiceData);
        this.executorServiceGBean = (ServerManagedScheduledExecutorServiceGBean)this.kernel.getGBean(this.executorServiceName);
        this.executorServiceGBean.verifyObjectName();
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doStop() throws Exception {
        this.executorServiceGBean = null;
        if (this.executorServiceName != null) {
            this.removeGBeanKernel(this.executorServiceName);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(ServerManagedScheduledExecutorServiceWrapperGBean.class, (String)"ManagedThreadFactoryBuilder");
        infoFactory.addAttribute("classLoader", ClassLoader.class, false, false);
        infoFactory.addAttribute("abstractName", AbstractName.class, false, false);
        infoFactory.addAttribute("kernel", Kernel.class, false, false);
        infoFactory.addAttribute("corePoolSize", Integer.TYPE, true);
        infoFactory.addAttribute("contextHandlers", String[].class, true);
        infoFactory.addReference("threadFactory", GeronimoManagedThreadFactorySource.class);
        infoFactory.setConstructor(new String[]{"kernel", "abstractName", "classLoader", "corePoolSize", "threadFactory", "contextHandlers"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

