/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.concurrent.impl;

import java.util.concurrent.atomic.AtomicInteger;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.system.jmx.MBeanServerKernelBridge;

public class NotificationHelper {
    private static final Log LOG = LogFactory.getLog(NotificationHelper.class);
    private AtomicInteger notificationSequence = new AtomicInteger(1);
    private NotificationBroadcasterSupport notificationBroadcasterSupport;
    private String objectName;

    public NotificationHelper(Kernel kernel, AbstractName name) {
        this.notificationBroadcasterSupport = NotificationHelper.getNotificationBroadcasterSupport(kernel, name);
        this.objectName = name.getObjectName().getCanonicalName();
    }

    private static NotificationBroadcasterSupport getNotificationBroadcasterSupport(Kernel kernel, AbstractName name) {
        try {
            MBeanServerKernelBridge bridge = (MBeanServerKernelBridge)kernel.getGBean(MBeanServerKernelBridge.class);
            return bridge.getNotificationBroadcasterSupport(name);
        }
        catch (Exception e) {
            LOG.debug((Object)"Failed to lookup MBeanServerKernelBridge", (Throwable)e);
            return null;
        }
    }

    public boolean isNotificationSupported() {
        return this.notificationBroadcasterSupport != null;
    }

    public void sendNotification(String type, Object userData) {
        if (!this.isNotificationSupported()) {
            return;
        }
        Notification notification = new Notification(type, this.objectName, this.notificationSequence.getAndIncrement());
        notification.setUserData(userData);
        this.notificationBroadcasterSupport.sendNotification(notification);
    }
}

