/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.concurrent.impl;

import java.util.Hashtable;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.j2ee.management.impl.InvalidObjectNameException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelException;
import org.apache.geronimo.kernel.ObjectNameUtil;

public class GBeanBuilder {
    protected Kernel kernel;
    protected ClassLoader classLoader;

    public GBeanBuilder(Kernel kernel, ClassLoader classLoader) {
        this.kernel = kernel;
        this.classLoader = classLoader;
    }

    protected void addGBeanKernel(AbstractName gbeanName, GBeanData threadData) throws KernelException {
        this.kernel.loadGBean(threadData, this.classLoader);
        this.kernel.startRecursiveGBean(gbeanName);
    }

    protected void removeGBeanKernel(AbstractName gbeanName) {
        try {
            if (this.kernel.getGBeanState(gbeanName) == 1) {
                this.kernel.stopGBean(gbeanName);
            }
            this.kernel.unloadGBean(gbeanName);
        }
        catch (GBeanNotFoundException gBeanNotFoundException) {
            // empty catch block
        }
    }

    public static void verifyObjectName(String objectNameStr, String j2eeType, String name) {
        ObjectName objectName = ObjectNameUtil.getObjectName((String)objectNameStr);
        if (objectName.isPattern()) {
            throw new InvalidObjectNameException("ObjectName can not be a pattern", objectName);
        }
        Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
        if (!j2eeType.equals(keyPropertyList.get("j2eeType"))) {
            throw new InvalidObjectNameException(name + " object name j2eeType property must be '" + j2eeType + "'", objectName);
        }
        if (!keyPropertyList.containsKey("name")) {
            throw new InvalidObjectNameException(name + " object must contain a name property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEServer")) {
            throw new InvalidObjectNameException(name + " object name must contain a J2EEServer property", objectName);
        }
        if (keyPropertyList.size() != 3) {
            throw new InvalidObjectNameException(name + " object name can only have j2eeType, name, and J2EEServer properties", objectName);
        }
    }
}

