/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.common;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentException
extends Exception {
    private final List<? extends Throwable> causes;

    public DeploymentException() {
        this.causes = null;
    }

    public DeploymentException(Throwable cause) {
        super(cause);
        this.causes = null;
    }

    public DeploymentException(String message) {
        super(message);
        this.causes = null;
    }

    public DeploymentException(String message, Throwable cause) {
        super(message, cause);
        this.causes = null;
    }

    public DeploymentException(String message, List<? extends Throwable> causes) {
        super(message);
        this.causes = causes;
    }

    @Override
    public void printStackTrace(PrintStream ps) {
        super.printStackTrace(ps);
        if (this.causes != null) {
            for (Throwable throwable : this.causes) {
                throwable.printStackTrace(ps);
            }
        }
    }

    @Override
    public void printStackTrace(PrintWriter pw) {
        super.printStackTrace(pw);
        if (this.causes != null) {
            for (Throwable throwable : this.causes) {
                throwable.printStackTrace(pw);
            }
        }
    }

    public DeploymentException cleanse() {
        if (null != this.getCause()) {
            return DeploymentException.cleanse(this);
        }
        if (this.causes != null) {
            ArrayList<CleanseException> cleansedCauses = new ArrayList<CleanseException>(this.causes.size());
            for (Throwable throwable : this.causes) {
                CleanseException cleansed = DeploymentException.cleanse(throwable);
                cleansedCauses.add(cleansed);
            }
            return new DeploymentException(this.getMessage(), cleansedCauses);
        }
        return this;
    }

    protected static CleanseException cleanse(Throwable root) {
        CleanseException previousEx = null;
        CleanseException rootEx = null;
        while (null != root) {
            Throwable e = root.getCause();
            CleanseException exception = new CleanseException(root.getMessage(), root.toString());
            if (null == rootEx) {
                rootEx = exception;
            }
            exception.setStackTrace(root.getStackTrace());
            if (null != previousEx) {
                previousEx.initCause(exception);
            }
            previousEx = exception;
            root = e;
        }
        return rootEx;
    }

    private static class CleanseException
    extends DeploymentException {
        private final String toString;

        public CleanseException(String message, String toString) {
            super(message);
            this.toString = toString;
        }

        public String toString() {
            return this.toString;
        }
    }
}

