/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.client;

import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.geronimo.client.AppClientPlugin;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.jndi.JndiKey;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.naming.enc.EnterpriseNamingContext;
import org.apache.geronimo.naming.java.RootContext;

public class StaticJndiContextPlugin
implements AppClientPlugin {
    private final Context context;
    public static final GBeanInfo GBEAN_INFO;

    public StaticJndiContextPlugin(Map<JndiKey, Map<String, Object>> contexts, Kernel kernel, ClassLoader classLoader) throws NamingException {
        HashMap<String, Object> clientContext = new HashMap<String, Object>();
        for (Map<String, Object> context : contexts.values()) {
            clientContext.putAll(context);
        }
        this.context = EnterpriseNamingContext.livenReferences(clientContext, null, (Kernel)kernel, (ClassLoader)classLoader, (String)"comp/");
    }

    @Override
    public void startClient(AbstractName appClientModuleName, Kernel kernel, ClassLoader classLoader) throws Exception {
        RootContext.setComponentContext((Context)this.context);
        new InitialContext().lookup("java:comp/env");
    }

    @Override
    public void stopClient(AbstractName appClientModuleName) throws Exception {
        RootContext.setComponentContext(null);
    }

    @Override
    public Context getJndiContext() {
        return this.context;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(StaticJndiContextPlugin.class);
        infoFactory.addAttribute("context", Map.class, true);
        infoFactory.addAttribute("jndiContext", Context.class, false);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.addInterface(AppClientPlugin.class);
        infoFactory.setConstructor(new String[]{"context", "kernel", "classLoader"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

