/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.client.builder;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.geronimo.client.AppClientContainer;
import org.apache.geronimo.client.StaticJndiContextPlugin;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilderCollection;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.xbeans.EnvironmentType;
import org.apache.geronimo.deployment.xbeans.PatternType;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.SingleElementCollection;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.j2ee.deployment.AppClientModule;
import org.apache.geronimo.j2ee.deployment.ApplicationInfo;
import org.apache.geronimo.j2ee.deployment.ConnectorModule;
import org.apache.geronimo.j2ee.deployment.CorbaGBeanNameSource;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.j2ee.deployment.ModuleBuilderExtension;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.deployment.NamingBuilderCollection;
import org.apache.geronimo.j2ee.jndi.ApplicationJndi;
import org.apache.geronimo.j2ee.jndi.JndiKey;
import org.apache.geronimo.j2ee.jndi.JndiScope;
import org.apache.geronimo.j2ee.management.impl.J2EEAppClientModuleImpl;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationAlreadyExistsException;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.kernel.util.FileUtils;
import org.apache.geronimo.kernel.util.JarUtils;
import org.apache.geronimo.kernel.util.NestedJarFile;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.security.deploy.SubjectInfo;
import org.apache.geronimo.xbeans.connector.GerConnectorType;
import org.apache.geronimo.xbeans.geronimo.client.GerApplicationClientDocument;
import org.apache.geronimo.xbeans.geronimo.client.GerApplicationClientType;
import org.apache.geronimo.xbeans.geronimo.client.GerResourceType;
import org.apache.geronimo.xbeans.geronimo.security.GerSubjectInfoType;
import org.apache.openejb.jee.ApplicationClient;
import org.apache.openejb.jee.JaxbJavaee;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.xbean.finder.AbstractFinder;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean(j2eeType="ModuleBuilder")
public class AppClientModuleBuilder
implements ModuleBuilder,
CorbaGBeanNameSource,
GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(AppClientModuleBuilder.class);
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final String GERAPPCLIENT_NAMESPACE = GerApplicationClientDocument.type.getDocumentElementName().getNamespaceURI();
    private static final Map<String, String> NAMESPACE_UPDATES = new HashMap<String, String>();
    private final Environment defaultClientEnvironment;
    private final Environment defaultServerEnvironment;
    private final AbstractNameQuery corbaGBeanObjectName;
    private final AbstractNameQuery transactionManagerObjectName;
    private final AbstractNameQuery connectionTrackerObjectName;
    private final AbstractNameQuery credentialStoreName;
    private final SingleElementCollection<ModuleBuilder> connectorModuleBuilder;
    private final NamespaceDrivenBuilderCollection serviceBuilder;
    private final NamingBuilderCollection namingBuilders;
    private final Collection<ModuleBuilderExtension> moduleBuilderExtensions;
    private final Collection<Repository> repositories;
    private final ArtifactResolver clientArtifactResolver;
    private final URI uri;
    private AbstractNameQuery globalContextAbstractName;

    public AppClientModuleBuilder(Environment defaultClientEnvironment, Environment defaultServerEnvironment, AbstractNameQuery transactionManagerObjectName, AbstractNameQuery connectionTrackerObjectName, AbstractNameQuery corbaGBeanObjectName, AbstractNameQuery credentialStoreName, AbstractNameQuery globalContextAbstractName, Collection<Repository> repositories, ModuleBuilder connectorModuleBuilder, NamespaceDrivenBuilder serviceBuilder, Collection<NamingBuilder> namingBuilders, Collection<ModuleBuilderExtension> moduleBuilderExtensions, ArtifactResolver clientArtifactResolver, String host, int port) throws URISyntaxException {
        this(defaultClientEnvironment, defaultServerEnvironment, transactionManagerObjectName, connectionTrackerObjectName, corbaGBeanObjectName, credentialStoreName, globalContextAbstractName, repositories, (SingleElementCollection<ModuleBuilder>)new SingleElementCollection((Object)connectorModuleBuilder), serviceBuilder == null ? Collections.emptySet() : Collections.singleton(serviceBuilder), namingBuilders == null ? Collections.emptySet() : namingBuilders, moduleBuilderExtensions, clientArtifactResolver, host, port);
    }

    public AppClientModuleBuilder(@ParamAttribute(name="transactionManagerObjectName") AbstractNameQuery transactionManagerObjectName, @ParamAttribute(name="connectionTrackerObjectName") AbstractNameQuery connectionTrackerObjectName, @ParamAttribute(name="corbaGBeanObjectName") AbstractNameQuery corbaGBeanObjectName, @ParamAttribute(name="credentialStoreName") AbstractNameQuery credentialStoreName, @ParamAttribute(name="globalContextAbstractName") AbstractNameQuery globalContextAbstractName, @ParamReference(name="Repositories", namingType="Repository") Collection<Repository> repositories, @ParamReference(name="ConnectorModuleBuilder", namingType="ModuleBuilder") Collection<ModuleBuilder> connectorModuleBuilder, @ParamReference(name="ServiceBuilders", namingType="ModuleBuilder") Collection<NamespaceDrivenBuilder> serviceBuilder, @ParamReference(name="NamingBuilders", namingType="ModuleBuilder") Collection<NamingBuilder> namingBuilders, @ParamReference(name="ModuleBuilderExtensions", namingType="ModuleBuilder") Collection<ModuleBuilderExtension> moduleBuilderExtensions, @ParamReference(name="ClientArtifactResolver", namingType="ArtifactResolver") ArtifactResolver clientArtifactResolver, @ParamAttribute(name="defaultClientEnvironment") Environment defaultClientEnvironment, @ParamAttribute(name="defaultServerEnvironment") Environment defaultServerEnvironment, @ParamAttribute(name="host") String host, @ParamAttribute(name="port") int port) throws URISyntaxException {
        this(defaultClientEnvironment, defaultServerEnvironment, transactionManagerObjectName, connectionTrackerObjectName, corbaGBeanObjectName, credentialStoreName, globalContextAbstractName, repositories, (SingleElementCollection<ModuleBuilder>)new SingleElementCollection(connectorModuleBuilder), serviceBuilder, namingBuilders, moduleBuilderExtensions, clientArtifactResolver, host, port);
    }

    private AppClientModuleBuilder(Environment defaultClientEnvironment, Environment defaultServerEnvironment, AbstractNameQuery transactionManagerObjectName, AbstractNameQuery connectionTrackerObjectName, AbstractNameQuery corbaGBeanObjectName, AbstractNameQuery credentialStoreName, AbstractNameQuery globalContextAbstractName, Collection<Repository> repositories, SingleElementCollection<ModuleBuilder> connectorModuleBuilder, Collection<NamespaceDrivenBuilder> serviceBuilder, Collection<NamingBuilder> namingBuilders, Collection<ModuleBuilderExtension> moduleBuilderExtensions, ArtifactResolver clientArtifactResolver, String host, int port) throws URISyntaxException {
        this.defaultClientEnvironment = defaultClientEnvironment;
        this.defaultServerEnvironment = defaultServerEnvironment;
        this.corbaGBeanObjectName = corbaGBeanObjectName;
        this.transactionManagerObjectName = transactionManagerObjectName;
        this.connectionTrackerObjectName = connectionTrackerObjectName;
        this.credentialStoreName = credentialStoreName;
        this.globalContextAbstractName = globalContextAbstractName;
        this.repositories = repositories;
        this.connectorModuleBuilder = connectorModuleBuilder;
        this.serviceBuilder = new NamespaceDrivenBuilderCollection(serviceBuilder);
        this.namingBuilders = new NamingBuilderCollection(namingBuilders);
        this.moduleBuilderExtensions = moduleBuilderExtensions;
        this.clientArtifactResolver = clientArtifactResolver;
        this.uri = host != null ? new URI("ejbd", null, host, port, null, null, null) : null;
    }

    public void doStart() throws Exception {
        XmlBeansUtil.registerNamespaceUpdates(NAMESPACE_UPDATES);
    }

    public void doStop() {
        XmlBeansUtil.unregisterNamespaceUpdates(NAMESPACE_UPDATES);
    }

    public void doFail() {
        this.doStop();
    }

    public AbstractNameQuery getCorbaGBeanName() {
        return this.corbaGBeanObjectName;
    }

    private ModuleBuilder getConnectorModuleBuilder() {
        return (ModuleBuilder)this.connectorModuleBuilder.getElement();
    }

    public Module createModule(Bundle bundle, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        return null;
    }

    public Module createModule(File plan, JarFile moduleFile, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        return this.createModule(plan, moduleFile, "app-client.jar", null, null, null, naming, idBuilder);
    }

    public Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment environment, Object moduleContextInfo, Module parentModule, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        return this.createModule(plan, moduleFile, targetPath, specDDUrl, environment, parentModule, naming, idBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment earEnvironment, Module parentModule, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        GerResourceType[] resources;
        String mainClass;
        assert (moduleFile != null) : "moduleFile is null";
        assert (targetPath != null) : "targetPath is null";
        assert (!targetPath.endsWith("/")) : "targetPath must not end with a '/'";
        assert (parentModule == null == (earEnvironment == null)) : "if earName is not null you must supply earEnvironment as well";
        boolean standAlone = earEnvironment == null;
        try {
            Manifest manifest = moduleFile.getManifest();
            if (manifest == null) {
                return null;
            }
            mainClass = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            if (mainClass == null) {
                return null;
            }
            String classPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            if (standAlone && classPath != null) {
                throw new DeploymentException("Manifest class path entry is not allowed in a standalone jar (JAVAEE 5 Section 8.2)");
            }
        }
        catch (IOException e) {
            throw new DeploymentException("Could not get manifest from app client module: " + moduleFile.getName(), (Throwable)e);
        }
        String specDD = null;
        ApplicationClient appClient = null;
        try {
            if (specDDUrl == null) {
                specDDUrl = JarUtils.createJarURL((JarFile)moduleFile, (String)"META-INF/application-client.xml");
            }
            specDD = JarUtils.readAll((URL)specDDUrl);
        }
        catch (Exception e) {
            appClient = new ApplicationClient();
            try {
                specDD = JaxbJavaee.marshal(ApplicationClient.class, (Object)appClient);
            }
            catch (JAXBException e1) {
                // empty catch block
            }
        }
        if (appClient == null) {
            try {
                InputStream in = specDDUrl.openStream();
                try {
                    appClient = (ApplicationClient)JaxbJavaee.unmarshalJavaee(ApplicationClient.class, (InputStream)in);
                }
                finally {
                    in.close();
                }
            }
            catch (Exception e) {
                throw new DeploymentException("Unable to parse application-client.xml", (Throwable)e);
            }
        }
        GerApplicationClientType gerAppClient = this.getGeronimoAppClient(plan, moduleFile, standAlone, targetPath, appClient, earEnvironment);
        EnvironmentType clientEnvironmentType = gerAppClient.getClientEnvironment();
        Environment clientEnvironment = EnvironmentBuilder.buildEnvironment((EnvironmentType)clientEnvironmentType, (Environment)this.defaultClientEnvironment);
        if (standAlone) {
            String name = new File(moduleFile.getName()).getName();
            idBuilder.resolve(clientEnvironment, name + "_" + name, "car");
        } else {
            Artifact earConfigId = earEnvironment.getConfigId();
            idBuilder.resolve(clientEnvironment, earConfigId.getArtifactId() + "_" + targetPath, "car");
        }
        EnvironmentType serverEnvironmentType = gerAppClient.getServerEnvironment();
        Environment serverEnvironment = EnvironmentBuilder.buildEnvironment((EnvironmentType)serverEnvironmentType, (Environment)this.defaultServerEnvironment);
        if (!standAlone) {
            EnvironmentBuilder.mergeEnvironments((Environment)earEnvironment, (Environment)serverEnvironment);
            serverEnvironment = earEnvironment;
            if (!serverEnvironment.getConfigId().isResolved()) {
                throw new IllegalStateException("Server environment module ID should be fully resolved (not " + serverEnvironment.getConfigId() + ")");
            }
        } else {
            idBuilder.resolve(serverEnvironment, new File(moduleFile.getName()).getName(), "car");
        }
        AbstractName earName = parentModule == null ? naming.createRootName(serverEnvironment.getConfigId(), "null", "J2EEApplication") : parentModule.getModuleName();
        AbstractName moduleName = naming.createChildName(earName, clientEnvironment.getConfigId().toString(), "AppClientModule");
        AbstractName clientBaseName = naming.createRootName(clientEnvironment.getConfigId(), clientEnvironment.getConfigId().toString(), "J2EEApplication");
        String name = null;
        name = appClient.getModuleName() != null ? appClient.getModuleName().trim() : (standAlone ? FileUtils.removeExtension((String)new File(moduleFile.getName()).getName(), (String)".jar") : FileUtils.removeExtension((String)targetPath, (String)".jar"));
        Map jndiContext = Module.share((EnumSet)Module.APP, (Map)(parentModule == null ? null : parentModule.getJndiContext()));
        AppClientModule module = new AppClientModule(standAlone, moduleName, name, clientBaseName, serverEnvironment, clientEnvironment, moduleFile, targetPath, appClient, mainClass, (XmlObject)gerAppClient, specDD, jndiContext, parentModule);
        for (GerResourceType resource : resources = gerAppClient.getResourceArray()) {
            String path;
            Object connectorFile;
            if (resource.isSetExternalRar()) {
                PatternType externalRar = resource.getExternalRar();
                String groupId = this.trim(externalRar.getGroupId());
                String artifactId = this.trim(externalRar.getArtifactId());
                String version = this.trim(externalRar.getVersion());
                String type = this.trim(externalRar.getType());
                Artifact artifact = new Artifact(groupId, artifactId, version, type);
                try {
                    artifact = this.clientArtifactResolver.resolveInClassLoader(artifact);
                }
                catch (MissingDependencyException e) {
                    throw new DeploymentException("Could not resolve external rar location in repository: " + artifact, (Throwable)e);
                }
                File file = null;
                for (Repository repository : this.repositories) {
                    if (!repository.contains(artifact)) continue;
                    file = repository.getLocation(artifact);
                    break;
                }
                if (file == null) {
                    throw new DeploymentException("Missing external rar in repositories: " + artifact);
                }
                try {
                    connectorFile = new JarFile(file);
                }
                catch (IOException e) {
                    throw new DeploymentException("Could not access external rar contents for artifact: " + artifact, (Throwable)e);
                }
                path = artifact.toString();
            } else {
                path = resource.getInternalRar();
                try {
                    JarUtils.assertTempFile();
                    connectorFile = new NestedJarFile(moduleFile, path);
                }
                catch (IOException e) {
                    throw new DeploymentException("Could not locate connector inside ear", (Throwable)e);
                }
            }
            GerConnectorType connectorPlan = resource.getConnector();
            ConnectorModule connectorModule = (ConnectorModule)this.getConnectorModuleBuilder().createModule((Object)connectorPlan, (JarFile)connectorFile, path, null, clientEnvironment, null, (Module)module, naming, idBuilder);
            module.getModules().add(connectorModule);
        }
        for (ModuleBuilderExtension mbe : this.moduleBuilderExtensions) {
            mbe.createModule((Module)module, plan, moduleFile, targetPath, specDDUrl, clientEnvironment, null, earName, naming, idBuilder);
        }
        if (standAlone) {
            Map appJndiContext = Module.share((EnumSet)Module.APP, (Map)module.getJndiContext());
            ApplicationInfo appInfo = new ApplicationInfo(ConfigurationModuleType.CAR, serverEnvironment, earName, name, null, null, null, null, appJndiContext);
            appInfo.getModules().add(module);
            return appInfo;
        }
        return module;
    }

    private String trim(String s) {
        if (s == null) {
            return null;
        }
        return s.trim();
    }

    GerApplicationClientType getGeronimoAppClient(Object plan, JarFile moduleFile, boolean standAlone, String targetPath, ApplicationClient appClient, Environment environment) throws DeploymentException {
        GerApplicationClientType gerAppClient;
        XmlObject rawPlan = null;
        try {
            Object path;
            try {
                if (plan instanceof XmlObject) {
                    rawPlan = (XmlObject)plan;
                } else if (plan != null) {
                    rawPlan = XmlBeansUtil.parse((File)((File)plan));
                } else {
                    path = JarUtils.createJarURL((JarFile)moduleFile, (String)"META-INF/geronimo-application-client.xml");
                    rawPlan = XmlBeansUtil.parse((URL)path, (ClassLoader)this.getClass().getClassLoader());
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (rawPlan != null) {
                gerAppClient = (GerApplicationClientType)SchemaConversionUtils.fixGeronimoSchema((XmlObject)rawPlan, (QName)GerApplicationClientDocument.type.getDocumentElementName(), (SchemaType)GerApplicationClientType.type);
            } else {
                path = standAlone ? new File(moduleFile.getName()).getName() : targetPath;
                gerAppClient = this.createDefaultPlan((String)path, appClient, standAlone, environment);
            }
        }
        catch (XmlException e) {
            throw new DeploymentException("Unable to parse application plan", (Throwable)e);
        }
        return gerAppClient;
    }

    private GerApplicationClientType createDefaultPlan(String name, ApplicationClient appClient, boolean standAlone, Environment environment) {
        String id;
        String string = id = appClient == null ? null : appClient.getId();
        if (id == null) {
            id = name;
            if (id.endsWith(".jar")) {
                id = id.substring(0, id.length() - 4);
            }
            if (id.endsWith("/")) {
                id = id.substring(0, id.length() - 1);
            }
        }
        GerApplicationClientType geronimoAppClient = GerApplicationClientType.Factory.newInstance();
        EnvironmentType clientEnvironmentType = geronimoAppClient.addNewClientEnvironment();
        EnvironmentType serverEnvironmentType = geronimoAppClient.addNewServerEnvironment();
        return geronimoAppClient;
    }

    public void installModule(JarFile earFile, EARContext earContext, Module module, Collection configurationStores, ConfigurationStore targetConfigurationStore, Collection repositories) throws DeploymentException {
        JarFile moduleFile = module.getModuleFile();
        try {
            earContext.addIncludeAsPackedJar(URI.create(module.getTargetPath()), moduleFile);
        }
        catch (IOException e) {
            throw new DeploymentException("Unable to copy app client module jar into configuration: " + moduleFile.getName(), (Throwable)e);
        }
        AppClientModule appClientModule = (AppClientModule)module;
        appClientModule.setEarFile(earFile);
        Environment clientEnvironment = appClientModule.getEnvironment();
        try {
            targetConfigurationStore.createNewConfigurationDir(clientEnvironment.getConfigId());
        }
        catch (ConfigurationAlreadyExistsException e) {
            throw new DeploymentException("Unable to create configuration directory for " + clientEnvironment.getConfigId(), (Throwable)e);
        }
        EARContext appClientDeploymentContext = null;
        try {
            File tempDirectory = FileUtils.createTempDir();
            appClientDeploymentContext = new EARContext(tempDirectory, null, clientEnvironment, ConfigurationModuleType.CAR, appClientModule.getAppClientName(), this.transactionManagerObjectName, this.connectionTrackerObjectName, this.corbaGBeanObjectName, earContext);
            appClientModule.setEarContext(appClientDeploymentContext);
            appClientModule.setRootEarContext(earContext);
            if (module.getParentModule() != null) {
                LinkedHashSet libClasspath = module.getParentModule().getClassPath();
                for (String libEntryPath : libClasspath) {
                    if (!libEntryPath.endsWith(".jar")) continue;
                    try {
                        JarUtils.assertTempFile();
                        NestedJarFile library = new NestedJarFile(earFile, libEntryPath);
                        appClientDeploymentContext.addIncludeAsPackedJar(URI.create(libEntryPath), (JarFile)library);
                    }
                    catch (IOException e) {
                        throw new DeploymentException("Could not add to app client library classpath: " + libEntryPath, (Throwable)e);
                    }
                }
                module.getClassPath().addAll(libClasspath);
                Enumeration<JarEntry> ear_entries = earFile.entries();
                while (ear_entries.hasMoreElements()) {
                    ZipEntry ear_entry = ear_entries.nextElement();
                    URI targetPath = module.getParentModule().resolve(ear_entry.getName());
                    if (ear_entry.getName().endsWith(".jar") || ear_entry.getName().endsWith(".war") || ear_entry.getName().endsWith(".rar") || ear_entry.getName().startsWith("META-INF")) continue;
                    appClientDeploymentContext.addFile(targetPath, (ZipFile)earFile, ear_entry);
                }
            }
            LinkedHashSet appClientModuleClasspaths = module.getClassPath();
            try {
                URI moduleBase = new URI(module.getTargetPath());
                appClientDeploymentContext.addIncludeAsPackedJar(moduleBase, moduleFile);
                this.addManifestClassPath((DeploymentContext)appClientDeploymentContext, appClientModule.getEarFile(), moduleFile, moduleBase);
            }
            catch (IOException e) {
                throw new DeploymentException("Unable to copy app client module jar into configuration: " + moduleFile.getName(), (Throwable)e);
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Unable to get app client module base URI " + module.getTargetPath(), (Throwable)e);
            }
            if (module.getParentModule() != null) {
                appClientModuleClasspaths.add(module.getTargetPath());
                EARContext moduleContext = module.getEarContext();
                LinkedHashSet moduleLocations = module.getParentModule().getModuleLocations();
                URI baseUri = URI.create(module.getTargetPath());
                moduleContext.getCompleteManifestClassPath(module.getDeployable(), baseUri, URI.create("."), (Collection)appClientModuleClasspaths, (Collection)moduleLocations);
                for (String classpath : appClientModuleClasspaths) {
                    appClientDeploymentContext.addToClassPath(classpath);
                    if (!classpath.endsWith(".jar")) continue;
                    JarUtils.assertTempFile();
                    NestedJarFile library = new NestedJarFile(earFile, classpath);
                    appClientDeploymentContext.addIncludeAsPackedJar(URI.create(classpath), (JarFile)library);
                }
            }
            for (Module connectorModule : appClientModule.getModules()) {
                if (!(connectorModule instanceof ConnectorModule)) continue;
                this.getConnectorModuleBuilder().installModule(connectorModule.getModuleFile(), appClientDeploymentContext, connectorModule, configurationStores, targetConfigurationStore, repositories);
            }
            for (ModuleBuilderExtension mbe : this.moduleBuilderExtensions) {
                mbe.installModule(module.getModuleFile(), appClientDeploymentContext, module, configurationStores, targetConfigurationStore, repositories);
            }
        }
        catch (DeploymentException e) {
            this.closeAppClientContextOnException(appClientDeploymentContext);
            throw e;
        }
        catch (IOException e) {
            this.closeAppClientContextOnException(appClientDeploymentContext);
            throw new DeploymentException((Throwable)e);
        }
    }

    public void initContext(EARContext earContext, Module clientModule, Bundle bundle) throws DeploymentException {
        try {
            AppClientModule appClientModule = (AppClientModule)clientModule;
            this.namingBuilders.buildEnvironment((JndiConsumer)appClientModule.getSpecDD(), (XmlObject)appClientModule.getVendorDD(), clientModule.getEnvironment());
            for (Module connectorModule : appClientModule.getModules()) {
                if (!(connectorModule instanceof ConnectorModule)) continue;
                this.getConnectorModuleBuilder().initContext(appClientModule.getEarContext(), connectorModule, bundle);
            }
            for (ModuleBuilderExtension mbe : this.moduleBuilderExtensions) {
                mbe.initContext(earContext, clientModule, bundle);
            }
        }
        catch (DeploymentException e) {
            this.closeAppClientContextOnException(clientModule.getEarContext());
            throw e;
        }
        catch (Exception e) {
            this.closeAppClientContextOnException(clientModule.getEarContext());
            throw new DeploymentException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGBeans(EARContext earContext, Module module, Bundle earBundle, Collection repositories) throws DeploymentException {
        AbstractName appJndiName = module.getEarContext().getNaming().createChildName(earContext.getModuleName(), "ApplicationJndi", "ApplicationJndi");
        module.getEarContext().getGeneralData().put(EARContext.APPLICATION_JNDI_NAME_KEY, appJndiName);
        GBeanData appContexts = new GBeanData(appJndiName, ApplicationJndi.class);
        appContexts.setAttribute("globalContextSegment", module.getJndiContext().get(JndiScope.global));
        appContexts.setAttribute("applicationContextMap", module.getJndiContext().get(JndiScope.app));
        appContexts.setReferencePattern("GlobalContext", this.globalContextAbstractName);
        try {
            module.getEarContext().addGBean(appContexts);
        }
        catch (GBeanAlreadyExistsException e1) {
            throw new DeploymentException((Throwable)e1);
        }
        AppClientModule appClientModule = (AppClientModule)module;
        JarFile moduleFile = module.getModuleFile();
        ApplicationClient appClient = (ApplicationClient)appClientModule.getSpecDD();
        GerApplicationClientType geronimoAppClient = (GerApplicationClientType)appClientModule.getVendorDD();
        AbstractName appClientModuleName = appClientModule.getModuleName();
        GBeanData appClientModuleGBeanData = new GBeanData(appClientModuleName, J2EEAppClientModuleImpl.class);
        try {
            appClientModuleGBeanData.setReferencePattern("J2EEServer", earContext.getServerName());
            if (!module.isStandAlone()) {
                appClientModuleGBeanData.setReferencePattern("J2EEApplication", earContext.getModuleName());
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to initialize AppClientModule GBean", (Throwable)e);
        }
        try {
            earContext.addGBean(appClientModuleGBeanData);
        }
        catch (GBeanAlreadyExistsException e) {
            throw new DeploymentException("Could not add application client module gbean to configuration", (Throwable)e);
        }
        EARContext appClientDeploymentContext = appClientModule.getEarContext();
        Map generalData = earContext.getGeneralData();
        for (Map.Entry entry : generalData.entrySet()) {
            EARContext.Key key = (EARContext.Key)entry.getKey();
            if (!key.getClass().getName().startsWith("org.apache.geronimo.openejb.deployment.EjbModuleBuilder$EarData")) continue;
            appClientDeploymentContext.getGeneralData().put(key, entry.getValue());
            break;
        }
        if (appClientDeploymentContext.getMessageDestinations() != null && earContext.getMessageDestinations() != null) {
            appClientDeploymentContext.getMessageDestinations().putAll(earContext.getMessageDestinations());
        }
        try {
            try {
                Object holder;
                this.namingBuilders.initContext((JndiConsumer)appClient, (XmlObject)geronimoAppClient, (Module)appClientModule);
                Bundle appClientClassBundle = appClientDeploymentContext.getDeploymentBundle();
                if (geronimoAppClient != null) {
                    this.serviceBuilder.build((XmlObject)geronimoAppClient, (DeploymentContext)appClientDeploymentContext, (DeploymentContext)appClientDeploymentContext);
                    for (Module connectorModule : appClientModule.getModules()) {
                        if (!(connectorModule instanceof ConnectorModule)) continue;
                        this.getConnectorModuleBuilder().addGBeans(appClientDeploymentContext, connectorModule, appClientClassBundle, repositories);
                    }
                }
                AbstractName jndiContextName = earContext.getNaming().createChildName(appClientDeploymentContext.getModuleName(), "StaticJndiContext", "StaticJndiContext");
                GBeanData jndiContextGBeanData = new GBeanData(jndiContextName, StaticJndiContextPlugin.class);
                jndiContextGBeanData.setAttribute("uri", (Object)this.uri);
                try {
                    HashMap<EARContext.Key, AbstractName> buildingContext = new HashMap<EARContext.Key, AbstractName>();
                    buildingContext.put(NamingBuilder.GBEAN_NAME_KEY, jndiContextName);
                    Configuration localConfiguration = appClientDeploymentContext.getConfiguration();
                    Configuration remoteConfiguration = earContext.getConfiguration();
                    if (!appClient.isMetadataComplete().booleanValue()) {
                        appClientModule.setClassFinder((AbstractFinder)this.createAppClientClassFinder(appClient, appClientModule));
                    }
                    if (appClient.getMainClass() == null) {
                        appClient.setMainClass(appClientModule.getMainClassName());
                    }
                    String moduleName = module.getName();
                    if (earContext.getSubModuleNames().contains(moduleName)) {
                        log.warn("Duplicated moduleName: '" + moduleName + "' is found ! deployer will rename it to: '" + moduleName + "_duplicated' , please check your modules in application to make sure they don't share the same name");
                        moduleName = moduleName + "_duplicated";
                        earContext.getSubModuleNames().add(moduleName);
                    }
                    earContext.getSubModuleNames().add(moduleName);
                    appClientModule.getJndiScope((JndiKey)JndiScope.module).put("module/ModuleName", moduleName);
                    this.namingBuilders.buildNaming((JndiConsumer)appClient, (XmlObject)geronimoAppClient, (Module)appClientModule, buildingContext);
                    if (!appClient.isMetadataComplete().booleanValue()) {
                        appClient.setMetadataComplete(Boolean.valueOf(true));
                        module.setOriginalSpecDD(module.getSpecDD().toString());
                    }
                    appClientModuleGBeanData.setAttribute("deploymentDescriptor", (Object)appClientModule.getOriginalSpecDD());
                    holder = NamingBuilder.INJECTION_KEY.get(buildingContext);
                    jndiContextGBeanData.setAttribute("context", (Object)appClientModule.getJndiContext());
                }
                catch (DeploymentException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DeploymentException("Unable to construct jndi context for AppClientModule GBean " + appClientModule.getName(), (Throwable)e);
                }
                appClientDeploymentContext.addGBean(jndiContextGBeanData);
                AbstractName appClientContainerName = appClientDeploymentContext.getModuleName();
                GBeanData appClientContainerGBeanData = new GBeanData(appClientContainerName, AppClientContainer.class);
                try {
                    appClientContainerGBeanData.setAttribute("mainClassName", (Object)appClientModule.getMainClassName());
                    appClientContainerGBeanData.setAttribute("appClientModuleName", (Object)appClientModuleName);
                    String callbackHandlerClassName = null;
                    if (appClient.getCallbackHandler() != null) {
                        callbackHandlerClassName = appClient.getCallbackHandler().trim();
                    }
                    if (geronimoAppClient.isSetCallbackHandler()) {
                        callbackHandlerClassName = geronimoAppClient.getCallbackHandler().trim();
                    }
                    String realmName = null;
                    if (geronimoAppClient.isSetRealmName()) {
                        realmName = geronimoAppClient.getRealmName().trim();
                    }
                    if (callbackHandlerClassName != null && realmName == null) {
                        throw new DeploymentException("You must specify a realm name with the callback handler");
                    }
                    if (realmName != null) {
                        appClientContainerGBeanData.setAttribute("realmName", (Object)realmName);
                        appClientContainerGBeanData.setAttribute("callbackHandlerClassName", (Object)callbackHandlerClassName);
                    } else if (geronimoAppClient.isSetDefaultSubject()) {
                        GerSubjectInfoType subjectInfoType = geronimoAppClient.getDefaultSubject();
                        SubjectInfo subjectInfo = this.buildSubjectInfo(subjectInfoType);
                        appClientContainerGBeanData.setAttribute("defaultSubject", (Object)subjectInfo);
                        appClientContainerGBeanData.setReferencePattern("CredentialStore", this.credentialStoreName);
                    } else if (earContext.getSecurityConfiguration() != null) {
                        log.warn("Configuration of app client default subject from ear security configuration no longer supported.");
                    }
                    appClientContainerGBeanData.setReferencePattern("JNDIContext", jndiContextName);
                    appClientContainerGBeanData.setAttribute("holder", holder);
                }
                catch (Exception e) {
                    throw new DeploymentException("Unable to initialize AppClientModule GBean", (Throwable)e);
                }
                appClientDeploymentContext.addGBean(appClientContainerGBeanData);
                for (ModuleBuilderExtension mbe : this.moduleBuilderExtensions) {
                    mbe.addGBeans(appClientDeploymentContext, (Module)appClientModule, appClientClassBundle, repositories);
                }
                earContext.addAdditionalDeployment(appClientDeploymentContext.getConfigurationData());
            }
            finally {
                if (appClientDeploymentContext != null) {
                    try {
                        appClientDeploymentContext.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            if (e instanceof Exception) {
                throw new DeploymentException(e);
            }
            throw new Error(e);
        }
    }

    private static Map<String, Object> getJndiContext(Map<JndiKey, Map<String, Object>> contexts, JndiScope scope) {
        Map<String, Object> context = contexts.get(scope);
        if (context == null) {
            context = new HashMap<String, Object>();
            contexts.put((JndiKey)scope, context);
        }
        return context;
    }

    private ClassFinder createAppClientClassFinder(ApplicationClient appClient, AppClientModule appClientModule) throws DeploymentException {
        ArrayList<Class> classes = new ArrayList<Class>();
        Bundle bundle = appClientModule.getEarContext().getDeploymentBundle();
        String mainClass = appClientModule.getMainClassName();
        try {
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("AppClientModuleBuilder: Could not load main class: " + mainClass, (Throwable)e);
        }
        for (Class mainClas = bundle.loadClass(mainClass); mainClas != null && mainClas != Object.class; mainClas = mainClas.getSuperclass()) {
            classes.add(mainClas);
        }
        if (appClient.getCallbackHandler() != null) {
            Class clas;
            String cls = appClient.getCallbackHandler();
            try {
                clas = bundle.loadClass(cls.trim());
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("AppClientModuleBuilder: Could not load callback-handler class: " + cls, (Throwable)e);
            }
            classes.add(clas);
        }
        return new ClassFinder(classes);
    }

    private SubjectInfo buildSubjectInfo(GerSubjectInfoType defaultSubject) {
        String realmName = defaultSubject.getRealm().trim();
        String id = defaultSubject.getId().trim();
        return new SubjectInfo(realmName, id);
    }

    public String getSchemaNamespace() {
        return GERAPPCLIENT_NAMESPACE;
    }

    public void addManifestClassPath(DeploymentContext deploymentContext, JarFile earFile, JarFile jarFile, URI jarFileLocation) throws DeploymentException {
        Manifest manifest;
        try {
            manifest = jarFile.getManifest();
        }
        catch (IOException e) {
            throw new DeploymentException("Could not read manifest: " + jarFileLocation, (Throwable)e);
        }
        if (manifest == null) {
            return;
        }
        String manifestClassPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        if (manifestClassPath == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(manifestClassPath, " ");
        while (tokenizer.hasMoreTokens()) {
            JarFile classPathJarFile;
            URI pathUri;
            String path = tokenizer.nextToken();
            try {
                pathUri = new URI(path);
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Invalid manifest classpath entry: jarFile=" + jarFileLocation + ", path=" + path, (Throwable)e);
            }
            if (pathUri.isAbsolute()) {
                throw new DeploymentException("Manifest class path entries must be relative (JAVAEE 5 Section 8.2): jarFile=" + jarFileLocation + ", path=" + path);
            }
            Enumeration<JarEntry> ear_entries = earFile.entries();
            URI classPathJarLocation = jarFileLocation.resolve(pathUri);
            File classPathFile = deploymentContext.getTargetFile(classPathJarLocation);
            if (classPathFile.exists()) continue;
            ZipEntry entry = earFile.getEntry(classPathJarLocation.getPath());
            if (entry == null) {
                throw new DeploymentException("Cound not find manifest class path entry: jarFile=" + jarFileLocation + ", path=" + path);
            }
            try {
                if (!entry.getName().endsWith(".jar")) {
                    while (ear_entries.hasMoreElements()) {
                        ZipEntry ear_entry = ear_entries.nextElement();
                        URI targetPath = jarFileLocation.resolve(ear_entry.getName());
                        if (!ear_entry.getName().startsWith(classPathJarLocation.getPath())) continue;
                        deploymentContext.addFile(targetPath, (ZipFile)earFile, ear_entry);
                    }
                } else {
                    deploymentContext.addFile(classPathJarLocation, (ZipFile)earFile, entry);
                }
            }
            catch (IOException e) {
                throw new DeploymentException("Cound not copy manifest class path entry into configuration: jarFile=" + jarFileLocation + ", path=" + path, (Throwable)e);
            }
            if (!classPathFile.getName().endsWith(".jar")) continue;
            try {
                classPathJarFile = new JarFile(classPathFile);
            }
            catch (IOException e) {
                throw new DeploymentException("Manifest class path entries must be a valid jar file (JAVAEE 5 Section 8.2): jarFile=" + jarFileLocation + ", path=" + path, (Throwable)e);
            }
            this.addManifestClassPath(deploymentContext, earFile, classPathJarFile, classPathJarLocation);
        }
    }

    private void closeAppClientContextOnException(EARContext appClientContext) {
        if (appClientContext == null) {
            return;
        }
        try {
            appClientContext.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cleanupAppClientDir(appClientContext.getBaseDir());
    }

    private boolean cleanupAppClientDir(File configurationDir) {
        LinkedList cannotBeDeletedList = new LinkedList();
        if (!FileUtils.recursiveDelete((File)configurationDir, cannotBeDeletedList)) {
            log.warn("Unable to delete " + cannotBeDeletedList.size() + " files while recursively deleting directory " + configurationDir.getAbsolutePath() + LINE_SEP + "The first file that could not be deleted was:" + LINE_SEP + "  " + (!cannotBeDeletedList.isEmpty() ? (String)cannotBeDeletedList.getFirst() : ""));
            return false;
        }
        return true;
    }

    static {
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/application-client", "http://geronimo.apache.org/xml/ns/j2ee/application-client-2.0");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/application-client-1.1", "http://geronimo.apache.org/xml/ns/j2ee/application-client-2.0");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/application-client-1.2", "http://geronimo.apache.org/xml/ns/j2ee/application-client-2.0");
    }
}

