/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis2.osgi;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.jaxws.message.databinding.ClassFinder;
import org.apache.xbean.osgi.bundle.util.BundleClassFinder;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.apache.xbean.osgi.bundle.util.ClassDiscoveryFilter;
import org.apache.xbean.osgi.bundle.util.DiscoveryRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeronimoBundleClassFinder
implements ClassFinder,
SynchronousBundleListener {
    private static final Logger logger = LoggerFactory.getLogger(GeronimoBundleClassFinder.class);
    private Map<Long, Map<String, Set<String>>> bundleIdPackageClassNamesMap = new ConcurrentHashMap<Long, Map<String, Set<String>>>();
    private PackageAdmin packageAdmin;

    public GeronimoBundleClassFinder(PackageAdmin packageAdmin) {
        this.packageAdmin = packageAdmin;
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 8 || event.getType() == 16) {
            this.bundleIdPackageClassNamesMap.remove(event.getBundle().getBundleId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Class> getClassesFromJarFile(final String packageName, ClassLoader cl) throws ClassNotFoundException {
        Map<Object, Object> map;
        Bundle bundle = BundleUtils.getBundle((ClassLoader)cl, (boolean)true);
        if (bundle == null && (bundle = BundleUtils.getBundle((ClassLoader)cl.getParent(), (boolean)true)) == null) {
            return new ArrayList<Class>();
        }
        Long bundleId = bundle.getBundleId();
        Map<String, Set<String>> packageClassNamesMap = this.bundleIdPackageClassNamesMap.get(bundleId);
        Set classNames = null;
        if (packageClassNamesMap == null) {
            map = this.bundleIdPackageClassNamesMap;
            synchronized (map) {
                packageClassNamesMap = this.bundleIdPackageClassNamesMap.get(bundleId);
                if (packageClassNamesMap == null) {
                    packageClassNamesMap = new ConcurrentHashMap<String, Set<String>>();
                    this.bundleIdPackageClassNamesMap.put(bundleId, packageClassNamesMap);
                }
            }
        } else {
            classNames = packageClassNamesMap.get(packageName);
        }
        if (classNames == null) {
            map = packageClassNamesMap;
            synchronized (map) {
                classNames = packageClassNamesMap.get(packageName);
                if (classNames == null) {
                    BundleClassFinder bundleClassFinder = new BundleClassFinder(this.packageAdmin, bundle, new ClassDiscoveryFilter(){

                        public boolean directoryDiscoveryRequired(String directory) {
                            return true;
                        }

                        public boolean jarFileDiscoveryRequired(String jarFile) {
                            return true;
                        }

                        public boolean packageDiscoveryRequired(String p) {
                            return p.equals(packageName);
                        }

                        public boolean rangeDiscoveryRequired(DiscoveryRange discoveryRange) {
                            return discoveryRange == DiscoveryRange.BUNDLE_CLASSPATH;
                        }
                    });
                    classNames = bundleClassFinder.find();
                    packageClassNamesMap.put(packageName, classNames);
                }
            }
        }
        ArrayList<Class> clses = new ArrayList<Class>(classNames.size());
        for (String className : classNames) {
            try {
                Class cls = bundle.loadClass(className);
                cls.getConstructors();
                clses.add(cls);
            }
            catch (Throwable e) {
                String message = "Fail to load class " + className + " in GeronimoBundleClassFinder, it might not be considered while processing SOAP message due to " + e.getMessage();
                if (logger.isDebugEnabled()) {
                    logger.debug(message, e);
                    continue;
                }
                logger.warn(message);
            }
        }
        return clses;
    }

    public void updateClassPath(String filePath, ClassLoader cl) throws Exception {
    }
}

