/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis2.client;

import java.net.URL;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.jaxws.ClientConfigurationFactory;
import org.apache.axis2.jaxws.description.impl.DescriptionFactoryImpl;
import org.apache.axis2.metadata.registry.MetadataFactoryRegistry;
import org.apache.geronimo.axis2.client.Axis2ClientConfigurationFactory;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.Kernel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Axis2ConfigGBean
implements GBeanLifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(Axis2ConfigGBean.class);
    private AbstractName moduleName;
    private ClassLoader classLoder;
    public static final GBeanInfo GBEAN_INFO;

    public Axis2ConfigGBean(ClassLoader classLoader, Kernel kernel, URL configurationBaseUrl, AbstractName moduleName) {
        this.moduleName = moduleName;
        this.classLoder = classLoader;
    }

    public static synchronized Axis2ClientConfigurationFactory registerClientConfigurationFactory() {
        ClientConfigurationFactory factory = (ClientConfigurationFactory)MetadataFactoryRegistry.getFactory(ClientConfigurationFactory.class);
        if (factory instanceof Axis2ClientConfigurationFactory) {
            return (Axis2ClientConfigurationFactory)factory;
        }
        factory = new Axis2ClientConfigurationFactory(false);
        MetadataFactoryRegistry.setFactory(ClientConfigurationFactory.class, (Object)factory);
        LOG.debug("Registered client configuration factory: " + factory);
        if (factory != DescriptionFactoryImpl.getClientConfigurationFactory()) {
            throw new RuntimeException("Client configuration factory was registered too late");
        }
        return (Axis2ClientConfigurationFactory)factory;
    }

    public void doStart() throws Exception {
        Axis2ConfigGBean.registerClientConfigurationFactory();
    }

    public void doStop() throws Exception {
        ConfigurationContext configContext = Axis2ConfigGBean.registerClientConfigurationFactory().clearCache(this.classLoder);
        DescriptionFactoryImpl.clearServiceDescriptionCache((ConfigurationContext)configContext);
    }

    public void doFail() {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(Axis2ConfigGBean.class, Axis2ConfigGBean.class, (String)"GBean");
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("configurationBaseUrl", URL.class, true);
        infoFactory.addAttribute("moduleName", AbstractName.class, true);
        infoFactory.setConstructor(new String[]{"classLoader", "kernel", "configurationBaseUrl", "moduleName"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

