/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis2;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.util.List;
import javax.ejb.EJBAccessException;
import javax.naming.Context;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.ws.Binding;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.jaxws.addressing.util.EndpointContextMap;
import org.apache.axis2.jaxws.addressing.util.EndpointContextMapManager;
import org.apache.axis2.jaxws.addressing.util.EndpointKey;
import org.apache.axis2.jaxws.binding.BindingUtils;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.impl.DescriptionUtils;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainsType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerType;
import org.apache.axis2.jaxws.handler.lifecycle.factory.HandlerLifecycleManagerFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.server.JAXWSMessageReceiver;
import org.apache.axis2.jaxws.server.endpoint.lifecycle.factory.EndpointLifecycleManagerFactory;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.HTTPTransportReceiver;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.TransportHeaders;
import org.apache.axis2.transport.http.util.RESTUtil;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.geronimo.axis2.Axis2RequestResponseTransport;
import org.apache.geronimo.axis2.AxisServiceGenerator;
import org.apache.geronimo.axis2.GeronimoConfigurator;
import org.apache.geronimo.axis2.GeronimoEndpointLifecycleManagerFactory;
import org.apache.geronimo.axis2.GeronimoFactoryRegistry;
import org.apache.geronimo.axis2.GeronimoHandlerLifecycleManagerFactory;
import org.apache.geronimo.axis2.WSDLQueryHandler;
import org.apache.geronimo.axis2.client.Axis2ConfigGBean;
import org.apache.geronimo.jaxws.JAXWSAnnotationProcessor;
import org.apache.geronimo.jaxws.JAXWSUtils;
import org.apache.geronimo.jaxws.JNDIResolver;
import org.apache.geronimo.jaxws.PortInfo;
import org.apache.geronimo.jaxws.ServerJNDIResolver;
import org.apache.geronimo.jaxws.annotations.AnnotationException;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.apache.geronimo.webservices.saaj.SAAJUniverse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Axis2WebServiceContainer
implements WebServiceContainer {
    private static final Logger LOG = LoggerFactory.getLogger(Axis2WebServiceContainer.class);
    public static final String REQUEST = Axis2WebServiceContainer.class.getName() + "@Request";
    public static final String RESPONSE = Axis2WebServiceContainer.class.getName() + "@Response";
    private final transient ClassLoader classLoader;
    protected String endpointClassName;
    protected PortInfo portInfo;
    protected ConfigurationContext configurationContext;
    protected JNDIResolver jndiResolver;
    protected Class endpointClass;
    protected AxisService service;
    protected URL configurationBaseUrl;
    protected WSDLQueryHandler wsdlQueryHandler;
    protected Binding binding;
    protected JAXWSAnnotationProcessor annotationProcessor;
    protected Context context;
    protected String address;
    protected GeronimoFactoryRegistry factoryRegistry;

    public Axis2WebServiceContainer(PortInfo portInfo, String endpointClassName, ClassLoader classLoader, Context context, URL configurationBaseUrl) {
        this.classLoader = classLoader;
        this.endpointClassName = endpointClassName;
        this.portInfo = portInfo;
        this.configurationBaseUrl = configurationBaseUrl;
        this.context = context;
        this.jndiResolver = new ServerJNDIResolver(context);
    }

    public void init() throws Exception {
        this.endpointClass = this.classLoader.loadClass(this.endpointClassName);
        Axis2ConfigGBean.registerClientConfigurationFactory();
        GeronimoConfigurator configurator = new GeronimoConfigurator("META-INF/geronimo-axis2.xml");
        this.configurationContext = ConfigurationContextFactory.createConfigurationContext((AxisConfigurator)configurator);
        if ((this.portInfo.getWsdlFile() == null || this.portInfo.getWsdlFile().equals("")) && JAXWSUtils.containsWsdlLocation((Class)this.endpointClass, (ClassLoader)this.classLoader)) {
            this.portInfo.setWsdlFile(JAXWSUtils.getServiceWsdlLocation((Class)this.endpointClass, (ClassLoader)this.classLoader));
        }
        AxisServiceGenerator serviceGen = this.createServiceGenerator();
        serviceGen.setConfigurationContext(this.configurationContext);
        this.service = this.portInfo.getWsdlFile() != null && !this.portInfo.getWsdlFile().equals("") ? serviceGen.getServiceFromWSDL(this.portInfo, this.endpointClass, this.configurationBaseUrl) : serviceGen.getServiceFromClass(this.endpointClass);
        this.service.setScope("application");
        this.configurationContext.getAxisConfiguration().addService(this.service);
        this.wsdlQueryHandler = new WSDLQueryHandler(this.service);
        FactoryRegistry.setFactory(HandlerLifecycleManagerFactory.class, (Object)((Object)new GeronimoHandlerLifecycleManagerFactory()));
        FactoryRegistry.setFactory(EndpointLifecycleManagerFactory.class, (Object)new GeronimoEndpointLifecycleManagerFactory());
        this.configureAddressing();
        this.service.addParameter(new Parameter("CACHE_CLASSLOADER", (Object)this.classLoader));
    }

    static String getBaseUri(URI request) {
        return request.getScheme() + "://" + request.getHost() + ":" + request.getPort() + request.getPath();
    }

    synchronized void updateAddress(WebServiceContainer.Request request) {
        if (this.address == null) {
            String requestAddress = Axis2WebServiceContainer.getBaseUri(request.getURI());
            this.service.setEPRs(new String[]{requestAddress});
            this.address = requestAddress;
        }
    }

    protected AxisServiceGenerator createServiceGenerator() {
        return new AxisServiceGenerator();
    }

    public void getWsdl(WebServiceContainer.Request request, WebServiceContainer.Response response) throws Exception {
        this.doService(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(WebServiceContainer.Request request, WebServiceContainer.Response response) throws Exception {
        GeronimoFactoryRegistry oldRegistry = GeronimoFactoryRegistry.getGeronimoFactoryRegistry();
        GeronimoFactoryRegistry.setGeronimoFactoryRegistry(this.factoryRegistry);
        SAAJUniverse universe = new SAAJUniverse();
        universe.set(SAAJUniverse.AXIS2);
        try {
            this.doService(request, response);
        }
        finally {
            universe.unset();
            GeronimoFactoryRegistry.setGeronimoFactoryRegistry(oldRegistry);
        }
    }

    protected void doService(WebServiceContainer.Request request, WebServiceContainer.Response response) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Target URI: " + request.getURI());
        }
        this.updateAddress(request);
        MessageContext msgContext = new MessageContext();
        msgContext.setIncomingTransportName("http");
        msgContext.setProperty("REMOTE_ADDR", (Object)request.getRemoteAddr());
        try {
            TransportOutDescription transportOut = this.configurationContext.getAxisConfiguration().getTransportOut("http");
            TransportInDescription transportIn = this.configurationContext.getAxisConfiguration().getTransportIn("http");
            msgContext.setConfigurationContext(this.configurationContext);
            msgContext.setTransportIn(transportIn);
            msgContext.setTransportOut(transportOut);
            msgContext.setServiceGroupContextId(UUIDGenerator.getUUID());
            msgContext.setServerSide(true);
            msgContext.setAxisService(this.service);
            this.doService2(request, response, msgContext);
        }
        catch (AxisFault e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            this.handleFault(msgContext, response, e);
        }
        catch (Throwable e) {
            String msg = "Exception occurred while trying to invoke service method doService()";
            LOG.error(msg, e);
            this.handleFault(msgContext, response, new AxisFault(msg, e));
        }
    }

    private void handleFault(MessageContext msgContext, WebServiceContainer.Response response, AxisFault e) {
        block6: {
            if (AddressingHelper.isFaultRedirected((MessageContext)msgContext)) {
                response.setStatusCode(202);
            } else if (e != null && e.getCause() != null && e.getCause().getCause() instanceof EJBAccessException) {
                response.setStatusCode(403);
            } else {
                response.setStatusCode(500);
            }
            msgContext.setProperty("TRANSPORT_OUT", (Object)response.getOutputStream());
            msgContext.setProperty("OutTransportInfo", (Object)new Axis2TransportInfo(response));
            try {
                MessageContext faultContext = MessageContextBuilder.createFaultMessageContext((MessageContext)msgContext, (Throwable)e);
                AxisEngine.sendFault((MessageContext)faultContext);
            }
            catch (Exception ex) {
                LOG.warn("Error sending fault", (Throwable)ex);
                if (AddressingHelper.isFaultRedirected((MessageContext)msgContext)) break block6;
                response.setStatusCode(500);
                response.setHeader("Content-Type", "text/plain");
                PrintWriter pw = new PrintWriter(response.getOutputStream());
                ex.printStackTrace(pw);
                pw.flush();
            }
        }
    }

    protected String getServicePath(String contextRoot) {
        String location = this.portInfo.getLocation();
        if (location != null && location.startsWith(contextRoot)) {
            return location.substring(contextRoot.length());
        }
        return null;
    }

    public static String trimContext(String contextPath) {
        if (contextPath != null) {
            if (contextPath.startsWith("/")) {
                contextPath = contextPath.substring(1);
            }
            if (contextPath.endsWith("/")) {
                contextPath = contextPath.substring(0, contextPath.length() - 1);
            }
        }
        return contextPath;
    }

    public void doService2(WebServiceContainer.Request request, WebServiceContainer.Response response, MessageContext msgContext) throws Exception {
        if (request.getMethod() == 1) {
            this.processGETRequest(request, response, this.service, msgContext);
        } else if (request.getMethod() == 3) {
            this.processPOSTRequest(request, response, this.service, msgContext);
        } else {
            throw new UnsupportedOperationException("[" + request.getMethod() + " ] method not supported");
        }
        OperationContext operationContext = msgContext.getOperationContext();
        Object contextWritten = null;
        Object isTwoChannel = null;
        if (operationContext != null) {
            contextWritten = operationContext.getProperty("RESPONSE_WRITTEN");
            isTwoChannel = operationContext.getProperty("DIFFERENT_EPR");
        }
        if (contextWritten != null && "true".equals(contextWritten)) {
            if (isTwoChannel != null && "true".equals(isTwoChannel)) {
                response.setStatusCode(202);
                return;
            }
            response.setStatusCode(200);
        } else {
            response.setStatusCode(202);
        }
    }

    public void destroy() {
        if (this.configurationContext != null) {
            try {
                this.configurationContext.terminate();
            }
            catch (AxisFault e) {
                LOG.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processGETRequest(WebServiceContainer.Request request, WebServiceContainer.Response response, AxisService service, MessageContext msgContext) throws Exception {
        String query = request.getURI().getQuery();
        if (query != null && (query.startsWith("wsdl") || query.startsWith("WSDL") || query.startsWith("xsd") || query.startsWith("XSD"))) {
            if (this.portInfo.getWsdlFile() == null || this.portInfo.getWsdlFile().equals("")) throw new Exception("Service does not have WSDL");
            URL wsdlURL = AxisServiceGenerator.getWsdlURL(this.portInfo.getWsdlFile(), this.configurationBaseUrl, this.classLoader);
            this.wsdlQueryHandler.writeResponse(request.getURI().toString(), wsdlURL.toString(), response.getOutputStream());
            return;
        } else if (AxisServiceGenerator.isSOAP11(service)) {
            response.setContentType("text/html");
            PrintWriter pw = new PrintWriter(response.getOutputStream());
            pw.write("<html><title>Web Service</title><body>");
            pw.write("Hi, this is '" + service.getName() + "' web service.");
            pw.write("</body></html>");
            pw.flush();
            return;
        } else {
            this.processURLRequest(request, response, service, msgContext);
        }
    }

    protected void processPOSTRequest(WebServiceContainer.Request request, WebServiceContainer.Response response, AxisService service, MessageContext msgContext) throws Exception {
        this.processXMLRequest(request, response, service, msgContext);
    }

    protected void setMsgContextProperties(WebServiceContainer.Request request, WebServiceContainer.Response response, AxisService service, MessageContext msgContext) {
        msgContext.setProperty("TRANSPORT_OUT", (Object)response.getOutputStream());
        msgContext.setProperty("OutTransportInfo", (Object)new Axis2TransportInfo(response));
        msgContext.setProperty("RequestResponseTransportControl", (Object)new Axis2RequestResponseTransport(response));
        msgContext.setProperty("TransportInURL", (Object)request.getURI().toString());
        msgContext.setIncomingTransportName("http");
        HttpServletRequest servletRequest = (HttpServletRequest)request.getAttribute(WebServiceContainer.SERVLET_REQUEST);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, (Object)servletRequest);
        HttpServletResponse servletResponse = (HttpServletResponse)request.getAttribute(WebServiceContainer.SERVLET_RESPONSE);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE, (Object)servletResponse);
        ServletContext servletContext = (ServletContext)request.getAttribute(WebServiceContainer.SERVLET_CONTEXT);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETCONTEXT, (Object)servletContext);
        if (servletRequest != null) {
            msgContext.setProperty("TRANSPORT_HEADERS", (Object)new TransportHeaders(servletRequest));
        }
        if (this.binding != null) {
            msgContext.setProperty(JAXWSMessageReceiver.PARAM_BINDING, (Object)this.binding);
        }
        msgContext.setTo(new EndpointReference(request.getURI().toString()));
    }

    protected void processXMLRequest(WebServiceContainer.Request request, WebServiceContainer.Response response, AxisService service, MessageContext msgContext) throws Exception {
        String contentType = request.getHeader("Content-Type");
        String soapAction = request.getHeader("SOAPAction");
        if (soapAction == null) {
            soapAction = "\"\"";
        }
        ConfigurationContext configurationContext = msgContext.getConfigurationContext();
        configurationContext.fillServiceContextAndServiceGroupContext(msgContext);
        this.setMsgContextProperties(request, response, service, msgContext);
        if (!HTTPTransportUtils.isRESTRequest((String)contentType)) {
            HTTPTransportUtils.processHTTPPostRequest((MessageContext)msgContext, (InputStream)request.getInputStream(), (OutputStream)response.getOutputStream(), (String)contentType, (String)soapAction, (String)request.getURI().getPath());
        } else {
            RESTUtil.processXMLRequest((MessageContext)msgContext, (InputStream)request.getInputStream(), (OutputStream)response.getOutputStream(), (String)contentType);
        }
    }

    protected void processURLRequest(WebServiceContainer.Request request, WebServiceContainer.Response response, AxisService service, MessageContext msgContext) throws Exception {
        String contentType = request.getHeader("Content-Type");
        ConfigurationContext configurationContext = msgContext.getConfigurationContext();
        configurationContext.fillServiceContextAndServiceGroupContext(msgContext);
        this.setMsgContextProperties(request, response, service, msgContext);
        Handler.InvocationResponse processed = RESTUtil.processURLRequest((MessageContext)msgContext, (OutputStream)response.getOutputStream(), (String)contentType);
        if (!processed.equals((Object)Handler.InvocationResponse.CONTINUE)) {
            response.setStatusCode(200);
            String s = HTTPTransportReceiver.getServicesHTML((ConfigurationContext)configurationContext);
            PrintWriter pw = new PrintWriter(response.getOutputStream());
            pw.write(s);
            pw.flush();
        }
    }

    protected void configureAddressing() throws Exception {
        EndpointDescription desc = AxisServiceGenerator.getEndpointDescription(this.service);
        QName serviceName = desc.getServiceQName();
        QName portName = desc.getPortQName();
        EndpointKey key = new EndpointKey(serviceName, portName);
        EndpointContextMapManager.setEndpointContextMap(null);
        EndpointContextMap map = EndpointContextMapManager.getEndpointContextMap();
        map.put((Object)key, (Object)this.service);
        this.configurationContext.setProperty("org.apache.axis2.jaxws.addressing.util.EndpointContextMap", (Object)map);
    }

    protected void configureHandlers() throws Exception {
        EndpointDescription desc = AxisServiceGenerator.getEndpointDescription(this.service);
        String xml = this.portInfo.getHandlersAsXML();
        HandlerChainsType handlerChains = null;
        if (xml != null) {
            ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            handlerChains = DescriptionUtils.loadHandlerChains((InputStream)in, null);
            desc.setHandlerChain(handlerChains);
        }
        if (LOG.isDebugEnabled()) {
            this.logHandlers(desc.getHandlerChain());
        }
        this.binding = BindingUtils.createBinding((EndpointDescription)desc);
        DescriptionUtils.registerHandlerHeaders((AxisService)desc.getAxisService(), (List)this.binding.getHandlerChain());
    }

    private void logHandlers(HandlerChainsType handlerChains) {
        if (handlerChains == null || handlerChains.getHandlerChain() == null || handlerChains.getHandlerChain().isEmpty()) {
            LOG.debug("No handlers");
            return;
        }
        for (HandlerChainType chains : handlerChains.getHandlerChain()) {
            LOG.debug("Handler chain: " + chains.getServiceNamePattern() + " " + chains.getPortNamePattern() + " " + chains.getProtocolBindings());
            if (chains.getHandler() == null) continue;
            for (HandlerType chain : chains.getHandler()) {
                LOG.debug("  Handler: " + chain.getHandlerName().getValue() + " " + chain.getHandlerClass().getValue());
            }
        }
    }

    protected void injectHandlers() {
        List handlers = this.binding.getHandlerChain();
        try {
            for (Handler handler : handlers) {
                this.injectResources(handler);
            }
        }
        catch (AnnotationException e) {
            throw new WebServiceException("Handler annotation failed", (Throwable)e);
        }
    }

    protected void destroyHandlers() {
        if (this.annotationProcessor != null) {
            List handlers = this.binding.getHandlerChain();
            for (Handler handler : handlers) {
                this.annotationProcessor.invokePreDestroy((Object)handler);
            }
        }
    }

    protected void injectResources(Object instance) throws AnnotationException {
        this.annotationProcessor.processAnnotations(instance);
        this.annotationProcessor.invokePostConstruct(instance);
    }

    public static class Axis2TransportInfo
    implements OutTransportInfo {
        private WebServiceContainer.Response response;

        public Axis2TransportInfo(WebServiceContainer.Response response) {
            this.response = response;
        }

        public void setContentType(String contentType) {
            this.response.setHeader("Content-Type", contentType);
        }
    }
}

