/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis2;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Axis2RequestResponseTransport
implements RequestResponseTransport {
    private static final Logger LOG = LoggerFactory.getLogger(Axis2RequestResponseTransport.class);
    private WebServiceContainer.Response response;
    private CountDownLatch responseReadySignal = new CountDownLatch(1);
    private RequestResponseTransport.RequestResponseTransportStatus status = RequestResponseTransport.RequestResponseTransportStatus.INITIAL;
    private AxisFault faultToBeThrownOut = null;
    private boolean responseWritten;

    Axis2RequestResponseTransport(WebServiceContainer.Response response) {
        this.response = response;
    }

    public void acknowledgeMessage(MessageContext msgContext) throws AxisFault {
        LOG.debug("acknowledgeMessage");
        LOG.debug("Acking one-way request");
        this.response.setContentType("text/xml; charset=" + msgContext.getProperty("message.character-set-encoding"));
        this.response.setStatusCode(202);
        try {
            this.response.flushBuffer();
        }
        catch (IOException e) {
            throw new AxisFault("Error sending acknowledgement", (Throwable)e);
        }
        this.signalResponseReady();
    }

    public void awaitResponse() throws InterruptedException, AxisFault {
        LOG.debug("Blocking servlet thread -- awaiting response");
        this.status = RequestResponseTransport.RequestResponseTransportStatus.WAITING;
        this.responseReadySignal.await();
        if (this.faultToBeThrownOut != null) {
            throw this.faultToBeThrownOut;
        }
    }

    public void signalFaultReady(AxisFault fault) {
        this.faultToBeThrownOut = fault;
        this.signalResponseReady();
    }

    public void signalResponseReady() {
        LOG.debug("Signalling response available");
        this.status = RequestResponseTransport.RequestResponseTransportStatus.SIGNALLED;
        this.responseReadySignal.countDown();
    }

    public RequestResponseTransport.RequestResponseTransportStatus getStatus() {
        return this.status;
    }

    public boolean isResponseWritten() {
        return this.responseWritten;
    }

    public void setResponseWritten(boolean responseWritten) {
        this.responseWritten = responseWritten;
    }
}

