/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis2;

import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis2.description.AxisService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.jaxws.WSDLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLQueryHandler {
    private static final Log LOG = LogFactory.getLog(WSDLQueryHandler.class);
    private static TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private Map<String, Definition> mp = new ConcurrentHashMap<String, Definition>();
    private Map<String, SchemaReference> smp = new ConcurrentHashMap<String, SchemaReference>();
    private AxisService service;

    public WSDLQueryHandler(AxisService service) {
        this.service = service;
    }

    public void writeResponse(String baseUri, String wsdlUri, OutputStream os) throws Exception {
        String sl;
        Element el;
        int x;
        Element rootElement;
        String base = null;
        String wsdl = "";
        String xsd = null;
        int idx = baseUri.toLowerCase().indexOf("?wsdl");
        if (idx != -1) {
            base = baseUri.substring(0, idx);
            wsdl = baseUri.substring(idx + 5);
            if (wsdl.length() > 0) {
                wsdl = wsdl.substring(1);
            }
        } else {
            idx = baseUri.toLowerCase().indexOf("?xsd");
            if (idx != -1) {
                base = baseUri.substring(0, idx);
                xsd = baseUri.substring(idx + 4);
                if (xsd.length() > 0) {
                    xsd = xsd.substring(1);
                }
            } else {
                throw new Exception("Invalid request: " + baseUri);
            }
        }
        if (!this.mp.containsKey(wsdl)) {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            reader.setFeature("javax.wsdl.importDocuments", true);
            reader.setFeature("javax.wsdl.verbose", false);
            Definition def = reader.readWSDL(wsdlUri);
            this.updateDefinition(def, this.mp, this.smp, base);
            WSDLUtils.trimDefinition((Definition)def, (String)this.service.getName(), (String)this.service.getEndpointName());
            this.mp.put("", def);
        }
        if (xsd == null) {
            Definition def = this.mp.get(wsdl);
            if (def == null) {
                throw new FileNotFoundException("WSDL not found: " + wsdl);
            }
            if (wsdl.equals("")) {
                WSDLUtils.updateLocations((Definition)def, (String)base);
            }
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLWriter writer = factory.newWSDLWriter();
            rootElement = writer.getDocument(def).getDocumentElement();
        } else {
            SchemaReference si = this.smp.get(xsd);
            if (si == null) {
                throw new FileNotFoundException("Schema not found: " + xsd);
            }
            rootElement = si.getReferencedSchema().getElement();
        }
        NodeList nl = rootElement.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "import");
        for (x = 0; x < nl.getLength(); ++x) {
            el = (Element)nl.item(x);
            sl = el.getAttribute("schemaLocation");
            if (!this.smp.containsKey(sl)) continue;
            el.setAttribute("schemaLocation", base + "?xsd=" + sl);
        }
        nl = rootElement.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "include");
        for (x = 0; x < nl.getLength(); ++x) {
            el = (Element)nl.item(x);
            sl = el.getAttribute("schemaLocation");
            if (!this.smp.containsKey(sl)) continue;
            el.setAttribute("schemaLocation", base + "?xsd=" + sl);
        }
        nl = rootElement.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "import");
        for (x = 0; x < nl.getLength(); ++x) {
            el = (Element)nl.item(x);
            sl = el.getAttribute("location");
            if (!this.mp.containsKey(sl)) continue;
            el.setAttribute("location", base + "?wsdl=" + sl);
        }
        WSDLQueryHandler.writeTo(rootElement, os);
    }

    protected void updateDefinition(Definition def, Map<String, Definition> done, Map<String, SchemaReference> doneSchemas, String base) {
        Collection imports = def.getImports().values();
        Iterator i$ = imports.iterator();
        while (i$.hasNext()) {
            List lst;
            List impLst = lst = (List)i$.next();
            for (Import imp : impLst) {
                String start = imp.getLocationURI();
                try {
                    new URL(start);
                }
                catch (MalformedURLException e) {
                    done.put(start, imp.getDefinition());
                    this.updateDefinition(imp.getDefinition(), done, doneSchemas, base);
                }
            }
        }
        Types types = def.getTypes();
        if (types != null) {
            for (ExtensibilityElement el : types.getExtensibilityElements()) {
                if (!(el instanceof Schema)) continue;
                Schema see = (Schema)el;
                this.updateSchemaImports(see, doneSchemas, base);
            }
        }
    }

    protected void updateSchemaImports(Schema schema, Map<String, SchemaReference> doneSchemas, String base) {
        Collection imports = schema.getImports().values();
        Iterator i$ = imports.iterator();
        while (i$.hasNext()) {
            List lst;
            List impLst = lst = (List)i$.next();
            for (SchemaImport imp : impLst) {
                String start = imp.getSchemaLocationURI();
                if (start == null) continue;
                try {
                    new URL(start);
                }
                catch (MalformedURLException e) {
                    if (doneSchemas.containsKey(start)) continue;
                    doneSchemas.put(start, (SchemaReference)imp);
                    this.updateSchemaImports(imp.getReferencedSchema(), doneSchemas, base);
                }
            }
        }
        List includes = schema.getIncludes();
        for (SchemaReference included : includes) {
            String start = included.getSchemaLocationURI();
            if (start == null) continue;
            try {
                new URL(start);
            }
            catch (MalformedURLException e) {
                if (doneSchemas.containsKey(start)) continue;
                doneSchemas.put(start, included);
                this.updateSchemaImports(included.getReferencedSchema(), doneSchemas, base);
            }
        }
    }

    public static void writeTo(Node node, OutputStream os) {
        WSDLQueryHandler.writeTo(new DOMSource(node), os);
    }

    public static void writeTo(Source src, OutputStream os) {
        try {
            Transformer it = transformerFactory.newTransformer();
            it.setOutputProperty("method", "xml");
            it.setOutputProperty("indent", "yes");
            it.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            it.setOutputProperty("omit-xml-declaration", "no");
            it.setOutputProperty("encoding", "utf-8");
            it.transform(src, new StreamResult(os));
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }
}

