/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis2.pojo;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.naming.Context;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.server.endpoint.lifecycle.factory.EndpointLifecycleManagerFactory;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.axis2.Axis2WebServiceContainer;
import org.apache.geronimo.axis2.pojo.POJOEndpointLifecycleManagerFactory;
import org.apache.geronimo.axis2.pojo.POJOWebServiceContext;
import org.apache.geronimo.jaxws.JAXWSAnnotationProcessor;
import org.apache.geronimo.jaxws.PortInfo;
import org.apache.geronimo.jaxws.annotations.AnnotationHolder;
import org.apache.geronimo.webservices.WebServiceContainer;

public class POJOWebServiceContainer
extends Axis2WebServiceContainer {
    private static final Log LOG = LogFactory.getLog(POJOWebServiceContainer.class);
    private Object endpointInstance;
    private String contextRoot = null;
    private AnnotationHolder holder;

    public POJOWebServiceContainer(PortInfo portInfo, String endpointClassName, ClassLoader classLoader, Context context, URL configurationBaseUrl, AnnotationHolder holder) {
        super(portInfo, endpointClassName, classLoader, context, configurationBaseUrl);
        this.holder = holder;
    }

    public void init() throws Exception {
        super.init();
        FactoryRegistry.setFactory(EndpointLifecycleManagerFactory.class, (Object)((Object)new POJOEndpointLifecycleManagerFactory()));
        this.configurationContext.setServicePath(this.portInfo.getLocation());
        try {
            this.endpointInstance = this.holder.newInstance(this.endpointClass.getName(), this.endpointClass.getClassLoader(), this.context);
        }
        catch (Exception e) {
            throw new WebServiceException("Service resource injection failed", (Throwable)e);
        }
        this.annotationProcessor = new JAXWSAnnotationProcessor(this.jndiResolver, (WebServiceContext)new POJOWebServiceContext());
        try {
            this.configureHandlers();
            this.injectHandlers();
        }
        catch (Exception e) {
            throw new WebServiceException("Error configuring handlers", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processPOSTRequest(WebServiceContainer.Request request, WebServiceContainer.Response response, AxisService service, MessageContext msgContext) throws Exception {
        String contentType = request.getHeader("Content-Type");
        String soapAction = request.getHeader("SOAPAction");
        if (soapAction == null) {
            soapAction = "\"\"";
        }
        ConfigurationContext configurationContext = msgContext.getConfigurationContext();
        configurationContext.fillServiceContextAndServiceGroupContext(msgContext);
        this.setMsgContextProperties(request, response, service, msgContext);
        ServiceContext serviceContext = msgContext.getServiceContext();
        serviceContext.setProperty("serviceObject", this.endpointInstance);
        try {
            HTTPTransportUtils.processHTTPPostRequest((MessageContext)msgContext, (InputStream)request.getInputStream(), (OutputStream)response.getOutputStream(), (String)contentType, (String)soapAction, (String)request.getURI().getPath());
        }
        finally {
            POJOWebServiceContext.clear();
        }
    }

    protected void initContextRoot(WebServiceContainer.Request request) {
        if (this.contextRoot == null || "".equals(this.contextRoot)) {
            String[] parts = JavaUtils.split((String)request.getContextPath(), (char)'/');
            if (parts != null) {
                for (int i = 0; i < parts.length; ++i) {
                    if (parts[i].length() <= 0) continue;
                    this.contextRoot = parts[i];
                    break;
                }
            }
            if (this.contextRoot == null || request.getContextPath().equals("/")) {
                this.contextRoot = "/";
            }
            this.configurationContext.setContextRoot(this.contextRoot);
        }
    }

    public void destroy() {
        this.destroyHandlers();
        if (this.endpointInstance != null) {
            try {
                this.holder.destroyInstance(this.endpointInstance);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error calling @PreDestroy method", (Throwable)e);
            }
        }
        super.destroy();
    }
}

