/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis2.ejb;

import java.net.URL;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.util.JavaUtils;
import org.apache.geronimo.axis2.Axis2WebServiceContainer;
import org.apache.geronimo.axis2.AxisServiceGenerator;
import org.apache.geronimo.axis2.ejb.EJBMessageReceiver;
import org.apache.geronimo.jaxws.JAXWSAnnotationProcessor;
import org.apache.geronimo.jaxws.JNDIResolver;
import org.apache.geronimo.jaxws.PortInfo;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.apache.openejb.DeploymentInfo;

public class EJBWebServiceContainer
extends Axis2WebServiceContainer {
    private String contextRoot = null;
    private DeploymentInfo deploymnetInfo;

    public EJBWebServiceContainer(PortInfo portInfo, String endpointClassName, ClassLoader classLoader, Context context, URL configurationBaseUrl, DeploymentInfo deploymnetInfo) {
        super(portInfo, endpointClassName, classLoader, context, configurationBaseUrl);
        this.deploymnetInfo = deploymnetInfo;
    }

    public void init() throws Exception {
        super.init();
        try {
            this.configureHandlers();
        }
        catch (Exception e) {
            throw new WebServiceException("Error configuring handlers", (Throwable)e);
        }
    }

    protected AxisServiceGenerator createServiceGenerator() {
        AxisServiceGenerator serviceGenerator = super.createServiceGenerator();
        EJBMessageReceiver messageReceiver = new EJBMessageReceiver(this, this.endpointClass, this.deploymnetInfo);
        serviceGenerator.setMessageReceiver(messageReceiver);
        return serviceGenerator;
    }

    protected void initContextRoot(WebServiceContainer.Request request) {
        String servicePath = this.portInfo.getLocation();
        if (this.contextRoot == null || "".equals(this.contextRoot)) {
            int i;
            String[] parts = JavaUtils.split((String)request.getContextPath(), (char)'/');
            if (parts != null) {
                for (i = 0; i < parts.length; ++i) {
                    if (parts[i].length() <= 0) continue;
                    this.contextRoot = parts[i];
                    break;
                }
            }
            if (this.contextRoot == null || request.getContextPath().equals("/")) {
                this.contextRoot = "/";
            } else {
                i = servicePath.indexOf(this.contextRoot);
                if (i > -1) {
                    servicePath = servicePath.substring(i + this.contextRoot.length() + 1);
                    servicePath.trim();
                }
            }
            this.configurationContext.setServicePath(servicePath);
            this.configurationContext.setContextRoot(this.contextRoot);
        }
    }

    public synchronized void injectHandlers() {
        if (this.annotationProcessor != null) {
            return;
        }
        WebServiceContext wsContext = null;
        try {
            InitialContext ctx = new InitialContext();
            wsContext = (WebServiceContext)ctx.lookup("java:comp/WebServiceContext");
        }
        catch (NamingException e) {
            throw new WebServiceException("Failed to lookup WebServiceContext", (Throwable)e);
        }
        this.annotationProcessor = new JAXWSAnnotationProcessor(new JNDIResolver(), wsContext);
        super.injectHandlers();
    }

    public void destroy() {
        this.destroyHandlers();
        super.destroy();
    }
}

