/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis2.ejb;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.xml.ws.Provider;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.context.factory.MessageContextFactory;
import org.apache.axis2.jaxws.context.utils.ContextUtils;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.handler.SoapMessageContext;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.util.ThreadContextMigratorUtil;
import org.apache.geronimo.axis2.ejb.EJBAddressingSupport;
import org.apache.geronimo.axis2.ejb.EJBInterceptor;
import org.apache.geronimo.axis2.ejb.EJBWebServiceContainer;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.RpcContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EJBMessageReceiver
implements MessageReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(EJBMessageReceiver.class);
    private BeanContext beanContext;
    private Class serviceImplClass;
    private EJBWebServiceContainer container;

    public EJBMessageReceiver(EJBWebServiceContainer container, Class serviceImplClass, BeanContext beanContext) {
        this.container = container;
        this.serviceImplClass = serviceImplClass;
        this.beanContext = beanContext;
    }

    public void receive(MessageContext axisMsgCtx) throws AxisFault {
        org.apache.axis2.jaxws.core.MessageContext requestMsgCtx = new org.apache.axis2.jaxws.core.MessageContext(axisMsgCtx);
        requestMsgCtx.setOperationName(requestMsgCtx.getAxisMessageContext().getAxisOperation().getName());
        requestMsgCtx.setEndpointDescription(this.getEndpointDescription(requestMsgCtx));
        SoapMessageContext jaxwsContext = MessageContextFactory.createSoapMessageContext((org.apache.axis2.jaxws.core.MessageContext)requestMsgCtx);
        Method method = null;
        if (Provider.class.isAssignableFrom(this.serviceImplClass)) {
            method = this.getProviderMethod();
            ContextUtils.addWSDLProperties_provider((org.apache.axis2.jaxws.core.MessageContext)requestMsgCtx, (SOAPMessageContext)jaxwsContext);
        } else {
            requestMsgCtx.setOperationDescription(this.getOperationDescription(requestMsgCtx));
            method = this.getServiceMethod(requestMsgCtx);
            ContextUtils.addWSDLProperties((org.apache.axis2.jaxws.core.MessageContext)requestMsgCtx, (SOAPMessageContext)jaxwsContext);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking '" + method.getName() + "' method.");
        }
        EJBInterceptor interceptor = new EJBInterceptor(this.container, requestMsgCtx);
        EJBAddressingSupport wsaSupport = new EJBAddressingSupport((javax.xml.ws.handler.MessageContext)jaxwsContext);
        Object[] arguments = new Object[]{jaxwsContext, interceptor, wsaSupport};
        RpcContainer container = (RpcContainer)this.beanContext.getContainer();
        Class callInterface = this.beanContext.getServiceEndpointInterface();
        method = EJBMessageReceiver.getMostSpecificMethod(method, callInterface);
        ThreadContextMigratorUtil.performMigrationToThread((String)"JAXWS-ThreadContextMigrator-List", (MessageContext)axisMsgCtx);
        try {
            Object res = container.invoke(this.beanContext.getDeploymentID(), InterfaceType.SERVICE_ENDPOINT, callInterface, method, arguments, null);
        }
        catch (ApplicationException e) {
            if (e.getCause() instanceof AxisFault) {
                throw (AxisFault)e.getCause();
            }
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        finally {
            ThreadContextMigratorUtil.performThreadCleanup((String)"JAXWS-ThreadContextMigrator-List", (MessageContext)axisMsgCtx);
        }
    }

    private static Method getMostSpecificMethod(Method method, Class<?> targetClass) {
        if (method != null && targetClass != null) {
            try {
                method = targetClass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return method;
    }

    private Method getServiceMethod(org.apache.axis2.jaxws.core.MessageContext mc) {
        OperationDescription opDesc = mc.getOperationDescription();
        if (opDesc == null) {
            throw ExceptionFactory.makeWebServiceException((String)"Operation Description was not set");
        }
        Method returnMethod = opDesc.getMethodFromServiceImpl(this.serviceImplClass);
        if (returnMethod == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"JavaBeanDispatcherErr1"));
        }
        return returnMethod;
    }

    private OperationDescription getOperationDescription(org.apache.axis2.jaxws.core.MessageContext mc) {
        EndpointDescription ed = mc.getEndpointDescription();
        EndpointInterfaceDescription eid = ed.getEndpointInterfaceDescription();
        OperationDescription[] ops = eid.getDispatchableOperation(mc.getOperationName());
        if (ops == null || ops.length == 0) {
            throw ExceptionFactory.makeWebServiceException((String)("No operation found.  WSDL Operation name: " + mc.getOperationName()));
        }
        if (ops.length > 1) {
            throw ExceptionFactory.makeWebServiceException((String)("More than one operation found. Overloaded WSDL operations are not supported.  WSDL Operation name: " + mc.getOperationName()));
        }
        OperationDescription op = ops[0];
        return op;
    }

    private EndpointDescription getEndpointDescription(org.apache.axis2.jaxws.core.MessageContext mc) {
        AxisService axisSvc = mc.getAxisMessageContext().getAxisService();
        Parameter param = axisSvc.getParameter("org.apache.axis2.jaxws.description.EndpointDescription");
        EndpointDescription ed = (EndpointDescription)param.getValue();
        return ed;
    }

    private Method getProviderMethod() {
        try {
            return this.serviceImplClass.getMethod("invoke", this.getProviderType());
        }
        catch (NoSuchMethodException e) {
            throw ExceptionFactory.makeWebServiceException((String)"Could not get Provider.invoke() method");
        }
    }

    private Class<?> getProviderType() {
        Type[] giTypes;
        for (Type giType : giTypes = this.serviceImplClass.getGenericInterfaces()) {
            if (!(giType instanceof ParameterizedType)) continue;
            ParameterizedType paramType = (ParameterizedType)giType;
            Class interfaceName = (Class)paramType.getRawType();
            if (interfaceName == Provider.class && paramType.getActualTypeArguments().length > 1) {
                throw ExceptionFactory.makeWebServiceException((String)"Provider cannot have more than one Generic Types defined as per JAX-WS Specification");
            }
            return (Class)paramType.getActualTypeArguments()[0];
        }
        throw ExceptionFactory.makeWebServiceException((String)"Provider has to implement javax.xml.ws.Provider interface as javax.xml.ws.Provider<DataSource>, javax.xml.ws.Provider<SOAPMessage>, javax.xml.ws.Provider<Source> or javax.xml.ws.Provider<JAXBContext>");
    }
}

