/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis.client;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.NoOp;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastConstructor;
import org.apache.axis.client.Service;
import org.apache.geronimo.axis.client.NoOverrideCallbackFilter;
import org.apache.geronimo.axis.client.SEIFactoryImpl;
import org.apache.geronimo.axis.client.SerializableNoOp;
import org.apache.geronimo.axis.client.ServiceImpl;
import org.apache.geronimo.axis.client.ServiceMethodInterceptor;
import org.apache.geronimo.naming.reference.ClassLoaderAwareReference;
import org.apache.geronimo.naming.reference.SimpleReference;

public class AxisServiceReference
extends SimpleReference
implements ClassLoaderAwareReference {
    private static final Class[] SERVICE_CONSTRUCTOR_TYPES = new Class[]{Map.class, Map.class};
    private String serviceInterfaceClassName;
    private Map seiPortNameToFactoryMap;
    private Map seiClassNameToFactoryMap;
    private ClassLoader classLoader;

    public AxisServiceReference(String serviceInterfaceClassName, Map seiPortNameToFactoryMap, Map seiClassNameToFactoryMap) {
        this.serviceInterfaceClassName = serviceInterfaceClassName;
        this.seiPortNameToFactoryMap = seiPortNameToFactoryMap;
        this.seiClassNameToFactoryMap = seiClassNameToFactoryMap;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Object getContent() throws NamingException {
        Class<?> serviceInterface;
        try {
            serviceInterface = this.classLoader.loadClass(this.serviceInterfaceClassName);
        }
        catch (ClassNotFoundException e) {
            throw new NamingException("Could not load service interface class " + this.serviceInterfaceClassName);
        }
        Object serviceInstance = this.createServiceInterfaceProxy(serviceInterface, this.seiPortNameToFactoryMap, this.seiClassNameToFactoryMap, this.classLoader);
        Iterator iterator = this.seiPortNameToFactoryMap.values().iterator();
        while (iterator.hasNext()) {
            SEIFactoryImpl seiFactory = (SEIFactoryImpl)iterator.next();
            try {
                seiFactory.initialize(serviceInstance, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new NamingException("Could not load service interface class; " + e.getMessage());
            }
        }
        return serviceInstance;
    }

    private Object createServiceInterfaceProxy(Class serviceInterface, Map seiPortNameToFactoryMap, Map seiClassNameToFactoryMap, ClassLoader classLoader) throws NamingException {
        ServiceMethodInterceptor callback = new ServiceMethodInterceptor(seiPortNameToFactoryMap);
        Callback[] methodInterceptors = new Callback[]{SerializableNoOp.INSTANCE, callback};
        Enhancer enhancer = new Enhancer();
        enhancer.setClassLoader(classLoader);
        enhancer.setSuperclass(ServiceImpl.class);
        enhancer.setInterfaces(new Class[]{serviceInterface});
        enhancer.setCallbackFilter((CallbackFilter)new NoOverrideCallbackFilter(Service.class));
        enhancer.setCallbackTypes(new Class[]{NoOp.class, MethodInterceptor.class});
        enhancer.setUseFactory(false);
        enhancer.setUseCache(false);
        Class serviceClass = enhancer.createClass();
        Enhancer.registerCallbacks((Class)serviceClass, (Callback[])methodInterceptors);
        FastConstructor constructor = FastClass.create((Class)serviceClass).getConstructor(SERVICE_CONSTRUCTOR_TYPES);
        try {
            return constructor.newInstance(new Object[]{seiPortNameToFactoryMap, seiClassNameToFactoryMap});
        }
        catch (InvocationTargetException e) {
            throw (NamingException)new NamingException("Could not construct service instance").initCause(e.getTargetException());
        }
    }
}

