/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis.builder;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.axis.builder.AxisBuilder;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.HandlerInfoInfo;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.kernel.ClassLoading;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.AbstractNamingBuilder;
import org.apache.geronimo.naming.deployment.ServiceRefBuilder;
import org.apache.geronimo.schema.NamespaceElementConverter;
import org.apache.geronimo.xbeans.geronimo.naming.GerServiceRefDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerServiceRefType;
import org.apache.geronimo.xbeans.javaee.ParamValueType;
import org.apache.geronimo.xbeans.javaee.PortComponentRefType;
import org.apache.geronimo.xbeans.javaee.ServiceRefHandlerType;
import org.apache.geronimo.xbeans.javaee.ServiceRefType;
import org.apache.geronimo.xbeans.javaee.String;
import org.apache.geronimo.xbeans.javaee.XsdQNameType;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlObject;

public class AxisServiceRefBuilder
extends AbstractNamingBuilder
implements ServiceRefBuilder {
    private static final Log log = LogFactory.getLog(AxisServiceRefBuilder.class);
    private final QNameSet serviceRefQNameSet;
    private static final QName GER_SERVICE_REF_QNAME = GerServiceRefDocument.type.getDocumentElementName();
    private static final QNameSet GER_SERVICE_REF_QNAME_SET = QNameSet.singleton((QName)GER_SERVICE_REF_QNAME);
    private final AxisBuilder axisBuilder;
    public static final GBeanInfo GBEAN_INFO;

    public AxisServiceRefBuilder(Environment defaultEnvironment, java.lang.String[] eeNamespaces, AxisBuilder axisBuilder) {
        super(defaultEnvironment);
        this.axisBuilder = axisBuilder;
        this.serviceRefQNameSet = AxisServiceRefBuilder.buildQNameSet((java.lang.String[])eeNamespaces, (java.lang.String)"service-ref");
    }

    protected boolean willMergeEnvironment(XmlObject specDD, XmlObject plan) {
        return specDD.selectChildren(this.serviceRefQNameSet).length > 0;
    }

    public void buildNaming(XmlObject specDD, XmlObject plan, Module module, Map componentContext) throws DeploymentException {
        List serviceRefsUntyped = AxisServiceRefBuilder.convert((XmlObject[])specDD.selectChildren(this.serviceRefQNameSet), (NamespaceElementConverter)JEE_CONVERTER, ServiceRefType.class, (SchemaType)ServiceRefType.type);
        XmlObject[] gerServiceRefsUntyped = plan == null ? NO_REFS : plan.selectChildren(GER_SERVICE_REF_QNAME_SET);
        Map serviceRefMap = AxisServiceRefBuilder.mapServiceRefs(gerServiceRefsUntyped);
        for (ServiceRefType serviceRef : serviceRefsUntyped) {
            java.lang.String name = AxisServiceRefBuilder.getStringValue((String)serviceRef.getServiceRefName());
            this.addInjections(name, serviceRef.getInjectionTargetArray(), componentContext);
            GerServiceRefType serviceRefType = (GerServiceRefType)serviceRefMap.get(name);
            serviceRefMap.remove(name);
            this.buildNaming(serviceRef, serviceRefType, module, componentContext);
        }
        if (serviceRefMap.size() > 0) {
            log.warn((Object)("Failed to build reference to service reference " + serviceRefMap.keySet() + " defined in plan file, reason - corresponding entry in deployment descriptor missing."));
        }
    }

    public void buildNaming(XmlObject serviceRef, GerServiceRefType gerServiceRefType, Module module, Map componentContext) throws DeploymentException {
        ServiceRefType serviceRefType = (ServiceRefType)AxisServiceRefBuilder.convert((XmlObject)serviceRef, (NamespaceElementConverter)JEE_CONVERTER, (SchemaType)ServiceRefType.type);
        this.buildNaming(serviceRefType, gerServiceRefType, module, componentContext);
    }

    private void buildNaming(ServiceRefType serviceRef, GerServiceRefType serviceRefType, Module module, Map componentContext) throws DeploymentException {
        Class<?> serviceInterface;
        java.lang.String name = AxisServiceRefBuilder.getStringValue((String)serviceRef.getServiceRefName());
        ClassLoader cl = module.getEarContext().getClassLoader();
        java.lang.String serviceInterfaceName = AxisServiceRefBuilder.getStringValue((String)serviceRef.getServiceInterface());
        AxisServiceRefBuilder.assureInterface((java.lang.String)serviceInterfaceName, (java.lang.String)"javax.xml.rpc.Service", (java.lang.String)"[Web]Service", (ClassLoader)cl);
        try {
            serviceInterface = cl.loadClass(serviceInterfaceName);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Could not load service interface class: " + serviceInterfaceName, (Throwable)e);
        }
        URI wsdlURI = null;
        if (serviceRef.isSetWsdlFile()) {
            try {
                wsdlURI = new URI(serviceRef.getWsdlFile().getStringValue().trim());
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("could not construct wsdl uri from " + serviceRef.getWsdlFile().getStringValue(), (Throwable)e);
            }
        }
        URI jaxrpcMappingURI = null;
        if (serviceRef.isSetJaxrpcMappingFile()) {
            try {
                jaxrpcMappingURI = new URI(AxisServiceRefBuilder.getStringValue((String)serviceRef.getJaxrpcMappingFile()));
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Could not construct jaxrpc mapping uri from " + serviceRef.getJaxrpcMappingFile(), (Throwable)e);
            }
        }
        QName serviceQName = null;
        if (serviceRef.isSetServiceQname()) {
            serviceQName = serviceRef.getServiceQname().getQNameValue();
        }
        HashMap portComponentRefMap = new HashMap();
        PortComponentRefType[] portComponentRefs = serviceRef.getPortComponentRefArray();
        if (portComponentRefs != null) {
            for (int j = 0; j < portComponentRefs.length; ++j) {
                Class<?> serviceEndpointClass;
                PortComponentRefType portComponentRef = portComponentRefs[j];
                java.lang.String portComponentLink = AxisServiceRefBuilder.getStringValue((String)portComponentRef.getPortComponentLink());
                java.lang.String serviceEndpointInterfaceType = AxisServiceRefBuilder.getStringValue((String)portComponentRef.getServiceEndpointInterface());
                AxisServiceRefBuilder.assureInterface((java.lang.String)serviceEndpointInterfaceType, (java.lang.String)"java.rmi.Remote", (java.lang.String)"ServiceEndpoint", (ClassLoader)cl);
                try {
                    serviceEndpointClass = cl.loadClass(serviceEndpointInterfaceType);
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentException("could not load service endpoint class " + serviceEndpointInterfaceType, (Throwable)e);
                }
                portComponentRefMap.put(serviceEndpointClass, portComponentLink);
            }
        }
        ServiceRefHandlerType[] handlers = serviceRef.getHandlerArray();
        List handlerInfos = AxisServiceRefBuilder.buildHandlerInfoList(handlers, cl);
        Object ref = this.axisBuilder.createService(serviceInterface, wsdlURI, jaxrpcMappingURI, serviceQName, portComponentRefMap, handlerInfos, (Object)serviceRefType, module, cl);
        this.getJndiContextMap(componentContext).put("env/" + name, ref);
    }

    public QNameSet getSpecQNameSet() {
        return this.serviceRefQNameSet;
    }

    public QNameSet getPlanQNameSet() {
        return GER_SERVICE_REF_QNAME_SET;
    }

    private static List buildHandlerInfoList(ServiceRefHandlerType[] handlers, ClassLoader classLoader) throws DeploymentException {
        ArrayList<HandlerInfoInfo> handlerInfos = new ArrayList<HandlerInfoInfo>();
        for (int i = 0; i < handlers.length; ++i) {
            Class handlerClass;
            ServiceRefHandlerType handler = handlers[i];
            String[] portNameArray = handler.getPortNameArray();
            ArrayList<java.lang.String> portNames = new ArrayList<java.lang.String>();
            for (int j = 0; j < portNameArray.length; ++j) {
                portNames.add(portNameArray[j].getStringValue().trim());
            }
            java.lang.String handlerClassName = handler.getHandlerClass().getStringValue().trim();
            try {
                handlerClass = ClassLoading.loadClass((java.lang.String)handlerClassName, (ClassLoader)classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Could not load handler class", (Throwable)e);
            }
            HashMap<java.lang.String, java.lang.String> config = new HashMap<java.lang.String, java.lang.String>();
            ParamValueType[] paramValues = handler.getInitParamArray();
            for (int j = 0; j < paramValues.length; ++j) {
                ParamValueType paramValue = paramValues[j];
                java.lang.String paramName = paramValue.getParamName().getStringValue().trim();
                java.lang.String paramStringValue = paramValue.getParamValue().getStringValue().trim();
                config.put(paramName, paramStringValue);
            }
            XsdQNameType[] soapHeaderQNames = handler.getSoapHeaderArray();
            QName[] headerQNames = new QName[soapHeaderQNames.length];
            for (int j = 0; j < soapHeaderQNames.length; ++j) {
                XsdQNameType soapHeaderQName = soapHeaderQNames[j];
                headerQNames[j] = soapHeaderQName.getQNameValue();
            }
            HashSet<java.lang.String> soapRoles = new HashSet<java.lang.String>();
            for (int j = 0; j < handler.getSoapRoleArray().length; ++j) {
                java.lang.String soapRole = handler.getSoapRoleArray(j).getStringValue().trim();
                soapRoles.add(soapRole);
            }
            HandlerInfoInfo handlerInfoInfo = new HandlerInfoInfo(new HashSet(portNames), handlerClass, config, headerQNames, soapRoles);
            handlerInfos.add(handlerInfoInfo);
        }
        return handlerInfos;
    }

    private static Map mapServiceRefs(XmlObject[] refs) {
        HashMap<java.lang.String, GerServiceRefType> refMap = new HashMap<java.lang.String, GerServiceRefType>();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                GerServiceRefType ref = (GerServiceRefType)refs[i].copy().changeType(GerServiceRefType.type);
                java.lang.String serviceRefName = ref.getServiceRefName().trim();
                refMap.put(serviceRefName, ref);
            }
        }
        return refMap;
    }

    private static java.lang.String getStringValue(org.apache.geronimo.xbeans.j2ee.String string) {
        if (string == null) {
            return null;
        }
        java.lang.String s = string.getStringValue();
        return s == null ? null : s.trim();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(AxisServiceRefBuilder.class, (java.lang.String)"ModuleBuilder");
        infoBuilder.addInterface(ServiceRefBuilder.class);
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.addAttribute("eeNamespaces", java.lang.String[].class, true, true);
        infoBuilder.addReference("AxisBuilder", AxisBuilder.class, "ModuleBuilder");
        infoBuilder.setConstructor(new java.lang.String[]{"defaultEnvironment", "eeNamespaces", "AxisBuilder"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

