/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.axis.builder;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.OperationType;
import javax.wsdl.Part;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.xml.namespace.QName;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.description.FaultDesc;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.soap.SOAPConstants;
import org.apache.geronimo.axis.builder.OperationDescBuilder;
import org.apache.geronimo.axis.client.OperationInfo;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.kernel.ClassLoading;
import org.apache.geronimo.webservices.builder.SchemaInfoBuilder;
import org.apache.geronimo.webservices.builder.WSDescriptorParser;
import org.apache.geronimo.xbeans.j2ee.ConstructorParameterOrderType;
import org.apache.geronimo.xbeans.j2ee.ExceptionMappingType;
import org.apache.geronimo.xbeans.j2ee.JavaWsdlMappingType;
import org.apache.geronimo.xbeans.j2ee.JavaXmlTypeMappingType;
import org.apache.geronimo.xbeans.j2ee.MethodParamPartsMappingType;
import org.apache.geronimo.xbeans.j2ee.ServiceEndpointMethodMappingType;
import org.apache.geronimo.xbeans.j2ee.WsdlMessageMappingType;
import org.apache.geronimo.xbeans.j2ee.WsdlReturnValueMappingType;
import org.apache.xmlbeans.SchemaParticle;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.objectweb.asm.Type;

public class HeavyweightOperationDescBuilder
extends OperationDescBuilder {
    private final JavaWsdlMappingType mapping;
    private final ServiceEndpointMethodMappingType methodMapping;
    private final SOAPBody soapBody;
    private final Map exceptionMap;
    private final SchemaInfoBuilder schemaInfoBuilder;
    private final ClassLoader classLoader;
    private final boolean rpcStyle;
    private final boolean documentStyle;
    private final boolean wrappedStyle;
    private final boolean isEncoded;
    private final Map publicTypes = new HashMap();
    private final Map anonymousTypes = new HashMap();
    private final Set inParamNames = new HashSet();
    private final Set outParamNames = new HashSet();
    private final Class serviceEndpointInterface;
    private final Set wrapperElementQNames = new HashSet();
    private static final Map qnameToClassMap = new HashMap();

    public HeavyweightOperationDescBuilder(BindingOperation bindingOperation, JavaWsdlMappingType mapping, ServiceEndpointMethodMappingType methodMapping, Style defaultStyle, Map exceptionMap, SchemaInfoBuilder schemaInfoBuilder, JavaXmlTypeMappingType[] javaXmlTypeMappingTypes, ClassLoader classLoader, Class serviceEndpointInterface) throws DeploymentException {
        super(bindingOperation);
        this.mapping = mapping;
        this.methodMapping = methodMapping;
        this.exceptionMap = exceptionMap;
        this.schemaInfoBuilder = schemaInfoBuilder;
        for (int i = 0; i < javaXmlTypeMappingTypes.length; ++i) {
            JavaXmlTypeMappingType javaXmlTypeMappingType = javaXmlTypeMappingTypes[i];
            String javaClassName = javaXmlTypeMappingType.getJavaType().getStringValue().trim();
            if (javaXmlTypeMappingType.isSetAnonymousTypeQname()) {
                String anonymousTypeQName = javaXmlTypeMappingType.getAnonymousTypeQname().getStringValue().trim();
                this.anonymousTypes.put(anonymousTypeQName, javaClassName);
                continue;
            }
            if (!javaXmlTypeMappingType.isSetRootTypeQname()) continue;
            QName qname = javaXmlTypeMappingType.getRootTypeQname().getQNameValue();
            this.publicTypes.put(qname, javaClassName);
        }
        this.classLoader = classLoader;
        this.serviceEndpointInterface = serviceEndpointInterface;
        BindingInput bindingInput = bindingOperation.getBindingInput();
        this.soapBody = (SOAPBody)SchemaInfoBuilder.getExtensibilityElement((Class)SOAPBody.class, (List)bindingInput.getExtensibilityElements());
        this.wrappedStyle = methodMapping.isSetWrappedElement();
        if (!this.wrappedStyle) {
            Style style = Style.getStyle((String)this.soapOperation.getStyle(), (Style)defaultStyle);
            if (style == Style.RPC) {
                this.rpcStyle = true;
                this.documentStyle = false;
            } else {
                this.rpcStyle = false;
                this.documentStyle = true;
            }
        } else {
            this.rpcStyle = false;
            this.documentStyle = false;
        }
        this.isEncoded = Use.getUse((String)this.soapBody.getUse()) == Use.ENCODED;
    }

    public Set getWrapperElementQNames() throws DeploymentException {
        this.buildOperationDesc();
        return Collections.unmodifiableSet(this.wrapperElementQNames);
    }

    public boolean isEncoded() {
        return this.isEncoded;
    }

    public OperationInfo buildOperationInfo(SOAPConstants soapVersion) throws DeploymentException {
        this.buildOperationDesc();
        String soapActionURI = this.soapOperation.getSoapActionURI();
        boolean usesSOAPAction = soapActionURI != null;
        QName operationQName = this.getOperationQName();
        String methodName = this.methodMapping.getJavaMethodName().getStringValue().trim();
        ArrayList parameters = this.operationDesc.getParameters();
        Type[] parameterASMTypes = new Type[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            ParameterDesc parameterDesc = (ParameterDesc)parameters.get(i);
            parameterASMTypes[i] = Type.getType((Class)parameterDesc.getJavaType());
        }
        Type returnASMType = this.operationDesc.getReturnClass() != null ? Type.getType((Class)this.operationDesc.getReturnClass()) : Type.VOID_TYPE;
        String methodDesc = Type.getMethodDescriptor((Type)returnASMType, (Type[])parameterASMTypes);
        OperationInfo operationInfo = new OperationInfo(this.operationDesc, usesSOAPAction, soapActionURI, soapVersion, operationQName, methodName, methodDesc);
        return operationInfo;
    }

    private QName getOperationQName() {
        Iterator iterator;
        Map parts;
        if (this.wrappedStyle && (parts = this.operation.getInput().getMessage().getParts()) != null && !parts.isEmpty() && (iterator = parts.values().iterator()).hasNext()) {
            Part part = (Part)iterator.next();
            return part.getElementName();
        }
        return this.getOperationNameFromSOAPBody();
    }

    public OperationDesc buildOperationDesc() throws DeploymentException {
        if (this.built) {
            return this.operationDesc;
        }
        this.built = true;
        this.operationDesc.setName(this.operationName);
        if (this.wrappedStyle) {
            this.operationDesc.setStyle(Style.WRAPPED);
        } else if (this.rpcStyle) {
            this.operationDesc.setStyle(Style.RPC);
        } else {
            this.operationDesc.setStyle(Style.DOCUMENT);
        }
        Use use = Use.getUse((String)this.soapBody.getUse());
        this.operationDesc.setUse(use);
        MethodParamPartsMappingType[] paramMappings = this.methodMapping.getMethodParamPartsMappingArray();
        ParameterDesc[] parameterDescriptions = new ParameterDesc[paramMappings.length];
        for (int i = 0; i < paramMappings.length; ++i) {
            ParameterDesc parameterDesc;
            MethodParamPartsMappingType paramMapping = paramMappings[i];
            int position = paramMapping.getParamPosition().getBigIntegerValue().intValue();
            parameterDescriptions[position] = parameterDesc = this.mapParameter(paramMapping);
        }
        if (this.wrappedStyle) {
            Part inputPart = this.getWrappedPart(this.input);
            QName name = inputPart.getElementName();
            SchemaType operationType = (SchemaType)this.schemaInfoBuilder.getComplexTypesInWsdl().get(name);
            HashSet<String> expectedInParams = new HashSet<String>();
            SchemaParticle parametersType = operationType.getContentModel();
            if (parametersType != null) {
                if (4 == parametersType.getParticleType()) {
                    expectedInParams.add(parametersType.getName().getLocalPart());
                } else if (3 == parametersType.getParticleType()) {
                    SchemaParticle[] parameters = parametersType.getParticleChildren();
                    for (int i = 0; i < parameters.length; ++i) {
                        expectedInParams.add(parameters[i].getName().getLocalPart());
                    }
                }
            }
            if (!((Object)this.inParamNames).equals(expectedInParams)) {
                throw new DeploymentException("Not all wrapper children were mapped for operation name" + this.operationName);
            }
        } else if (!((Object)this.inParamNames).equals(this.input.getParts().keySet())) {
            throw new DeploymentException("Not all input message parts were mapped for operation name" + this.operationName);
        }
        Class[] paramTypes = new Class[parameterDescriptions.length];
        for (int i = 0; i < parameterDescriptions.length; ++i) {
            ParameterDesc parameterDescription = parameterDescriptions[i];
            if (parameterDescription == null) {
                throw new DeploymentException("There is no mapping for parameter number " + i + " for operation " + this.operationName);
            }
            this.operationDesc.addParameter(parameterDescription);
            paramTypes[i] = parameterDescription.getJavaType();
        }
        String methodName = this.methodMapping.getJavaMethodName().getStringValue().trim();
        Method method = null;
        try {
            method = this.serviceEndpointInterface.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException e) {
            String args = "(";
            for (int i = 0; i < paramTypes.length; ++i) {
                args = args + paramTypes[i].getName();
                if (i >= paramTypes.length - 1) continue;
                args = args + ",";
            }
            args = args + ")";
            throw new DeploymentException("Mapping references non-existent method in service-endpoint: " + methodName + args);
        }
        this.operationDesc.setMethod(method);
        this.operationDesc.setMep(this.operation.getStyle());
        if (this.methodMapping.isSetWsdlReturnValueMapping()) {
            this.mapReturnType();
        } else if (this.operation.getStyle() == OperationType.REQUEST_RESPONSE) {
            this.operationDesc.setReturnQName(null);
            this.operationDesc.setReturnType(XMLType.AXIS_VOID);
            this.operationDesc.setReturnClass(Void.TYPE);
        }
        if (null != this.output && this.wrappedStyle) {
            Part inputPart = this.getWrappedPart(this.output);
            QName name = inputPart.getElementName();
            SchemaType operationType = (SchemaType)this.schemaInfoBuilder.getComplexTypesInWsdl().get(name);
            HashSet<String> expectedOutParams = new HashSet<String>();
            SchemaParticle parametersType = operationType.getContentModel();
            if (parametersType != null) {
                if (4 == parametersType.getParticleType()) {
                    expectedOutParams.add(parametersType.getName().getLocalPart());
                } else if (3 == parametersType.getParticleType()) {
                    SchemaParticle[] parameters = parametersType.getParticleChildren();
                    for (int i = 0; i < parameters.length; ++i) {
                        expectedOutParams.add(parameters[i].getName().getLocalPart());
                    }
                }
            }
            if (!((Object)this.outParamNames).equals(expectedOutParams)) {
                throw new DeploymentException("Not all wrapper children were mapped to parameters or a return value for operation " + this.operationName);
            }
        } else if (null != this.output && !((Object)this.outParamNames).equals(this.output.getParts().keySet())) {
            throw new DeploymentException("Not all output message parts were mapped to parameters or a return value for operation " + this.operationName);
        }
        Map faultMap = this.operation.getFaults();
        Iterator iterator = faultMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String faultName = (String)entry.getKey();
            Fault fault = (Fault)entry.getValue();
            FaultDesc faultDesc = this.mapException(faultName, fault);
            this.operationDesc.addFault(faultDesc);
        }
        return this.operationDesc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FaultDesc mapException(String faultName, Fault fault) throws DeploymentException {
        SchemaType complexType;
        QName faultTypeQName;
        Part part;
        Message message = fault.getMessage();
        QName messageQName = message.getQName();
        ExceptionMappingType exceptionMapping = (ExceptionMappingType)this.exceptionMap.get(messageQName);
        if (exceptionMapping == null) {
            throw new DeploymentException("No exception mapping for fault " + faultName + " and fault message " + messageQName + " for operation " + this.operationName);
        }
        String className = exceptionMapping.getExceptionType().getStringValue().trim();
        QName faultQName = new QName("", faultName);
        if (exceptionMapping.isSetWsdlMessagePartName()) {
            String headerFaultMessagePartName = exceptionMapping.getWsdlMessagePartName().getStringValue();
            part = message.getPart(headerFaultMessagePartName);
        } else {
            part = (Part)message.getOrderedParts(null).iterator().next();
        }
        if (part.getElementName() == null) {
            faultTypeQName = part.getTypeName();
            if (faultTypeQName == null) {
                throw new DeploymentException("Neither type nor element name supplied for part: " + part);
            }
        } else {
            faultQName = part.getElementName();
            faultTypeQName = (QName)this.schemaInfoBuilder.getElementToTypeMap().get(part.getElementName());
            if (faultTypeQName == null) {
                throw new DeploymentException("Can not find type for: element: " + part.getElementName() + ", known elements: " + this.schemaInfoBuilder.getElementToTypeMap());
            }
        }
        boolean isComplex = (complexType = (SchemaType)this.schemaInfoBuilder.getComplexTypesInWsdl().get(faultTypeQName)) != null;
        FaultDesc faultDesc = new FaultDesc(faultQName, className, faultTypeQName, isComplex);
        if (!exceptionMapping.isSetConstructorParameterOrder()) return faultDesc;
        if (!isComplex) {
            throw new DeploymentException("ConstructorParameterOrder can only be set for complex types, not " + faultTypeQName);
        }
        HashMap<String, SchemaType> elementMap = new HashMap<String, SchemaType>();
        SchemaProperty[] properties = complexType.getProperties();
        for (int i = 0; i < properties.length; ++i) {
            SchemaProperty property = properties[i];
            QName elementName = property.getName();
            SchemaType elementType = property.getType();
            elementMap.put(elementName.getLocalPart(), elementType);
        }
        ArrayList<ParameterDesc> parameterTypes = new ArrayList<ParameterDesc>();
        ConstructorParameterOrderType constructorParameterOrder = exceptionMapping.getConstructorParameterOrder();
        for (int i = 0; i < constructorParameterOrder.getElementNameArray().length; ++i) {
            Class javaElementType;
            String elementName = constructorParameterOrder.getElementNameArray(i).getStringValue().trim();
            SchemaType elementType = (SchemaType)elementMap.get(elementName);
            QName elementTypeQName = elementType.getName();
            if (elementTypeQName != null) {
                if (this.schemaInfoBuilder.getComplexTypesInWsdl().containsKey(elementType)) {
                    String javaClassName = (String)this.publicTypes.get(elementTypeQName);
                    if (javaClassName == null) {
                        throw new DeploymentException("No class mapped for element type: " + elementType);
                    }
                    javaElementType = this.getJavaClass(javaClassName);
                } else {
                    javaElementType = (Class)qnameToClassMap.get(elementTypeQName);
                    if (javaElementType == null) {
                        throw new DeploymentException("Unknown type: " + elementType + " of name: " + elementName + " and QName: " + elementTypeQName);
                    }
                }
            } else {
                String anonymousQName = complexType.getName().getNamespaceURI() + ":>" + complexType.getName().getLocalPart() + ">" + elementName;
                String javaClassName = (String)this.anonymousTypes.get(anonymousQName);
                if (javaClassName == null) {
                    if (!elementType.isSimpleType()) throw new DeploymentException("No class mapped for anonymous type: " + anonymousQName);
                    SchemaType baseType = elementType.getBaseType();
                    QName simpleTypeQName = baseType.getName();
                    javaElementType = (Class)qnameToClassMap.get(simpleTypeQName);
                    if (javaElementType == null) {
                        throw new DeploymentException("Unknown simple type: " + elementType + " of name: " + elementName + " and QName: " + simpleTypeQName);
                    }
                } else {
                    javaElementType = this.getJavaClass(javaClassName);
                }
            }
            ParameterDesc parameterDesc = new ParameterDesc(faultTypeQName, 2, elementTypeQName, javaElementType, false, false);
            parameterTypes.add(parameterDesc);
        }
        faultDesc.setParameters(parameterTypes);
        return faultDesc;
    }

    private Class getJavaClass(String javaClassName) throws DeploymentException {
        try {
            Class javaClass = ClassLoading.loadClass((String)javaClassName, (ClassLoader)this.classLoader);
            return javaClass;
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Could not load class", (Throwable)e);
        }
    }

    private void mapReturnType() throws DeploymentException {
        QName returnType = null;
        QName returnQName = null;
        Class returnClass = null;
        if (this.output == null) {
            throw new DeploymentException("No output message, but a mapping for it for operation " + this.operationName);
        }
        WsdlReturnValueMappingType wsdlReturnValueMapping = this.methodMapping.getWsdlReturnValueMapping();
        String returnClassName = wsdlReturnValueMapping.getMethodReturnValue().getStringValue().trim();
        try {
            returnClass = ClassLoading.loadClass((String)returnClassName, (ClassLoader)this.classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Could not load return type for operation " + this.operationName, (Throwable)e);
        }
        QName wsdlMessageQName = wsdlReturnValueMapping.getWsdlMessage().getQNameValue();
        if (!wsdlMessageQName.equals(this.output.getQName())) {
            throw new DeploymentException("OutputMessage has QName: " + this.output.getQName() + " but mapping specifies: " + wsdlMessageQName + " for operation " + this.operationName);
        }
        if (wsdlReturnValueMapping.isSetWsdlMessagePartName()) {
            String wsdlMessagePartName = wsdlReturnValueMapping.getWsdlMessagePartName().getStringValue().trim();
            if (this.outParamNames.contains(wsdlMessagePartName)) {
                throw new DeploymentException("output message part " + wsdlMessagePartName + " has both an INOUT or OUT mapping and a return value mapping for operation " + this.operationName);
            }
            if (this.wrappedStyle) {
                Part outPart = this.getWrappedPart(this.output);
                SchemaParticle returnParticle = this.getWrapperChild(outPart, wsdlMessagePartName);
                returnQName = new QName("", returnParticle.getName().getLocalPart());
                returnType = returnParticle.getType().getName();
            } else if (this.rpcStyle) {
                Part part = this.output.getPart(wsdlMessagePartName);
                if (part == null) {
                    throw new DeploymentException("No part for wsdlMessagePartName " + wsdlMessagePartName + " in output message for operation " + this.operationName);
                }
                returnQName = new QName("", part.getName());
                returnType = part.getTypeName();
            } else {
                Part part = this.output.getPart(wsdlMessagePartName);
                if (part == null) {
                    throw new DeploymentException("No part for wsdlMessagePartName " + wsdlMessagePartName + " in output message for operation " + this.operationName);
                }
                returnType = returnQName = this.getPartName(part);
            }
            this.outParamNames.add(wsdlMessagePartName);
        }
        this.operationDesc.setReturnQName(returnQName);
        this.operationDesc.setReturnType(returnType);
        this.operationDesc.setReturnClass(returnClass);
    }

    private ParameterDesc mapParameter(MethodParamPartsMappingType paramMapping) throws DeploymentException {
        SchemaParticle outParameter;
        Part outPart;
        QName paramTypeQName;
        QName paramQName;
        boolean isOutParam;
        WsdlMessageMappingType wsdlMessageMappingType = paramMapping.getWsdlMessageMapping();
        QName wsdlMessageQName = wsdlMessageMappingType.getWsdlMessage().getQNameValue();
        String wsdlMessagePartName = wsdlMessageMappingType.getWsdlMessagePartName().getStringValue().trim();
        String parameterMode = wsdlMessageMappingType.getParameterMode().getStringValue().trim();
        byte mode = ParameterDesc.modeFromString((String)parameterMode);
        boolean isInParam = mode == 1 || mode == 3;
        boolean bl = isOutParam = mode == 2 || mode == 3;
        if (isOutParam && this.output == null) {
            throw new DeploymentException("Mapping for output parameter " + wsdlMessagePartName + " found, but no output message for operation " + this.operationName);
        }
        boolean isSoapHeader = wsdlMessageMappingType.isSetSoapHeader();
        boolean inHeader = isSoapHeader && isInParam;
        boolean outHeader = isSoapHeader && isOutParam;
        Part part = null;
        SchemaParticle inParameter = null;
        if (isInParam) {
            if (!wsdlMessageQName.equals(this.input.getQName())) {
                throw new DeploymentException("QName of input message: " + this.input.getQName() + " does not match mapping message QName: " + wsdlMessageQName + " for operation " + this.operationName);
            }
            if (this.wrappedStyle) {
                Part inPart = this.getWrappedPart(this.input);
                QName name = inPart.getElementName();
                if (!name.getLocalPart().equals(this.operationName)) {
                    throw new DeploymentException("message " + this.input.getQName() + " refers to a global element named " + name.getLocalPart() + ", which is not equal to the operation name " + this.operationName);
                }
                inParameter = this.getWrapperChild(inPart, wsdlMessagePartName);
                paramQName = new QName("", inParameter.getName().getLocalPart());
                paramTypeQName = inParameter.getType().getName();
            } else if (this.rpcStyle) {
                part = this.input.getPart(wsdlMessagePartName);
                if (part == null) {
                    throw new DeploymentException("No part for wsdlMessagePartName " + wsdlMessagePartName + " in input message for operation " + this.operationName);
                }
                paramQName = new QName("", part.getName());
                paramTypeQName = part.getTypeName();
            } else {
                part = this.input.getPart(wsdlMessagePartName);
                if (part == null) {
                    throw new DeploymentException("No part for wsdlMessagePartName " + wsdlMessagePartName + " in input message for operation " + this.operationName);
                }
                paramTypeQName = paramQName = this.getPartName(part);
            }
            this.inParamNames.add(wsdlMessagePartName);
            if (isOutParam) {
                if (this.wrappedStyle) {
                    outPart = this.getWrappedPart(this.output);
                    outParameter = this.getWrapperChild(outPart, wsdlMessagePartName);
                    if (inParameter.getType() != outParameter.getType()) {
                        throw new DeploymentException("The wrapper children " + wsdlMessagePartName + " do not have the same type for operation " + this.operationName);
                    }
                } else if (this.rpcStyle) {
                    outPart = this.output.getPart(wsdlMessagePartName);
                    if (outPart == null) {
                        throw new DeploymentException("No part for wsdlMessagePartName " + wsdlMessagePartName + " in output message for INOUT parameter of operation " + this.operationName);
                    }
                    if (!part.getName().equals(outPart.getName())) {
                        throw new DeploymentException("Mismatched input part name: " + part.getName() + " and output part name: " + outPart.getName() + " for INOUT parameter for wsdlMessagePartName " + wsdlMessagePartName + " for operation " + this.operationName);
                    }
                    if (!(part.getElementName() != null ? part.getElementName().equals(outPart.getElementName()) : outPart.getElementName() == null)) {
                        throw new DeploymentException("Mismatched input part element name: " + part.getElementName() + " and output part element name: " + outPart.getElementName() + " for INOUT parameter for wsdlMessagePartName " + wsdlMessagePartName + " for operation " + this.operationName);
                    }
                    if (!(part.getTypeName() != null ? part.getTypeName().equals(outPart.getTypeName()) : outPart.getTypeName() == null)) {
                        throw new DeploymentException("Mismatched input part type name: " + part.getTypeName() + " and output part type name: " + outPart.getTypeName() + " for INOUT parameter for wsdlMessagePartName " + wsdlMessagePartName + " for operation " + this.operationName);
                    }
                } else {
                    part = this.output.getPart(wsdlMessagePartName);
                    if (part == null) {
                        throw new DeploymentException("No part for wsdlMessagePartName " + wsdlMessagePartName + " in output message for operation " + this.operationName);
                    }
                    paramTypeQName = paramQName = this.getPartName(part);
                }
                this.outParamNames.add(wsdlMessagePartName);
            }
        } else if (isOutParam) {
            if (!wsdlMessageQName.equals(this.output.getQName())) {
                throw new DeploymentException("QName of output message: " + this.output.getQName() + " does not match mapping message QName: " + wsdlMessageQName + " for operation " + this.operationName);
            }
            if (this.wrappedStyle) {
                outPart = this.getWrappedPart(this.output);
                outParameter = this.getWrapperChild(outPart, wsdlMessagePartName);
                paramQName = new QName("", outParameter.getName().getLocalPart());
                paramTypeQName = outParameter.getType().getName();
            } else if (this.rpcStyle) {
                part = this.output.getPart(wsdlMessagePartName);
                if (part == null) {
                    throw new DeploymentException("No part for wsdlMessagePartName " + wsdlMessagePartName + " in output message for operation " + this.operationName);
                }
                paramQName = new QName("", part.getName());
                paramTypeQName = part.getTypeName();
            } else {
                part = this.output.getPart(wsdlMessagePartName);
                if (part == null) {
                    throw new DeploymentException("No part for wsdlMessagePartName " + wsdlMessagePartName + " in output message for operation " + this.operationName);
                }
                paramTypeQName = paramQName = this.getPartName(part);
            }
            this.outParamNames.add(wsdlMessagePartName);
        } else {
            throw new AssertionError((Object)"a param mapping has to be IN or OUT or INOUT");
        }
        boolean isComplexType = this.schemaInfoBuilder.getComplexTypesInWsdl().containsKey(paramTypeQName);
        String paramJavaTypeName = paramMapping.getParamType().getStringValue().trim();
        boolean isInOnly = mode == 1;
        Class actualParamJavaType = WSDescriptorParser.getHolderType((String)paramJavaTypeName, (boolean)isInOnly, (QName)paramTypeQName, (boolean)isComplexType, (JavaWsdlMappingType)this.mapping, (ClassLoader)this.classLoader);
        ParameterDesc parameterDesc = new ParameterDesc(paramQName, mode, paramTypeQName, actualParamJavaType, inHeader, outHeader);
        return parameterDesc;
    }

    private QName getPartName(Part part) {
        return null == part.getElementName() ? part.getTypeName() : part.getElementName();
    }

    private Part getWrappedPart(Message message) throws DeploymentException {
        Collection parts = message.getParts().values();
        if (1 != parts.size()) {
            throw new DeploymentException("message " + message.getQName() + " has " + parts.size() + " parts and should only have one as wrapper style mapping is specified for operation " + this.operationName);
        }
        return (Part)parts.iterator().next();
    }

    private SchemaParticle getWrapperChild(Part part, String wsdlMessagePartName) throws DeploymentException {
        QName name = part.getElementName();
        this.wrapperElementQNames.add(name);
        SchemaType operationType = (SchemaType)this.schemaInfoBuilder.getComplexTypesInWsdl().get(name);
        if (null == operationType) {
            throw new DeploymentException("No global element named " + name + " for operation " + this.operationName);
        }
        SchemaParticle parametersType = operationType.getContentModel();
        if (4 == parametersType.getParticleType()) {
            if (parametersType.getName().getLocalPart().equals(wsdlMessagePartName)) {
                return parametersType;
            }
            throw new DeploymentException("Global element named " + name + " does not define a child element named " + wsdlMessagePartName + " required by the operation " + this.operationName);
        }
        if (3 == parametersType.getParticleType()) {
            SchemaParticle[] parameters = parametersType.getParticleChildren();
            for (int i = 0; i < parameters.length; ++i) {
                SchemaParticle parameter = parameters[i];
                QName element = parameter.getName();
                if (!element.getLocalPart().equals(wsdlMessagePartName)) continue;
                return parameter;
            }
            throw new DeploymentException("Global element named " + name + " does not define a child element named " + wsdlMessagePartName + " required by the operation " + this.operationName);
        }
        throw new DeploymentException("Global element named " + name + " is not a sequence for operation " + this.operationName);
    }

    static {
        qnameToClassMap.put(new QName("http://www.w3.org/2001/XMLSchema", "string"), String.class);
        qnameToClassMap.put(new QName("http://www.w3.org/2001/XMLSchema", "integer"), BigInteger.class);
        qnameToClassMap.put(new QName("http://www.w3.org/2001/XMLSchema", "int"), Integer.TYPE);
        qnameToClassMap.put(new QName("http://www.w3.org/2001/XMLSchema", "long"), Long.TYPE);
        qnameToClassMap.put(new QName("http://www.w3.org/2001/XMLSchema", "short"), Short.TYPE);
        qnameToClassMap.put(new QName("http://www.w3.org/2001/XMLSchema", "decimal"), BigDecimal.class);
        qnameToClassMap.put(new QName("http://www.w3.org/2001/XMLSchema", "float"), Float.TYPE);
        qnameToClassMap.put(new QName("http://www.w3.org/2001/XMLSchema", "double"), Double.TYPE);
        qnameToClassMap.put(new QName("http://www.w3.org/2001/XMLSchema", "boolean"), Boolean.TYPE);
        qnameToClassMap.put(new QName("http://www.w3.org/2001/XMLSchema", "byte"), Byte.TYPE);
        qnameToClassMap.put(new QName("http://www.w3.org/2001/XMLSchema", "unsignedInt"), Long.TYPE);
        qnameToClassMap.put(new QName("http://www.w3.org/2001/XMLSchema", "unsignedShort"), Integer.TYPE);
        qnameToClassMap.put(new QName("http://www.w3.org/2001/XMLSchema", "unsignedByte"), Short.TYPE);
        qnameToClassMap.put(new QName("http://www.w3.org/2001/XMLSchema", "QName"), QName.class);
        qnameToClassMap.put(new QName("http://www.w3.org/2001/XMLSchema", "dateTime"), Calendar.class);
        qnameToClassMap.put(new QName("http://www.w3.org/2001/XMLSchema", "date"), Calendar.class);
        qnameToClassMap.put(new QName("http://www.w3.org/2001/XMLSchema", "time"), Calendar.class);
        qnameToClassMap.put(new QName("http://www.w3.org/2001/XMLSchema", "anyURI"), URI.class);
        qnameToClassMap.put(new QName("http://www.w3.org/2001/XMLSchema", "base64Binary"), [B.class);
        qnameToClassMap.put(new QName("http://www.w3.org/2001/XMLSchema", "hexBinary"), [B.class);
        qnameToClassMap.put(new QName("http://www.w3.org/2001/XMLSchema", "anySimpleType"), String.class);
    }
}

