/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.aries;

import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Set;
import org.apache.geronimo.osgi.web.WebApplicationListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class WebApplicationTracker
implements WebApplicationListener {
    private final BundleContext bundleContext;
    private ServiceRegistration registration;
    private Set<Bundle> completed;

    public WebApplicationTracker(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.completed = Collections.synchronizedSet(new HashSet());
    }

    public void start() {
        this.registration = this.bundleContext.registerService(WebApplicationListener.class.getName(), (Object)this, null);
    }

    public void stop() {
        if (this.registration != null) {
            this.registration.unregister();
        }
    }

    public synchronized boolean waitForBundles(Set<Bundle> bundles, long timeout) throws InterruptedException {
        while (!this.completed.containsAll(bundles)) {
            if (timeout <= 0L) {
                return false;
            }
            long startTime = System.currentTimeMillis();
            this.wait(timeout);
            long endTime = System.currentTimeMillis();
            timeout -= endTime - startTime;
        }
        return true;
    }

    public synchronized void deployed(Bundle bundle, String contextPath, Dictionary<String, Object> arg2) {
        this.completed.add(bundle);
        this.notifyAll();
    }

    public synchronized void deploying(Bundle bundle, String contextPath, Dictionary<String, Object> arg2) {
        this.completed.remove(bundle);
    }

    public synchronized void failed(Bundle bundle, String contextPath, Dictionary<String, Object> arg2) {
        this.completed.add(bundle);
        this.notifyAll();
    }

    public synchronized void undeployed(Bundle bundle, String contextPath, Dictionary<String, Object> arg2) {
    }

    public synchronized void undeploying(Bundle bundle, String contextPath, Dictionary<String, Object> arg2) {
        this.completed.remove(bundle);
    }
}

