/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.aries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public class ResolverErrorAnalyzer {
    private BundleContext bundleContext;

    public ResolverErrorAnalyzer(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    private boolean hasPlatformAdmin() {
        try {
            this.bundleContext.getBundle().loadClass("org.eclipse.osgi.service.resolver.PlatformAdmin");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public String getErrorsAsString(Collection<Bundle> bundles) {
        Collection<ErrorDetail> errors = this.getErrors(bundles);
        if (errors.isEmpty()) {
            return null;
        }
        ErrorDetail error = new ErrorDetail("The following problems were detected:", errors);
        return error.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ErrorDetail> getErrors(Collection<Bundle> bundles) {
        if (!this.hasPlatformAdmin()) {
            return Collections.emptyList();
        }
        ArrayList<ErrorDetail> errors = new ArrayList<ErrorDetail>();
        ServiceReference ref = this.bundleContext.getServiceReference(PlatformAdmin.class.getName());
        try {
            PlatformAdmin platformAdmin = (PlatformAdmin)this.bundleContext.getService(ref);
            State systemState = platformAdmin.getState(false);
            ArrayList<BundleDescription> bundleDescriptions = new ArrayList<BundleDescription>(bundles.size());
            for (Bundle bundle : bundles) {
                BundleDescription bundleDescription = systemState.getBundle(bundle.getBundleId());
                if (bundleDescription == null) continue;
                bundleDescriptions.add(bundleDescription);
            }
            for (BundleDescription bundleDescription : bundleDescriptions) {
                this.collectErrors(bundleDescription, systemState, bundleDescriptions, errors);
            }
        }
        finally {
            this.bundleContext.ungetService(ref);
        }
        return errors;
    }

    private void collectErrors(BundleDescription bundle, State state, List<BundleDescription> bundleDescriptions, Collection<ErrorDetail> errorList) {
        ResolverError[] errors;
        block7: for (ResolverError error : errors = state.getResolverErrors(bundle)) {
            VersionConstraint constraint = error.getUnsatisfiedConstraint();
            switch (error.getType()) {
                case 1: {
                    ImportPackageSpecification importPackageSpecification = (ImportPackageSpecification)constraint;
                    String resolution = (String)importPackageSpecification.getDirective("resolution");
                    if ("optional".equals(resolution) || "dynamic".equals(resolution) || ResolverErrorAnalyzer.isSatisfied(importPackageSpecification, bundleDescriptions) != null) continue block7;
                    ErrorDetail errorDetail = new ErrorDetail("The package dependency " + ResolverErrorAnalyzer.versionToString((VersionConstraint)importPackageSpecification) + " required by bundle " + ResolverErrorAnalyzer.bundleToString(bundle) + " cannot be satisfied.");
                    this.getUnsatisfiedReason(state, importPackageSpecification, errorDetail);
                    errorList.add(errorDetail);
                    continue block7;
                }
                case 2: {
                    BundleSpecification bundleSpecification = (BundleSpecification)constraint;
                    if (bundleSpecification.isOptional() || ResolverErrorAnalyzer.isSatisfied((VersionConstraint)bundleSpecification, bundleDescriptions) != null) continue block7;
                    errorList.add(new ErrorDetail("The bundle dependency " + ResolverErrorAnalyzer.versionToString((VersionConstraint)bundleSpecification) + " required by bundle " + ResolverErrorAnalyzer.bundleToString(bundle) + " cannot be satisfied."));
                    continue block7;
                }
                case 4: {
                    HostSpecification hostSpecification = (HostSpecification)constraint;
                    if (ResolverErrorAnalyzer.isSatisfied((VersionConstraint)hostSpecification, bundleDescriptions) != null) continue block7;
                    errorList.add(new ErrorDetail("The host bundle dependency " + ResolverErrorAnalyzer.versionToString((VersionConstraint)hostSpecification) + " required by bundle " + ResolverErrorAnalyzer.bundleToString(bundle) + " cannot be satisfied."));
                    continue block7;
                }
                case 32: {
                    ImportPackageSpecification usesImportPackageSpecification = (ImportPackageSpecification)constraint;
                    errorList.add(new ErrorDetail("The package dependency " + ResolverErrorAnalyzer.versionToString((VersionConstraint)usesImportPackageSpecification) + " required by bundle " + ResolverErrorAnalyzer.bundleToString(bundle) + " cannot be resolved due to uses directive conflict."));
                    continue block7;
                }
                case 64: {
                    BundleSpecification usesBundleSpecification = (BundleSpecification)constraint;
                    errorList.add(new ErrorDetail("The bundle dependency " + ResolverErrorAnalyzer.versionToString((VersionConstraint)usesBundleSpecification) + " required by bundle " + ResolverErrorAnalyzer.bundleToString(bundle) + " cannot be resolved due to uses directive conflict."));
                    continue block7;
                }
                default: {
                    errorList.add(new ErrorDetail(error.toString()));
                }
            }
        }
    }

    private static ExportPackageDescription isSatisfied(ImportPackageSpecification importPackageSpecification, Collection<BundleDescription> bundleDescriptions) {
        for (BundleDescription b : bundleDescriptions) {
            ExportPackageDescription[] exportedPackages = b.isResolved() ? b.getSelectedExports() : b.getExportPackages();
            if (exportedPackages == null) continue;
            for (ExportPackageDescription exportedPackage : exportedPackages) {
                if (!importPackageSpecification.isSatisfiedBy((BaseDescription)exportedPackage)) continue;
                return exportedPackage;
            }
        }
        return null;
    }

    private static BundleDescription isSatisfied(VersionConstraint constraint, Collection<BundleDescription> bundleDescriptions) {
        for (BundleDescription b : bundleDescriptions) {
            if (!constraint.isSatisfiedBy((BaseDescription)b)) continue;
            return b;
        }
        return null;
    }

    private void getUnsatisfiedReason(State state, ImportPackageSpecification importPackage, ErrorDetail errorDetail) {
        String packageName = importPackage.getName();
        BundleDescription[] bundles = state.getBundles();
        ArrayList<ExportPackageDescription> packageExportList = new ArrayList<ExportPackageDescription>();
        for (BundleDescription bundle : bundles) {
            this.findExportPackage(packageName, bundle.getExportPackages(), packageExportList);
        }
        int size = packageExportList.size();
        if (size == 0) {
            errorDetail.add("Package " + packageName + " is not exported by any bundle.");
        } else if (size == 1) {
            ExportPackageDescription packageExport = (ExportPackageDescription)packageExportList.get(0);
            BundleDescription exporter = packageExport.getExporter();
            errorDetail.add("Bundle " + ResolverErrorAnalyzer.bundleToString(exporter) + " exports " + ResolverErrorAnalyzer.exportToString(packageExport) + " package which does not satisfy the dependency.");
        } else {
            for (ExportPackageDescription packageExport : packageExportList) {
                BundleDescription exporter = packageExport.getExporter();
                if (exporter.isResolved() && !this.isSelectedExportPackage(packageExport) && importPackage.isSatisfiedBy((BaseDescription)packageExport)) {
                    errorDetail.add("Bundle " + ResolverErrorAnalyzer.bundleToString(exporter) + " exports " + ResolverErrorAnalyzer.exportToString(packageExport) + " package which satisfies the dependency but is unselected.");
                    continue;
                }
                errorDetail.add("Bundle " + ResolverErrorAnalyzer.bundleToString(exporter) + " exports " + ResolverErrorAnalyzer.exportToString(packageExport) + " package which does not satisfy the dependency.");
            }
        }
    }

    private void findExportPackage(String packageName, ExportPackageDescription[] exportedPackages, List<ExportPackageDescription> list) {
        if (exportedPackages != null) {
            for (ExportPackageDescription exportedPackage : exportedPackages) {
                if (!packageName.equals(exportedPackage.getName())) continue;
                list.add(exportedPackage);
            }
        }
    }

    private boolean isSelectedExportPackage(ExportPackageDescription exportedPackage) {
        BundleDescription exporter = exportedPackage.getExporter();
        ExportPackageDescription[] selectedExportPackages = exporter.getSelectedExports();
        if (selectedExportPackages != null) {
            for (ExportPackageDescription selectedExportedPackage : selectedExportPackages) {
                if (!exportedPackage.equals(selectedExportedPackage)) continue;
                return true;
            }
        }
        return false;
    }

    private static String bundleToString(BundleDescription bundle) {
        return bundle.getSymbolicName() + " [" + bundle.getBundleId() + "]";
    }

    private static String versionToString(VersionConstraint constraint) {
        VersionRange versionRange = constraint.getVersionRange();
        if (versionRange == null) {
            return constraint.getName();
        }
        String versionAttribute = constraint instanceof ImportPackageSpecification ? "version=\"" + versionRange + "\"" : "bundle-version=\"" + versionRange + "\"";
        return constraint.getName() + "; " + versionAttribute;
    }

    private static String exportToString(ExportPackageDescription exportPackage) {
        Version version = exportPackage.getVersion();
        if (version == null) {
            return exportPackage.getName();
        }
        String versionAttribute = "version=\"" + version + "\"";
        return exportPackage.getName() + "; " + versionAttribute;
    }

    public static class ErrorDetail {
        public static final String LF = System.getProperty("line.separator");
        private String message;
        private Collection<ErrorDetail> details;

        public ErrorDetail(String message) {
            this.message = message;
        }

        public ErrorDetail(String message, Collection<ErrorDetail> details) {
            this.message = message;
            this.details = details;
        }

        public void add(ErrorDetail detail) {
            if (this.details == null) {
                this.details = new ArrayList<ErrorDetail>();
            }
            this.details.add(detail);
        }

        public void add(String message) {
            this.add(new ErrorDetail(message));
        }

        public void toString(StringBuilder builder, String pad) {
            builder.append(this.message);
            if (this.details != null && !this.details.isEmpty()) {
                builder.append(LF);
                Iterator<ErrorDetail> iterator = this.details.iterator();
                while (iterator.hasNext()) {
                    builder.append(pad);
                    iterator.next().toString(builder, pad + pad);
                    if (!iterator.hasNext()) continue;
                    builder.append(LF);
                }
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            this.toString(builder, "    ");
            return builder.toString();
        }
    }
}

