/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.aries;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.aries.application.ApplicationMetadata;
import org.apache.aries.application.ApplicationMetadataFactory;
import org.apache.aries.application.DeploymentMetadata;
import org.apache.aries.application.DeploymentMetadataFactory;
import org.apache.aries.application.filesystem.IDirectory;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.AriesApplicationManager;
import org.apache.aries.application.management.BundleInfo;
import org.apache.aries.application.management.ManagementException;
import org.apache.aries.application.management.ResolveConstraint;
import org.apache.aries.application.management.ResolverException;
import org.apache.aries.application.utils.management.SimpleBundleInfo;
import org.apache.aries.application.utils.manifest.BundleManifest;
import org.apache.aries.application.utils.manifest.ManifestDefaultsInjector;
import org.apache.aries.application.utils.manifest.ManifestProcessor;
import org.apache.geronimo.aries.GeronimoApplication;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.geronimo.kernel.util.JarUtils;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceException;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeronimoApplicationManager {
    private static final Attributes.Name APPLICATION_CONTENT_NAME = new Attributes.Name("Application-Content");
    private static final Logger LOG = LoggerFactory.getLogger(GeronimoApplicationManager.class);
    private BundleContext bundleContext;
    private ServiceTracker deploymentFactoryTracker;
    private ServiceTracker applicationFactoryTracker;
    private ServiceTracker applicationManagerTracker;

    public GeronimoApplicationManager(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.deploymentFactoryTracker = new ServiceTracker(bundleContext, DeploymentMetadataFactory.class.getName(), null);
        this.applicationFactoryTracker = new ServiceTracker(bundleContext, ApplicationMetadataFactory.class.getName(), null);
        this.applicationManagerTracker = new ServiceTracker(bundleContext, AriesApplicationManager.class.getName(), null);
    }

    public void doStart() throws Exception {
        this.deploymentFactoryTracker.open();
        this.applicationFactoryTracker.open();
        this.applicationManagerTracker.open();
    }

    public void doStop() {
        this.deploymentFactoryTracker.close();
        this.applicationFactoryTracker.close();
        this.applicationManagerTracker.close();
    }

    public DeploymentMetadataFactory getDeploymentMetadataFactory() throws ManagementException {
        DeploymentMetadataFactory service = (DeploymentMetadataFactory)this.deploymentFactoryTracker.getService();
        if (service == null) {
            throw new ManagementException((Exception)new ServiceException(DeploymentMetadataFactory.class.getName(), 1));
        }
        return service;
    }

    public ApplicationMetadataFactory getApplicationMetadataFactory() throws ManagementException {
        ApplicationMetadataFactory service = (ApplicationMetadataFactory)this.applicationFactoryTracker.getService();
        if (service == null) {
            throw new ManagementException((Exception)new ServiceException(ApplicationMetadataFactory.class.getName(), 1));
        }
        return service;
    }

    private AriesApplicationManager getAriesApplicationManager() throws ManagementException {
        AriesApplicationManager service = (AriesApplicationManager)this.applicationManagerTracker.getService();
        if (service == null) {
            throw new ManagementException((Exception)new ServiceException(AriesApplicationManager.class.getName(), 1));
        }
        return service;
    }

    public AriesApplication createApplication(JarFile ebaJarFile) throws IOException, ManagementException {
        File ebaFile = new File(ebaJarFile.getName());
        if (!ebaFile.isDirectory()) {
            throw new IOException("Must be expanded Aries Application");
        }
        Manifest applicationMF = this.readApplicationManifest(ebaJarFile);
        Set<BundleInfo> bundleInfos = this.getBundleInfos(ebaFile);
        if (applicationMF.getMainAttributes().get(APPLICATION_CONTENT_NAME) == null) {
            String appContent = this.buildAppContent(bundleInfos);
            applicationMF.getMainAttributes().put(APPLICATION_CONTENT_NAME, appContent);
        }
        ManifestDefaultsInjector.updateManifest((Manifest)applicationMF, (String)ebaFile.getName(), (File)ebaFile);
        ApplicationMetadata applicationMetadata = this.getApplicationMetadataFactory().createApplicationMetadata(applicationMF);
        DeploymentMetadata deploymentMetadata = this.readDeploymentManifest(ebaJarFile);
        return new GeronimoApplication(applicationMetadata, deploymentMetadata, bundleInfos);
    }

    public GeronimoApplication loadApplication(JarFile ebaJarFile) throws IOException, ManagementException {
        return (GeronimoApplication)this.createApplication(ebaJarFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeronimoApplication loadApplication(Bundle bundle) throws IOException, ManagementException {
        ApplicationMetadata applicationMetadata = null;
        URL applicationMF = bundle.getEntry("META-INF/APPLICATION.MF");
        InputStream applicationMFStream = null;
        try {
            applicationMFStream = applicationMF.openStream();
            applicationMetadata = this.getApplicationMetadataFactory().parseApplicationMetadata(applicationMFStream);
        }
        finally {
            IOUtils.close((Closeable)applicationMFStream);
        }
        DeploymentMetadata deploymentMetadata = null;
        URL deploymentMF = bundle.getEntry("META-INF/DEPLOYMENT.MF");
        if (deploymentMF != null) {
            InputStream deploymentMFStream = null;
            try {
                deploymentMFStream = deploymentMF.openStream();
                deploymentMetadata = this.getDeploymentMetadataFactory().createDeploymentMetadata(deploymentMFStream);
            }
            finally {
                IOUtils.close((Closeable)deploymentMFStream);
            }
        }
        Set<BundleInfo> bundleInfos = null;
        File bundleFile = BundleUtils.toFile((Bundle)bundle);
        bundleInfos = bundleFile != null && bundleFile.isDirectory() ? this.getBundleInfos(bundleFile) : this.getBundleInfos(bundle);
        return new GeronimoApplication(applicationMetadata, deploymentMetadata, bundleInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeronimoApplication loadApplication(File ebaFile) throws IOException, ManagementException {
        JarFile jarFile = null;
        try {
            jarFile = JarUtils.createJarFile((File)ebaFile);
            GeronimoApplication geronimoApplication = this.loadApplication(jarFile);
            return geronimoApplication;
        }
        finally {
            JarUtils.close((JarFile)jarFile);
        }
    }

    private Set<BundleInfo> getBundleInfos(File baseDir) throws IOException, ManagementException {
        ApplicationMetadataFactory applicationMetadataFactory = this.getApplicationMetadataFactory();
        HashSet<BundleInfo> bundleInfos = new HashSet<BundleInfo>();
        this.collectBundleInfos(baseDir, applicationMetadataFactory, bundleInfos);
        return bundleInfos;
    }

    private void collectBundleInfos(File baseDir, ApplicationMetadataFactory applicationMetadataFactory, Set<BundleInfo> bundleInfos) throws IOException, ManagementException {
        for (File file : baseDir.listFiles()) {
            BundleManifest bm;
            if (file.isDirectory()) {
                if (file.getName().endsWith(".jar")) {
                    bm = this.fromBundle(file);
                    if (bm == null || !bm.isValid()) continue;
                    bundleInfos.add((BundleInfo)new SimpleBundleInfo(applicationMetadataFactory, bm, "reference:" + file.toURI().toString()));
                    continue;
                }
                this.collectBundleInfos(file, applicationMetadataFactory, bundleInfos);
                continue;
            }
            bm = this.fromBundle(file);
            if (bm == null || !bm.isValid()) continue;
            bundleInfos.add((BundleInfo)new SimpleBundleInfo(applicationMetadataFactory, bm, file.toURI().toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BundleManifest fromBundle(File file) {
        BundleManifest bundleManifest;
        if (file.isFile()) {
            BundleManifest bundleManifest2;
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                bundleManifest2 = BundleManifest.fromBundle((InputStream)in);
            }
            catch (IOException e) {
                try {
                    LOG.debug("Error reading file: " + file, (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.close(in);
                    throw throwable;
                }
                IOUtils.close((Closeable)in);
                return null;
            }
            IOUtils.close((Closeable)in);
            return bundleManifest2;
        }
        if (!file.isDirectory()) throw new IllegalArgumentException("Unsupported file type: " + file);
        File manifestFile = new File(file, "META-INF/MANIFEST.MF");
        if (!manifestFile.isFile()) return null;
        FileInputStream in = null;
        try {
            in = new FileInputStream(manifestFile);
            bundleManifest = new BundleManifest((InputStream)in);
        }
        catch (IOException e) {
            try {
                LOG.debug("Error reading manifest file: " + file, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.close(in);
                throw throwable;
            }
            IOUtils.close((Closeable)in);
            return null;
        }
        IOUtils.close((Closeable)in);
        return bundleManifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BundleManifest fromBundle(InputStream jarInputStream) {
        try {
            BundleManifest bundleManifest = BundleManifest.fromBundle((InputStream)jarInputStream);
            return bundleManifest;
        }
        finally {
            IOUtils.close((Closeable)jarInputStream);
        }
    }

    private Set<BundleInfo> getBundleInfos(Bundle bundle) throws IOException, ManagementException {
        ApplicationMetadataFactory applicationMetadataFactory = this.getApplicationMetadataFactory();
        HashSet<BundleInfo> bundleInfos = new HashSet<BundleInfo>();
        Enumeration e = bundle.findEntries("/", "*", true);
        while (e.hasMoreElements()) {
            BundleManifest bm;
            URL url = (URL)e.nextElement();
            if (url.getPath().endsWith("/") || (bm = this.fromBundle(url.openStream())) == null || !bm.isValid()) continue;
            bundleInfos.add((BundleInfo)new SimpleBundleInfo(applicationMetadataFactory, bm, url.toExternalForm()));
        }
        return bundleInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest readApplicationManifest(JarFile ebaJarFile) throws IOException {
        Manifest manifest;
        ZipEntry entry = ebaJarFile.getEntry("META-INF/APPLICATION.MF");
        if (entry != null) {
            InputStream applicationMFStream = null;
            try {
                applicationMFStream = ebaJarFile.getInputStream(entry);
                manifest = ManifestProcessor.parseManifest((InputStream)applicationMFStream);
            }
            finally {
                IOUtils.close((Closeable)applicationMFStream);
            }
        } else {
            manifest = new Manifest();
        }
        return manifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeploymentMetadata readDeploymentManifest(JarFile ebaJarFile) throws IOException, ManagementException {
        DeploymentMetadata deploymentMetadata = null;
        ZipEntry entry = ebaJarFile.getEntry("META-INF/DEPLOYMENT.MF");
        if (entry != null) {
            InputStream deploymentMFStream = null;
            try {
                deploymentMFStream = ebaJarFile.getInputStream(entry);
                deploymentMetadata = this.getDeploymentMetadataFactory().createDeploymentMetadata(deploymentMFStream);
            }
            finally {
                IOUtils.close((Closeable)deploymentMFStream);
            }
        }
        return deploymentMetadata;
    }

    private String buildAppContent(Set<BundleInfo> bundleInfos) {
        StringBuilder builder = new StringBuilder();
        Iterator<BundleInfo> iterator = bundleInfos.iterator();
        while (iterator.hasNext()) {
            BundleInfo info = iterator.next();
            builder.append(info.getSymbolicName());
            if (info.getVersion() != null) {
                String version = info.getVersion().toString();
                builder.append(";version=\"[");
                builder.append(version);
                builder.append(',');
                builder.append(version);
                builder.append("]\"");
            }
            if (!iterator.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public ApplicationMetadata getApplicationMetadata(JarFile ebaJarFile) throws IOException, ManagementException {
        Manifest applicationMF = this.readApplicationManifest(ebaJarFile);
        boolean dummyAppContent = false;
        if (applicationMF.getMainAttributes().get(APPLICATION_CONTENT_NAME) == null) {
            applicationMF.getMainAttributes().put(APPLICATION_CONTENT_NAME, "none");
            dummyAppContent = true;
        }
        File ebaFile = new File(ebaJarFile.getName());
        ManifestDefaultsInjector.updateManifest((Manifest)applicationMF, (String)ebaFile.getName(), (File)ebaFile);
        if (dummyAppContent) {
            applicationMF.getMainAttributes().remove(APPLICATION_CONTENT_NAME);
        }
        ApplicationMetadata applicationMetadata = this.getApplicationMetadataFactory().createApplicationMetadata(applicationMF);
        return applicationMetadata;
    }

    public AriesApplication resolve(AriesApplication app, ResolveConstraint ... constraints) throws ResolverException {
        try {
            return this.getAriesApplicationManager().resolve(app, constraints);
        }
        catch (ManagementException e) {
            throw new ResolverException((Exception)((Object)e));
        }
    }

    public AriesApplication createApplication(IDirectory ebaFile) throws ManagementException {
        return this.getAriesApplicationManager().createApplication(ebaFile);
    }
}

