/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.aries;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.aries.application.ApplicationMetadata;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.AriesApplicationContext;
import org.apache.aries.application.management.AriesApplicationContextManager;
import org.apache.aries.application.management.ManagementException;
import org.apache.geronimo.aries.ApplicationInstaller;
import org.apache.geronimo.aries.GeronimoApplicationContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class GeronimoApplicationContextManager
implements AriesApplicationContextManager {
    private ConcurrentMap<String, GeronimoApplicationContext> contextMap = new ConcurrentHashMap<String, GeronimoApplicationContext>();
    private BundleContext bundleContext;
    private ServiceReference installerReference;
    private ApplicationInstaller installer;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected void registerApplicationContext(GeronimoApplicationContext context) {
        this.contextMap.put(this.getApplicationKey(context.getApplication()), context);
    }

    private String getApplicationKey(AriesApplication app) {
        ApplicationMetadata metadata = app.getApplicationMetadata();
        return metadata.getApplicationScope();
    }

    public AriesApplicationContext getApplicationContext(AriesApplication app) throws BundleException, ManagementException {
        String key = this.getApplicationKey(app);
        GeronimoApplicationContext applicationContext = (GeronimoApplicationContext)this.contextMap.get(key);
        if (applicationContext == null) {
            try {
                this.getApplicationInstaller().install(app);
            }
            catch (Exception e) {
                throw new BundleException("Application installation failed", (Throwable)e);
            }
            applicationContext = (GeronimoApplicationContext)this.contextMap.get(key);
            if (applicationContext == null) {
                throw new ManagementException("No ApplicationContext");
            }
        }
        return applicationContext;
    }

    public Set<AriesApplicationContext> getApplicationContexts() {
        HashSet<AriesApplicationContext> result = new HashSet<AriesApplicationContext>();
        result.addAll(this.contextMap.values());
        return result;
    }

    public void remove(AriesApplicationContext app) {
        String key = this.getApplicationKey(app.getApplication());
        GeronimoApplicationContext applicationContext = (GeronimoApplicationContext)this.contextMap.remove(key);
        if (applicationContext != null) {
            applicationContext.uninstall();
        }
    }

    private ApplicationInstaller getApplicationInstaller() {
        if (this.installer == null) {
            this.installerReference = this.bundleContext.getServiceReference(ApplicationInstaller.class.getName());
            this.installer = (ApplicationInstaller)this.bundleContext.getService(this.installerReference);
        }
        return this.installer;
    }

    public void init() {
    }

    public void destroy() {
        if (this.installerReference != null) {
            this.bundleContext.ungetService(this.installerReference);
        }
    }
}

