/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.aries;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.aries.application.ApplicationMetadata;
import org.apache.aries.application.management.AriesApplication;
import org.apache.geronimo.aries.ApplicationGBean;
import org.apache.geronimo.aries.WebApplicationTracker;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationAlreadyExistsException;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.kernel.util.BundleUtil;
import org.apache.geronimo.kernel.util.FileUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
public class ApplicationInstaller
implements GBeanLifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationInstaller.class);
    private Kernel kernel;
    private BundleContext bundleContext;
    private AbstractName abstractName;
    private ServiceRegistration registration;
    private ConfigurationManager configurationManager;
    private WebApplicationTracker webApplicationTracker;
    private Collection<? extends Repository> repositories;
    private Collection<ConfigurationStore> configurationStores;
    private Environment defaultEnvironment;

    public ApplicationInstaller(@ParamReference(name="Store", namingType="ConfigurationStore") Collection<ConfigurationStore> configurationStores, @ParamReference(name="Repositories", namingType="Repository") Collection<? extends Repository> repositories, @ParamAttribute(name="defaultEnvironment") Environment defaultEnvironment, @ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel, @ParamSpecial(type=SpecialAttributeType.bundleContext) BundleContext bundleContext, @ParamSpecial(type=SpecialAttributeType.abstractName) AbstractName abstractName) throws GBeanNotFoundException {
        this.kernel = kernel;
        this.bundleContext = bundleContext;
        this.abstractName = abstractName;
        this.repositories = repositories;
        this.configurationStores = configurationStores;
        this.configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)kernel);
        this.defaultEnvironment = defaultEnvironment;
        this.webApplicationTracker = new WebApplicationTracker(bundleContext);
    }

    public void doStart() throws Exception {
        this.registration = this.bundleContext.registerService(ApplicationInstaller.class.getName(), (Object)this, null);
        this.webApplicationTracker.start();
    }

    public void doStop() {
        if (this.registration != null) {
            this.registration.unregister();
        }
        this.webApplicationTracker.stop();
    }

    public void doFail() {
        this.doStop();
    }

    protected ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    protected WebApplicationTracker getWebApplicationTracker() {
        return this.webApplicationTracker;
    }

    public DeploymentContext startInstall(AriesApplication app, ConfigurationStore targetConfigurationStore) throws ConfigurationAlreadyExistsException, IOException, DeploymentException {
        Artifact configId = ApplicationInstaller.getConfigId(app.getApplicationMetadata());
        targetConfigurationStore.createNewConfigurationDir(configId);
        Environment environment = new Environment();
        environment.setConfigId(configId);
        EnvironmentBuilder.mergeEnvironments((Environment)environment, (Environment)this.defaultEnvironment);
        Naming naming = this.kernel.getNaming();
        AbstractName moduleName = naming.createRootName(configId, configId.toString(), "AriesApplication");
        File tempDirectory = FileUtils.createTempDir();
        try {
            DeploymentContext context = new DeploymentContext(tempDirectory, null, environment, moduleName, ConfigurationModuleType.EBA, naming, this.configurationManager, null, this.bundleContext);
            context.flush();
            context.initializeConfiguration();
            app.store(tempDirectory);
            AbstractName name = naming.createChildName(moduleName, "AriesApplication", "GBean");
            GBeanData data = new GBeanData(name, ApplicationGBean.class);
            data.setAttribute("configId", (Object)configId);
            data.setReferencePattern("Installer", this.abstractName);
            context.addGBean(data);
            return context;
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException("Error deploying application", (Throwable)e);
        }
    }

    public ConfigurationData finishInstall(DeploymentContext context, ConfigurationStore targetConfigurationStore) throws ConfigurationAlreadyExistsException, DeploymentException {
        try {
            ConfigurationData configurationData = context.getConfigurationData();
            targetConfigurationStore.install(configurationData);
            ConfigurationData configurationData2 = configurationData;
            return configurationData2;
        }
        catch (Exception e) {
            throw new DeploymentException("Error installing application", (Throwable)e);
        }
        finally {
            try {
                context.close();
            }
            catch (IOException e) {}
        }
    }

    public void install(AriesApplication app) throws ConfigurationAlreadyExistsException, IOException, DeploymentException {
        ConfigurationStore store = this.configurationStores.iterator().next();
        if (store == null) {
            throw new DeploymentException("No ConfigurationStore");
        }
        DeploymentContext context = this.startInstall(app, store);
        ConfigurationData configurationData = this.finishInstall(context, store);
        try {
            this.configurationManager.loadConfiguration(configurationData.getId());
            this.configurationManager.startConfiguration(configurationData.getId());
        }
        catch (Exception e) {
            throw new DeploymentException("Error installing application", (Throwable)e);
        }
    }

    public static Artifact getConfigId(ApplicationMetadata metadata) {
        return BundleUtil.createArtifact((String)"application", (String)metadata.getApplicationSymbolicName(), (Version)metadata.getApplicationVersion());
    }

    protected File getApplicationLocation(Artifact artifactId) {
        for (Repository repository : this.repositories) {
            if (!repository.contains(artifactId)) continue;
            return repository.getLocation(artifactId);
        }
        return null;
    }
}

