/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.aries.resolver.obr.generator;

import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.aries.application.Content;
import org.apache.aries.application.management.BundleInfo;
import org.apache.aries.application.utils.manifest.ManifestHeaderProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class RepositoryDescriptorGenerator {
    public static Document generateRepositoryDescriptor(String name, Set<BundleInfo> bundles) throws ParserConfigurationException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element root = doc.createElement("repository");
        root.setAttribute("name", name);
        doc.appendChild(root);
        for (BundleInfo info : bundles) {
            Element resource = doc.createElement("resource");
            resource.setAttribute("version", info.getVersion().toString());
            resource.setAttribute("uri", info.getLocation());
            resource.setAttribute("symbolicname", info.getSymbolicName());
            resource.setAttribute("presentationname", (String)info.getHeaders().get("Bundle-Name"));
            resource.setAttribute("id", info.getSymbolicName() + "/" + info.getVersion());
            root.appendChild(resource);
            RepositoryDescriptorGenerator.addBundleCapability(doc, resource, info);
            for (Content p : info.getExportPackage()) {
                RepositoryDescriptorGenerator.addPackageCapability(doc, resource, info, p);
            }
            for (Content p : info.getImportPackage()) {
                RepositoryDescriptorGenerator.addPackageRequirement(doc, resource, info, p);
            }
            for (Content p : info.getRequireBundle()) {
                RepositoryDescriptorGenerator.addBundleRequirement(doc, resource, info, p);
            }
        }
        return doc;
    }

    private static void addBundleRequirement(Document doc, Element resource, BundleInfo info, Content p) {
        Element requirement = doc.createElement("require");
        requirement.setAttribute("name", "bundle");
        requirement.setAttribute("extend", "false");
        requirement.setAttribute("multiple", "false");
        requirement.setAttribute("optional", RepositoryDescriptorGenerator.getOptional(p));
        requirement.setAttribute("filter", ManifestHeaderProcessor.generateFilter((String)"symbolicname", (String)p.getContentName(), (Map)p.getAttributes()));
        resource.appendChild(requirement);
    }

    private static void addPackageRequirement(Document doc, Element resource, BundleInfo info, Content p) {
        Element requirement = doc.createElement("require");
        requirement.setAttribute("name", "package");
        requirement.setAttribute("extend", "false");
        requirement.setAttribute("multiple", "false");
        requirement.setAttribute("optional", RepositoryDescriptorGenerator.getOptional(p));
        requirement.setAttribute("filter", ManifestHeaderProcessor.generateFilter((String)"package", (String)p.getContentName(), (Map)p.getAttributes()));
        resource.appendChild(requirement);
    }

    private static void addPackageCapability(Document doc, Element resource, BundleInfo info, Content p) {
        Element capability = doc.createElement("capability");
        capability.setAttribute("name", "package");
        resource.appendChild(capability);
        RepositoryDescriptorGenerator.addProperty(doc, capability, "package", p.getContentName(), null);
        RepositoryDescriptorGenerator.addProperty(doc, capability, "version", p.getVersion().toString(), "version");
        RepositoryDescriptorGenerator.addProperty(doc, capability, "bundle-symbolic-name", info.getSymbolicName(), null);
        RepositoryDescriptorGenerator.addProperty(doc, capability, "bundle-version", info.getVersion().toString(), "version");
        for (Map.Entry entry : p.getAttributes().entrySet()) {
            if ("version".equals(entry.getKey())) continue;
            RepositoryDescriptorGenerator.addProperty(doc, capability, (String)entry.getKey(), (String)entry.getValue(), null);
        }
        String mandatory = p.getDirective("mandatory");
        if (mandatory == null) {
            mandatory = "";
        }
        RepositoryDescriptorGenerator.addProperty(doc, capability, "mandatory", mandatory, "set");
    }

    private static void addBundleCapability(Document doc, Element resource, BundleInfo info) {
        Element capability = doc.createElement("capability");
        capability.setAttribute("name", "bundle");
        resource.appendChild(capability);
        RepositoryDescriptorGenerator.addProperty(doc, capability, "symbolicname", info.getSymbolicName(), null);
        RepositoryDescriptorGenerator.addProperty(doc, capability, "version", info.getVersion().toString(), "version");
        RepositoryDescriptorGenerator.addProperty(doc, capability, "presentationname", (String)info.getHeaders().get("Bundle-Name"), null);
        RepositoryDescriptorGenerator.addProperty(doc, capability, "Bundle-ManifestVersion", "2", "version");
        RepositoryDescriptorGenerator.addProperty(doc, capability, "fragment-attachment", (String)info.getBundleDirectives().get("fragment-attachment"), null);
        RepositoryDescriptorGenerator.addProperty(doc, capability, "singleton", (String)info.getBundleDirectives().get("singleton"), null);
    }

    private static void addProperty(Document doc, Element capability, String name, String value, String type) {
        Element p = doc.createElement("p");
        p.setAttribute("n", name);
        p.setAttribute("v", value);
        if (type != null) {
            p.setAttribute("t", type);
        }
        capability.appendChild(p);
    }

    private static String getOptional(Content p) {
        String resolution = p.getDirective("resolution");
        if ("optional".equals(resolution)) {
            return "true";
        }
        return "false";
    }
}

