/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.aries.builder;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.aries.application.ApplicationMetadata;
import org.apache.aries.application.ApplicationMetadataFactory;
import org.apache.aries.application.DeploymentMetadata;
import org.apache.aries.application.DeploymentMetadataFactory;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.BundleInfo;
import org.apache.aries.application.utils.management.SimpleBundleInfo;
import org.apache.aries.application.utils.manifest.BundleManifest;
import org.osgi.framework.Bundle;

public class GeronimoApplication
implements AriesApplication {
    private DeploymentMetadata deploymentMetadata;
    private Set<BundleInfo> bundleInfo;

    public GeronimoApplication(Bundle bundle, ApplicationMetadataFactory applicationFactory, DeploymentMetadataFactory deploymentFactory) throws IOException {
        URL deploymentMF = bundle.getEntry("META-INF/DEPLOYMENT.MF");
        this.deploymentMetadata = deploymentFactory.createDeploymentMetadata(deploymentMF.openStream());
        this.bundleInfo = new HashSet<BundleInfo>();
        Enumeration e = bundle.findEntries("/", "*", true);
        while (e.hasMoreElements()) {
            BundleManifest bm;
            URL url = (URL)e.nextElement();
            if (url.getPath().endsWith("/") || (bm = BundleManifest.fromBundle((InputStream)url.openStream())) == null || !bm.isValid()) continue;
            this.bundleInfo.add((BundleInfo)new SimpleBundleInfo(applicationFactory, bm, url.toExternalForm()));
        }
    }

    public ApplicationMetadata getApplicationMetadata() {
        return this.deploymentMetadata.getApplicationMetadata();
    }

    public Set<BundleInfo> getBundleInfo() {
        return this.bundleInfo;
    }

    public DeploymentMetadata getDeploymentMetadata() {
        return this.deploymentMetadata;
    }

    public boolean isResolved() {
        return true;
    }

    public void store(File arg0) throws FileNotFoundException, IOException {
        throw new UnsupportedOperationException();
    }

    public void store(OutputStream arg0) throws FileNotFoundException, IOException {
        throw new UnsupportedOperationException();
    }
}

