/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.service;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.Method;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.common.propertyeditor.PropertyEditors;
import org.apache.geronimo.crypto.EncryptionManager;
import org.apache.geronimo.deployment.javabean.xbeans.BeanPropertyType;
import org.apache.geronimo.deployment.javabean.xbeans.JavabeanType;
import org.apache.geronimo.deployment.javabean.xbeans.PropertyType;
import org.apache.geronimo.deployment.service.EncryptOnPersist;
import org.apache.geronimo.deployment.service.XmlAttributeBuilder;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.xmlbeans.XmlObject;
import org.osgi.framework.Bundle;

public class JavaBeanXmlAttributeBuilder
implements XmlAttributeBuilder {
    private static final String NAMESPACE = "http://geronimo.apache.org/xml/ns/deployment/javabean-1.0";
    public static final GBeanInfo GBEAN_INFO;

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public Object getValue(XmlObject xmlObject, XmlObject enclosing, String type, Bundle bundle) throws DeploymentException {
        JavabeanType javabean = (JavabeanType)xmlObject.copy().changeType(JavabeanType.type);
        return this.internalGetValue(javabean, type, bundle);
    }

    private Object internalGetValue(JavabeanType javabean, String type, Bundle bundle) throws DeploymentException {
        PropertyDescriptor[] propertyDescriptors;
        String className = type;
        if (javabean.isSetClass1()) {
            className = javabean.getClass1();
        }
        Class clazz = null;
        try {
            clazz = bundle.loadClass(className);
            if (!type.equals(className) && !bundle.loadClass(type).isAssignableFrom(clazz)) {
                throw new DeploymentException("javabean class " + className + " is not of the expected type " + type);
            }
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Could not load alleged javabean class " + className, (Throwable)e);
        }
        Object instance = null;
        try {
            instance = clazz.newInstance();
        }
        catch (Exception e) {
            throw new DeploymentException("Could not create java bean instance", (Throwable)e);
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            propertyDescriptors = beanInfo.getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new DeploymentException("Could not analyze java bean class", (Throwable)e);
        }
        PropertyType[] properties = javabean.getPropertyArray();
        block12: for (int i = 0; i < properties.length; ++i) {
            PropertyType property = properties[i];
            String propertyName = Introspector.decapitalize(property.getName());
            String propertyString = property.getStringValue().trim();
            for (int j = 0; j < propertyDescriptors.length; ++j) {
                PropertyDescriptor propertyDescriptor = propertyDescriptors[j];
                if (!propertyName.equals(propertyDescriptor.getName())) continue;
                Method writeMethod = propertyDescriptor.getWriteMethod();
                if (writeMethod.isAnnotationPresent(EncryptOnPersist.class)) {
                    propertyString = (String)((Object)EncryptionManager.decrypt((String)propertyString));
                }
                String protertyType = propertyDescriptor.getPropertyType().getName();
                PropertyEditor propertyEditor = null;
                try {
                    propertyEditor = PropertyEditors.findEditor((String)protertyType, (Bundle)bundle);
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentException("Could not load editor for type " + protertyType, (Throwable)e);
                }
                if (propertyEditor == null) {
                    throw new DeploymentException("Unable to find PropertyEditor for " + protertyType);
                }
                propertyEditor.setAsText(propertyString);
                Object value = propertyEditor.getValue();
                try {
                    writeMethod.invoke(instance, value);
                    continue block12;
                }
                catch (Exception e) {
                    throw new DeploymentException("Could not set property value for property named " + propertyName, (Throwable)e);
                }
            }
        }
        BeanPropertyType[] beanProperties = javabean.getBeanPropertyArray();
        block14: for (int i = 0; i < beanProperties.length; ++i) {
            BeanPropertyType beanProperty = beanProperties[i];
            String propertyName = Introspector.decapitalize(beanProperty.getName().trim());
            JavabeanType innerBean = beanProperty.getJavabean();
            for (int j = 0; j < propertyDescriptors.length; ++j) {
                PropertyDescriptor propertyDescriptor = propertyDescriptors[j];
                if (!propertyName.equals(propertyDescriptor.getName())) continue;
                String propertyType = propertyDescriptor.getPropertyType().getName();
                Object value = this.getValue(innerBean, beanProperty, propertyType, bundle);
                Method m = propertyDescriptor.getWriteMethod();
                try {
                    m.invoke(instance, value);
                    continue block14;
                }
                catch (Exception e) {
                    throw new DeploymentException("Could not set property value for property named " + propertyName, (Throwable)e);
                }
            }
        }
        return instance;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(JavaBeanXmlAttributeBuilder.class, (String)"XmlAttributeBuilder");
        infoBuilder.addInterface(XmlAttributeBuilder.class);
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

