/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.security.auth.login.FailedLoginException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.geronimo.crypto.encoders.Base64;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.FileWriteMonitor;
import org.apache.geronimo.kernel.repository.Version;
import org.apache.geronimo.kernel.repository.WriteableRepository;
import org.apache.geronimo.kernel.util.XmlUtil;
import org.apache.geronimo.system.plugin.OpenResult;
import org.apache.geronimo.system.plugin.SnapshotVersion;
import org.apache.geronimo.system.plugin.SourceRepository;
import org.apache.geronimo.system.plugin.model.PluginListType;
import org.apache.geronimo.system.plugin.model.PluginXmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RemoteSourceRepository
implements SourceRepository {
    private final URI base;
    private final String username;
    private final String password;

    public RemoteSourceRepository(URI base, String username, String password) {
        if (!base.getPath().endsWith("/")) {
            throw new IllegalArgumentException("base uri must end with '/', not " + base);
        }
        this.base = base;
        this.username = username;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PluginListType getPluginList() {
        block5: {
            PluginListType pluginListType;
            URL uri = this.base.resolve("geronimo-plugins.xml").toURL();
            InputStream in = this.openStream(uri);
            if (in == null) break block5;
            try {
                pluginListType = PluginXmlUtil.loadPluginList((InputStream)in);
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            in.close();
            return pluginListType;
        }
        return null;
    }

    @Override
    public OpenResult open(Artifact artifact, FileWriteMonitor monitor) throws IOException, FailedLoginException {
        if (artifact.isResolved()) {
            NodeList snapshots;
            URI basePath;
            Document metadata;
            URL location = this.getURL(artifact);
            OpenResult result = this.open(artifact, location);
            if (result != null) {
                return result;
            }
            Version version = artifact.getVersion();
            if (version.toString().indexOf("SNAPSHOT") >= 0 && !(version instanceof SnapshotVersion) && (metadata = this.getMavenMetadata(basePath = this.base.resolve(artifact.getGroupId().replace('.', '/') + "/" + artifact.getArtifactId() + "/" + version + "/"))) != null && (snapshots = metadata.getDocumentElement().getElementsByTagName("snapshot")).getLength() >= 1) {
                Element snapshot = (Element)snapshots.item(0);
                List<String> timestamp = RemoteSourceRepository.getChildrenText(snapshot, "timestamp");
                List<String> buildNumber = RemoteSourceRepository.getChildrenText(snapshot, "buildNumber");
                if (timestamp.size() >= 1 && buildNumber.size() >= 1) {
                    try {
                        SnapshotVersion snapshotVersion = new SnapshotVersion(version);
                        snapshotVersion.setBuildNumber(Integer.parseInt(buildNumber.get(0)));
                        snapshotVersion.setTimestamp(timestamp.get(0));
                        Artifact newQuery = new Artifact(artifact.getGroupId(), artifact.getArtifactId(), (Version)snapshotVersion, artifact.getType());
                        location = this.getURL(newQuery);
                        return this.open(artifact, location);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
            }
            return null;
        }
        URI basePath = this.base.resolve(artifact.getGroupId().replace('.', '/') + "/" + artifact.getArtifactId() + "/");
        Document metadata = this.getMavenMetadata(basePath);
        if (metadata != null) {
            Element root = metadata.getDocumentElement();
            NodeList list = root.getElementsByTagName("versions");
            list = ((Element)list.item(0)).getElementsByTagName("version");
            Version[] available = new Version[list.getLength()];
            for (int i = 0; i < available.length; ++i) {
                available[i] = new Version(RemoteSourceRepository.getText(list.item(i)));
            }
            Arrays.sort(available, new Comparator<Version>(){

                @Override
                public int compare(Version o1, Version o2) {
                    return o2.toString().compareTo(o1.toString());
                }
            });
            for (Version version : available) {
                URL location;
                Artifact versionedArtifact = new Artifact(artifact.getGroupId(), artifact.getArtifactId(), version, artifact.getType());
                OpenResult result = this.open(versionedArtifact, location = this.getURL(versionedArtifact));
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private OpenResult open(Artifact artifact, URL location) throws IOException, FailedLoginException {
        InputStream in = this.openStream(location);
        return in == null ? null : new RemoteOpenResult(artifact, in);
    }

    private InputStream openStream(URL location) throws IOException, FailedLoginException {
        URLConnection con = location.openConnection();
        if (con instanceof HttpURLConnection) {
            HttpURLConnection http = (HttpURLConnection)con;
            try {
                http.connect();
            }
            catch (IOException e) {
                throw (IOException)new IOException("Cannot connect to " + location).initCause(e);
            }
            if (http.getResponseCode() == 401) {
                if (this.username == null || this.username.equals("")) {
                    throw new FailedLoginException("Server returned 401 " + http.getResponseMessage());
                }
                http = (HttpURLConnection)location.openConnection();
                http.setRequestProperty("Authorization", "Basic " + new String(Base64.encode((byte[])(this.username + ":" + this.password).getBytes())));
                http.connect();
                if (http.getResponseCode() == 401) {
                    throw new FailedLoginException("Server returned 401 " + http.getResponseMessage());
                }
                if (http.getResponseCode() == 404) {
                    return null;
                }
            } else if (http.getResponseCode() == 404) {
                return null;
            }
            return http.getInputStream();
        }
        return null;
    }

    private Document getMavenMetadata(URI base) throws IOException, FailedLoginException {
        Document doc = null;
        InputStream in = null;
        try {
            URL metaURL = base.resolve("maven-metadata.xml").toURL();
            in = this.openStream(metaURL);
            if (in == null) {
                metaURL = base.resolve("maven-metadata-local.xml").toURL();
                in = this.openStream(metaURL);
            }
            if (in != null) {
                DocumentBuilder builder = XmlUtil.newDocumentBuilderFactory().newDocumentBuilder();
                doc = builder.parse(in);
            }
        }
        catch (ParserConfigurationException e) {
            throw (IOException)new IOException().initCause(e);
        }
        catch (SAXException e) {
            throw (IOException)new IOException().initCause(e);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return doc;
    }

    private URL getURL(Artifact configId) throws MalformedURLException {
        String qualifiedVersion = configId.getVersion().toString();
        if (configId.getVersion() instanceof SnapshotVersion) {
            SnapshotVersion ssVersion = (SnapshotVersion)configId.getVersion();
            String timestamp = ssVersion.getTimestamp();
            int buildNumber = ssVersion.getBuildNumber();
            if (timestamp != null && buildNumber != 0) {
                qualifiedVersion = qualifiedVersion.replaceAll("SNAPSHOT", timestamp + "-" + buildNumber);
            }
        }
        return this.base.resolve(configId.getGroupId().replace('.', '/') + "/" + configId.getArtifactId() + "/" + configId.getVersion() + "/" + configId.getArtifactId() + "-" + qualifiedVersion + "." + configId.getType()).toURL();
    }

    private static String getText(Node target) {
        NodeList nodes = target.getChildNodes();
        StringBuilder buf = null;
        for (int j = 0; j < nodes.getLength(); ++j) {
            Node node = nodes.item(j);
            if (node.getNodeType() != 3) continue;
            if (buf == null) {
                buf = new StringBuilder();
            }
            buf.append(node.getNodeValue());
        }
        return buf == null ? null : buf.toString();
    }

    private static List<String> getChildrenText(Element root, String property) {
        NodeList children = root.getChildNodes();
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node check = children.item(i);
            if (check.getNodeType() != 1 || !check.getNodeName().equals(property)) continue;
            NodeList nodes = check.getChildNodes();
            StringBuilder buf = null;
            for (int j = 0; j < nodes.getLength(); ++j) {
                Node node = nodes.item(j);
                if (node.getNodeType() != 3) continue;
                if (buf == null) {
                    buf = new StringBuilder();
                }
                buf.append(node.getNodeValue());
            }
            results.add(buf == null ? null : buf.toString());
        }
        return results;
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.base;
    }

    private static class RemoteOpenResult
    implements OpenResult {
        private final Artifact artifact;
        private final InputStream in;
        private File file;

        private RemoteOpenResult(Artifact artifact, InputStream in) {
            if (!artifact.isResolved()) {
                throw new IllegalStateException("Artifact is not resolved: " + artifact);
            }
            this.artifact = artifact;
            this.in = in;
        }

        @Override
        public Artifact getArtifact() {
            return this.artifact;
        }

        @Override
        public File getFile() throws IOException {
            if (this.file == null) {
                this.file = this.downloadFile(this.in);
            }
            return this.file;
        }

        @Override
        public void install(WriteableRepository repo, FileWriteMonitor monitor) throws IOException {
            File file = this.getFile();
            repo.copyToRepository(file, this.artifact, monitor);
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }

        @Override
        public void close() {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File downloadFile(InputStream in) throws IOException {
            if (in == null) {
                throw new IllegalStateException();
            }
            FileOutputStream out = null;
            try {
                int count;
                File file = File.createTempFile("geronimo-plugin-download-", ".tmp");
                out = new FileOutputStream(file);
                byte[] buf = new byte[65536];
                boolean total = false;
                while ((count = in.read(buf)) > -1) {
                    out.write(buf, 0, count);
                }
                in.close();
                in = null;
                out.close();
                out = null;
                File file2 = file;
                return file2;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ignored) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
    }
}

