/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.plugin;

import java.io.IOException;
import java.util.Map;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.repository.ArtifactManager;
import org.apache.geronimo.kernel.repository.ListableRepository;
import org.apache.geronimo.system.configuration.LocalPluginAttributeStore;
import org.apache.geronimo.system.configuration.PluginAttributeStore;
import org.apache.geronimo.system.plugin.ServerInstance;
import org.apache.geronimo.system.plugin.ServerInstanceData;
import org.apache.geronimo.system.resolver.AliasedArtifactResolver;
import org.apache.geronimo.system.resolver.LocalAliasedArtifactResolver;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class ReferenceServerInstanceData
extends ServerInstanceData {
    private final LocalPluginAttributeStore attributeStore;
    private final LocalAliasedArtifactResolver artifactResolver;
    public static final GBeanInfo GBEAN_INFO;

    public ReferenceServerInstanceData() {
        this.attributeStore = null;
        this.artifactResolver = null;
    }

    public ReferenceServerInstanceData(LocalPluginAttributeStore attributeStore, LocalAliasedArtifactResolver artifactResolver) {
        this.attributeStore = attributeStore;
        this.artifactResolver = artifactResolver;
    }

    @Override
    public String getConfigFile() {
        return this.attributeStore.getConfigFile();
    }

    @Override
    public String getConfigSubstitutionsFile() {
        return this.attributeStore.getConfigSubstitutionsFile();
    }

    @Override
    public String getConfigSubstitutionsPrefix() {
        return this.attributeStore.getConfigSubstitutionsPrefix();
    }

    @Override
    public String getArtifactAliasesFile() {
        return this.artifactResolver.getArtifactAliasesFile();
    }

    @Override
    public ServerInstance getServerInstance(ArtifactManager artifactManager, ListableRepository targetRepo, ServerInfo serverInfo, Map<String, ServerInstance> serverInstances, boolean live) throws IOException {
        if (live) {
            return new ServerInstance(this.getName(), (PluginAttributeStore)this.attributeStore, (AliasedArtifactResolver)this.artifactResolver);
        }
        return super.getServerInstance(artifactManager, targetRepo, serverInfo, serverInstances, live);
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ReferenceServerInstanceData:\n");
        buf.append("  Name: ").append(this.getName()).append("\n");
        buf.append("  ConfigFile: ").append(this.getConfigFile()).append("\n");
        buf.append("  ConfigSubstitutionsFile: ").append(this.getConfigSubstitutionsFile()).append("\n");
        buf.append("  ConfigSubstitutionsPrefix: ").append(this.getConfigSubstitutionsPrefix()).append("\n");
        buf.append("  ArtifactAliasesFile: ").append(this.getArtifactAliasesFile()).append("\n");
        return buf.toString();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(ReferenceServerInstanceData.class, (String)"ServerInstanceData");
        infoFactory.addAttribute("name", String.class, true, true);
        infoFactory.addReference("AttributeStore", LocalPluginAttributeStore.class, "AttributeStore");
        infoFactory.addReference("ArtifactResolver", LocalAliasedArtifactResolver.class, "ArtifactResolver");
        infoFactory.setConstructor(new String[]{"AttributeStore", "ArtifactResolver"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

