/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.geronimo.crypto.EncryptionManager;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.system.plugin.LocalSourceRepository;
import org.apache.geronimo.system.plugin.PluginRepositoryList;
import org.apache.geronimo.system.plugin.RemoteSourceRepository;
import org.apache.geronimo.system.plugin.SourceRepository;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GBean
public class PluginRepositoryDownloader
implements PluginRepositoryList {
    private static final Logger log = LoggerFactory.getLogger(PluginRepositoryDownloader.class);
    private List<String> downloadRepositories = new ArrayList<String>();
    private Map<String, String[]> userRepositories = new HashMap<String, String[]>();
    private final File userRepositoryList;
    private final boolean restrictToKnownRepositories;
    private final Kernel kernel;
    private final AbstractName name;
    private final URL repositoryList;
    private static final String COMMENT = "List of known plugin repositories. Fomat:  <url>=<username>=<password>";

    public PluginRepositoryDownloader(@ParamAttribute(name="downloadRepositories") List<String> downloadRepositories, @ParamAttribute(name="userRepositoryList") String userRepositoryList, @ParamAttribute(name="repositoryList") URL repositoryList, @ParamAttribute(name="restrictToKnownRepositories") boolean restrictToKnownRepositories, @ParamReference(name="ServerInfo") ServerInfo serverInfo, @ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel, @ParamSpecial(type=SpecialAttributeType.abstractName) AbstractName name) {
        if (downloadRepositories != null) {
            this.downloadRepositories = downloadRepositories;
        }
        this.repositoryList = repositoryList;
        this.userRepositoryList = serverInfo.resolveServer(userRepositoryList);
        this.restrictToKnownRepositories = restrictToKnownRepositories;
        this.kernel = kernel;
        this.name = name;
        this.loadUserRepositories();
    }

    public PluginRepositoryDownloader(Map<String, String[]> userRepositories, boolean restrictToKnownRepositories) {
        this.userRepositories.putAll(userRepositories);
        this.restrictToKnownRepositories = restrictToKnownRepositories;
        this.userRepositoryList = null;
        this.kernel = null;
        this.name = null;
        this.repositoryList = null;
    }

    public void setDownloadRepositories(List<String> downloadRepositories) {
        this.downloadRepositories = downloadRepositories;
        if (this.downloadRepositories == null) {
            this.downloadRepositories = new ArrayList<String>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadUserRepositories() {
        this.userRepositories.clear();
        Properties properties = new Properties();
        boolean modified = false;
        try {
            FileInputStream in = new FileInputStream(this.userRepositoryList);
            try {
                properties.load(in);
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String url = (String)entry.getKey();
                    if (!url.endsWith("/")) {
                        url = url + "/";
                        modified = true;
                    }
                    String rawCreds = (String)entry.getValue();
                    String[] creds = null;
                    if (rawCreds.length() > 0) {
                        creds = rawCreds.split("=");
                        if (creds.length != 2) continue;
                        String password = creds[1];
                        creds[1] = (String)((Object)EncryptionManager.decrypt((String)password));
                        if (password.equals(creds[1])) {
                            modified = true;
                        }
                    }
                    this.userRepositories.put(url, creds);
                }
            }
            finally {
                ((InputStream)in).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (modified) {
            this.saveUserRepositories();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void saveUserRepositories() {
        Properties properties = new Properties();
        for (Map.Entry<String, String[]> entry : this.userRepositories.entrySet()) {
            String url = entry.getKey();
            String[] creds = entry.getValue();
            if (creds == null || creds.length != 2) {
                properties.setProperty(url, "");
                continue;
            }
            properties.setProperty(url, creds[0] + "=" + EncryptionManager.encrypt((Serializable)((Object)creds[1])));
        }
        try {
            FileOutputStream out = new FileOutputStream(this.userRepositoryList);
            try {
                properties.store(out, COMMENT);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public List<URL> getRepositories() {
        ArrayList<URL> list = new ArrayList<URL>();
        if (!this.restrictToKnownRepositories) {
            for (String url : this.downloadRepositories) {
                if (!(url = url.trim()).endsWith("/")) {
                    url = url + "/";
                }
                try {
                    list.add(new URL(url));
                }
                catch (MalformedURLException e) {
                    log.error("Unable to format plugin repository URL " + url, (Throwable)e);
                }
            }
        }
        for (String userRepository : this.userRepositories.keySet()) {
            userRepository = userRepository.trim();
            URL url = null;
            try {
                url = this.resolveRepository(userRepository).toURL();
            }
            catch (MalformedURLException e) {
                log.error("Unable to format plugin repository URL " + userRepository, (Throwable)e);
            }
            if (url == null) continue;
            list.add(url);
        }
        return list;
    }

    @Override
    public SourceRepository getSourceRepository(String repo) {
        String scheme;
        if (repo == null) {
            throw new IllegalArgumentException("No repo supplied");
        }
        URI repoURI = this.resolveRepository(repo);
        if (repoURI == null) {
            throw new IllegalStateException("Can't locate repo " + repo);
        }
        if (!repo.endsWith("/")) {
            repo = repo + "/";
        }
        if ((scheme = repoURI.getScheme()).startsWith("http")) {
            String[] creds = this.userRepositories.get(repo);
            if (creds == null) {
                return new RemoteSourceRepository(repoURI, null, null);
            }
            return new RemoteSourceRepository(repoURI, creds[0], creds[1]);
        }
        if ("file".equals(scheme)) {
            return new LocalSourceRepository(new File(repoURI));
        }
        throw new IllegalStateException("Cannot identify desired repo type for " + repo);
    }

    private URI resolveRepository(String userRepository) {
        if (!userRepository.endsWith("/")) {
            userRepository = userRepository + "/";
        }
        if (this.restrictToKnownRepositories && !this.userRepositories.containsKey(userRepository)) {
            return null;
        }
        try {
            userRepository = userRepository.replaceAll(" ", "%20");
            URI uri = new URI(userRepository);
            if (!uri.isAbsolute()) {
                if (userRepository.startsWith("/")) {
                    return new URI("file", userRepository, null);
                }
                if (userRepository.startsWith("~")) {
                    return new File(System.getProperty("user.home")).getAbsoluteFile().toURI().resolve(userRepository.substring(2));
                }
            } else {
                return uri;
            }
            log.error("Can't interpret path: " + userRepository);
        }
        catch (URISyntaxException e) {
            log.error("Unable to format plugin repository URL " + userRepository, (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(this.repositoryList.openStream()));
            ArrayList<String> list = new ArrayList<String>();
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).equals("") || line.startsWith("#")) continue;
                list.add(line);
            }
            in.close();
            in = null;
            this.kernel.setAttribute(this.name, "downloadRepositories", list);
        }
        catch (Exception e) {
            log.error("Unable to save download repositories", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public synchronized void addUserRepository(URL repo, String userName, String password) {
        String[] stringArray;
        String string = repo.toString();
        if (userName == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = userName;
            stringArray = stringArray2;
            stringArray2[1] = password;
        }
        this.userRepositories.put(string, stringArray);
        this.saveUserRepositories();
    }
}

