/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.ReferenceCollection;
import org.apache.geronimo.gbean.ReferenceCollectionEvent;
import org.apache.geronimo.gbean.ReferenceCollectionListener;
import org.apache.geronimo.gbean.runtime.AbstractGBeanReference;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProxyCollection
implements ReferenceCollection {
    private static final Logger log = LoggerFactory.getLogger(ProxyCollection.class);
    private final String name;
    private final Kernel kernel;
    private final Map proxies = new HashMap();
    private final Set listeners = new HashSet();
    private boolean stopped = false;
    private final Class type;

    public ProxyCollection(String name, Class type, Set targets, Kernel kernel) {
        this.name = name;
        this.kernel = kernel;
        this.type = type;
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            this.addTarget((AbstractName)iterator.next());
        }
    }

    synchronized void destroy() {
        this.stopped = true;
        if (!AbstractGBeanReference.NO_PROXY) {
            Iterator iterator = this.proxies.values().iterator();
            while (iterator.hasNext()) {
                this.kernel.getProxyManager().destroyProxy(iterator.next());
            }
        }
        this.proxies.clear();
        this.listeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTarget(AbstractName target) {
        ArrayList listenerCopy;
        Object proxy;
        ProxyCollection proxyCollection = this;
        synchronized (proxyCollection) {
            if (this.proxies.containsKey(target)) {
                return;
            }
            if (AbstractGBeanReference.NO_PROXY) {
                try {
                    proxy = this.kernel.getGBean(target);
                }
                catch (GBeanNotFoundException e) {
                    log.debug("GBean was unloaded before it could be added to reference collections: " + target);
                    return;
                }
            } else {
                proxy = this.kernel.getProxyManager().createProxy(target, this.type);
            }
            this.proxies.put(target, proxy);
            listenerCopy = new ArrayList(this.listeners);
        }
        for (ReferenceCollectionListener listener : listenerCopy) {
            try {
                listener.memberAdded(new ReferenceCollectionEvent(this.name, proxy));
            }
            catch (Throwable t) {
                log.error("Listener threw exception", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTarget(AbstractName target) {
        ArrayList listenerCopy;
        Object proxy;
        ProxyCollection proxyCollection = this;
        synchronized (proxyCollection) {
            proxy = this.proxies.remove(target);
            if (proxy == null) {
                return;
            }
            listenerCopy = new ArrayList(this.listeners);
        }
        for (ReferenceCollectionListener listener : listenerCopy) {
            try {
                listener.memberRemoved(new ReferenceCollectionEvent(this.name, proxy));
            }
            catch (Throwable t) {
                log.error("Listener threw exception", t);
            }
        }
        if (!AbstractGBeanReference.NO_PROXY) {
            this.kernel.getProxyManager().destroyProxy(proxy);
        }
    }

    public synchronized ObjectName[] getMemberObjectNames() {
        return this.proxies.keySet().toArray(new ObjectName[0]);
    }

    public synchronized boolean isStopped() {
        return this.stopped;
    }

    public synchronized void addReferenceCollectionListener(ReferenceCollectionListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeReferenceCollectionListener(ReferenceCollectionListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized int size() {
        if (this.stopped) {
            return 0;
        }
        return this.proxies.size();
    }

    public synchronized boolean isEmpty() {
        if (this.stopped) {
            return true;
        }
        return this.proxies.isEmpty();
    }

    public synchronized boolean contains(Object o) {
        if (this.stopped) {
            return false;
        }
        return this.proxies.containsValue(o);
    }

    public synchronized Iterator iterator() {
        if (this.stopped) {
            return new Iterator(){

                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator(){
            private final Iterator iterator;
            {
                this.iterator = new ArrayList(ProxyCollection.this.proxies.values()).iterator();
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            public Object next() {
                return this.iterator.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public synchronized Object[] toArray() {
        if (this.stopped) {
            return new Object[0];
        }
        return this.proxies.values().toArray();
    }

    public synchronized Object[] toArray(Object[] a) {
        if (this.stopped) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        return this.proxies.values().toArray(a);
    }

    public synchronized boolean containsAll(Collection c) {
        if (this.stopped) {
            return c.isEmpty();
        }
        return this.proxies.values().containsAll(c);
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }
}

