/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jmxremoting;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.NotificationFilterSupport;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.jmxremoting.Authenticator;
import org.apache.geronimo.jmxremoting.JMXConnectorInfo;
import org.apache.geronimo.kernel.rmi.GeronimoRMIServerSocketFactory;
import org.apache.geronimo.system.jmx.MBeanServerReference;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXConnector
implements JMXConnectorInfo,
GBeanLifecycle {
    protected final MBeanServer mbeanServer;
    protected final Logger log;
    protected final ClassLoader classLoader;
    protected String applicationConfigName;
    protected String protocol;
    protected String host;
    protected int port = -1;
    protected String urlPath;
    protected JMXConnectorServer server;
    protected JMXServiceURL jmxServiceURL;
    protected ServerInfo serverInfo;
    public static final GBeanInfo GBEAN_INFO;

    public JMXConnector(MBeanServerReference mbeanServerReference, ServerInfo serverInfo, String objectName, ClassLoader classLoader) {
        this(mbeanServerReference.getMBeanServer(), serverInfo, objectName, classLoader);
    }

    public JMXConnector(MBeanServer mbeanServer, ServerInfo serverInfo, String objectName, ClassLoader classLoader) {
        this.mbeanServer = mbeanServer;
        this.serverInfo = serverInfo;
        this.classLoader = classLoader;
        this.log = LoggerFactory.getLogger((String)objectName);
    }

    public String getApplicationConfigName() {
        return this.applicationConfigName;
    }

    public void setApplicationConfigName(String applicationConfigName) {
        this.applicationConfigName = applicationConfigName;
    }

    @Override
    public InetSocketAddress getListenAddress() {
        return new InetSocketAddress(this.getHost(), this.getPort());
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public String getUrlPath() {
        return this.urlPath;
    }

    @Override
    public void setUrlPath(String urlPath) {
        this.urlPath = urlPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() throws Exception {
        this.jmxServiceURL = new JMXServiceURL(this.protocol, this.host, this.port, this.urlPath);
        Authenticator authenticator = null;
        HashMap<String, Object> env = new HashMap<String, Object>();
        if (this.applicationConfigName != null) {
            authenticator = new Authenticator(this.applicationConfigName, this.classLoader);
            String accessconfig = this.serverInfo.resolveServerPath("var/security/jmx_access.properties");
            env.put("jmx.remote.x.access.file", accessconfig);
            env.put("jmx.remote.authenticator", authenticator);
        } else {
            this.log.warn("Starting unauthenticating JMXConnector for " + this.jmxServiceURL);
        }
        GeronimoRMIServerSocketFactory serverSocketFactory = new GeronimoRMIServerSocketFactory(this.host);
        env.put("jmx.remote.rmi.server.socket.factory", serverSocketFactory);
        this.server = JMXConnectorServerFactory.newJMXConnectorServer(this.jmxServiceURL, env, this.mbeanServer);
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType("jmx.remote.connection.opened");
        filter.enableType("jmx.remote.connection.closed");
        filter.enableType("jmx.remote.connection.failed");
        this.server.addNotificationListener(authenticator, filter, null);
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            this.server.start();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
        this.log.debug("Started JMXConnector " + this.server.getAddress());
    }

    public void doStop() throws Exception {
        try {
            this.server.stop();
        }
        catch (IOException e) {
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.server = null;
            this.log.debug("Stopped JMXConnector " + this.jmxServiceURL);
        }
    }

    public void doFail() {
        try {
            this.doStop();
            this.log.warn("Failure in JMXConnector " + this.jmxServiceURL);
        }
        catch (Exception e) {
            this.log.warn("Error stopping JMXConnector after failure", (Throwable)e);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"JMX Remoting Connector", JMXConnector.class);
        infoFactory.addReference("MBeanServerReference", MBeanServerReference.class);
        infoFactory.addReference("ServerInfo", ServerInfo.class);
        infoFactory.addAttribute("objectName", String.class, false);
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.addAttribute("protocol", String.class, true, true);
        infoFactory.addAttribute("host", String.class, true, true);
        infoFactory.addAttribute("port", Integer.TYPE, true, true);
        infoFactory.addAttribute("urlPath", String.class, true, true);
        infoFactory.addAttribute("applicationConfigName", String.class, true, true);
        infoFactory.addInterface(JMXConnectorInfo.class);
        infoFactory.setConstructor(new String[]{"MBeanServerReference", "ServerInfo", "objectName", "classLoader"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

