/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jmxremoting;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectionNotification;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.geronimo.jmxremoting.Credentials;

public class Authenticator
implements JMXAuthenticator,
NotificationListener {
    private final String configName;
    private final ClassLoader cl;
    private ThreadLocal<LoginContext> threadContext = new ThreadLocal();
    private Map<String, LoginContext> contextMap = Collections.synchronizedMap(new HashMap());

    public Authenticator(String configName, ClassLoader cl) {
        this.configName = configName;
        this.cl = cl;
    }

    public Subject authenticate(Object o) throws SecurityException {
        if (!(o instanceof String[])) {
            throw new IllegalArgumentException("Expected String[2], got " + (o == null ? null : o.getClass().getName()));
        }
        String[] params = (String[])o;
        if (params.length != 2) {
            throw new IllegalArgumentException("Expected String[2] but length was " + params.length);
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldCL = thread.getContextClassLoader();
        Credentials credentials = new Credentials(params[0], params[1]);
        try {
            thread.setContextClassLoader(this.cl);
            LoginContext context = new LoginContext(this.configName, credentials);
            context.login();
            this.threadContext.set(context);
            Subject subject = context.getSubject();
            return subject;
        }
        catch (LoginException e) {
            throw new SecurityException("Invalid login");
        }
        finally {
            credentials.clear();
            thread.setContextClassLoader(oldCL);
        }
    }

    public void handleNotification(Notification notification, Object o) {
        if (notification instanceof JMXConnectionNotification) {
            JMXConnectionNotification cxNotification = (JMXConnectionNotification)notification;
            String type = cxNotification.getType();
            String connectionId = cxNotification.getConnectionId();
            if ("jmx.remote.connection.opened".equals(type)) {
                LoginContext context = this.threadContext.get();
                this.threadContext.set(null);
                this.contextMap.put(connectionId, context);
            } else {
                LoginContext context = this.contextMap.remove(connectionId);
                if (context != null) {
                    try {
                        context.logout();
                    }
                    catch (LoginException e) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

