/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.ResourceContext;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.deployment.util.NestedJarFile;
import org.apache.geronimo.kernel.config.Configuration;

class InPlaceResourceContext
implements ResourceContext {
    private static final String PACKED_MODULED_SAVED_SUFFIX = ".saved";
    private final Configuration configuration;
    private final URI inPlaceBaseConfigurationUri;
    private final Set zipFilesToExpand = new HashSet();

    public InPlaceResourceContext(Configuration configuration, File inPlaceBaseConfigurationDir) throws DeploymentException {
        this.configuration = configuration;
        this.inPlaceBaseConfigurationUri = inPlaceBaseConfigurationDir.toURI();
        if (inPlaceBaseConfigurationDir.isFile()) {
            try {
                configuration.addToClassPath("");
            }
            catch (IOException e) {
                throw new DeploymentException((Throwable)e);
            }
        }
    }

    public void addIncludeAsPackedJar(URI targetPath, JarFile jarFile) throws IOException {
        this.configuration.addToClassPath(targetPath.toString());
    }

    public void addInclude(URI targetPath, ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        NestedJarFile nestedJarFile;
        if (zipFile instanceof NestedJarFile && (nestedJarFile = (NestedJarFile)zipFile).isPacked()) {
            this.zipFilesToExpand.add(zipFile);
        }
        this.configuration.addToClassPath(targetPath.toString());
    }

    public void addInclude(URI targetPath, URL source) throws IOException {
        this.configuration.addToClassPath(targetPath.toString());
    }

    public void addInclude(URI targetPath, File source) throws IOException {
        this.configuration.addToClassPath(targetPath.toString());
    }

    public void addFile(URI targetPath, ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        NestedJarFile nestedJarFile;
        if (zipFile instanceof NestedJarFile && (nestedJarFile = (NestedJarFile)zipFile).isPacked()) {
            this.zipFilesToExpand.add(zipFile);
        }
    }

    public void addFile(URI targetPath, URL source) throws IOException {
    }

    public void addFile(URI targetPath, File source) throws IOException {
    }

    public void addFile(URI targetPath, String source) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(URI targetPath, byte[] contents) throws IOException {
        File file = this.getTargetFile(targetPath);
        if (!file.getParentFile().mkdirs()) {
            throw new IOException("Could not create parent directory for entry: " + targetPath + " at " + file.getParentFile());
        }
        FileOutputStream out = new FileOutputStream(file);
        try {
            out.write(contents);
        }
        finally {
            DeploymentUtil.close(out);
        }
    }

    public File getTargetFile(URI targetPath) {
        if (targetPath == null) {
            throw new NullPointerException("targetPath is null");
        }
        if (targetPath.isAbsolute()) {
            throw new IllegalArgumentException("targetPath is absolute");
        }
        if (targetPath.isOpaque()) {
            throw new IllegalArgumentException("targetPath is opaque");
        }
        return new File(this.inPlaceBaseConfigurationUri.resolve(targetPath));
    }

    public void flush() throws IOException {
        for (ZipFile zipFile : this.zipFilesToExpand) {
            File targetFile;
            String name = zipFile.getName();
            zipFile.close();
            File srcFile = new File(name);
            if (!srcFile.isAbsolute()) {
                srcFile = new File(this.inPlaceBaseConfigurationUri.resolve(name));
                try {
                    targetFile = this.getTargetFile(new URI(name + PACKED_MODULED_SAVED_SUFFIX));
                }
                catch (URISyntaxException e) {
                    throw new AssertionError((Object)e);
                }
            } else {
                targetFile = new File(name + PACKED_MODULED_SAVED_SUFFIX);
            }
            boolean success = new File(name).renameTo(targetFile);
            if (!success) {
                throw new IOException("Cannot rename file " + name + " to " + targetFile.getAbsolutePath());
            }
            DeploymentUtil.unzipToDirectory(new ZipFile(targetFile), srcFile);
        }
    }
}

