/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.ClassPathList;
import org.apache.geronimo.deployment.CopyResourceContext;
import org.apache.geronimo.deployment.DeploymentConfigurationManager;
import org.apache.geronimo.deployment.InPlaceResourceContext;
import org.apache.geronimo.deployment.ModuleList;
import org.apache.geronimo.deployment.ResourceContext;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Environment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentContext {
    private static final Log log = LogFactory.getLog(DeploymentContext.class);
    private final File baseDir;
    private final File inPlaceConfigurationDir;
    private final ResourceContext resourceContext;
    private final Map<String, ConfigurationData> childConfigurationDatas = new LinkedHashMap<String, ConfigurationData>();
    private final ConfigurationManager configurationManager;
    private final Configuration configuration;
    private final Naming naming;
    private final List<ConfigurationData> additionalDeployment = new ArrayList<ConfigurationData>();
    protected final AbstractName moduleName;
    private static final int manifestClassLoaderMode;
    private static final String manifestClassLoaderMessage;
    private static final int MFCP_LENIENT = 1;
    private static final int MFCP_STRICT = 2;

    public DeploymentContext(File baseDir, File inPlaceConfigurationDir, Environment environment, AbstractName moduleName, ConfigurationModuleType moduleType, Naming naming, ConfigurationManager configurationManager, Collection repositories) throws DeploymentException {
        this(baseDir, inPlaceConfigurationDir, environment, moduleName, moduleType, naming, DeploymentContext.createConfigurationManager(configurationManager, repositories));
    }

    public DeploymentContext(File baseDir, File inPlaceConfigurationDir, Environment environment, AbstractName moduleName, ConfigurationModuleType moduleType, Naming naming, ConfigurationManager configurationManager) throws DeploymentException {
        if (baseDir == null) {
            throw new NullPointerException("baseDir is null");
        }
        if (environment == null) {
            throw new NullPointerException("environment is null");
        }
        if (moduleType == null) {
            throw new NullPointerException("type is null");
        }
        if (configurationManager == null) {
            throw new NullPointerException("configurationManager is null");
        }
        if (!baseDir.exists()) {
            baseDir.mkdirs();
        }
        this.baseDir = baseDir;
        this.inPlaceConfigurationDir = inPlaceConfigurationDir;
        this.moduleName = moduleName;
        this.naming = naming;
        this.configuration = DeploymentContext.createTempConfiguration(environment, moduleType, baseDir, inPlaceConfigurationDir, configurationManager, naming);
        this.configurationManager = configurationManager;
        this.resourceContext = null == inPlaceConfigurationDir ? new CopyResourceContext(this.configuration, baseDir) : new InPlaceResourceContext(this.configuration, inPlaceConfigurationDir);
    }

    private static ConfigurationManager createConfigurationManager(ConfigurationManager configurationManager, Collection repositories) {
        return new DeploymentConfigurationManager(configurationManager, repositories);
    }

    private static Configuration createTempConfiguration(Environment environment, ConfigurationModuleType moduleType, File baseDir, File inPlaceConfigurationDir, ConfigurationManager configurationManager, Naming naming) throws DeploymentException {
        try {
            configurationManager.loadConfiguration(new ConfigurationData(moduleType, null, null, null, environment, baseDir, inPlaceConfigurationDir, naming));
            return configurationManager.getConfiguration(environment.getConfigId());
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to create configuration for deployment", (Throwable)e);
        }
    }

    public ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public Artifact getConfigID() {
        return this.configuration.getId();
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public File getInPlaceConfigurationDir() {
        return this.inPlaceConfigurationDir;
    }

    public Naming getNaming() {
        return this.naming;
    }

    public GBeanData addGBean(String name, GBeanInfo gbeanInfo) throws GBeanAlreadyExistsException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (gbeanInfo == null) {
            throw new NullPointerException("gbean is null");
        }
        GBeanData gbean = new GBeanData(gbeanInfo);
        this.configuration.addGBean(name, gbean);
        return gbean;
    }

    public void addGBean(GBeanData gbean) throws GBeanAlreadyExistsException {
        if (gbean == null) {
            throw new NullPointerException("gbean is null");
        }
        if (gbean.getAbstractName() == null) {
            throw new NullPointerException("gbean.getAbstractName() is null");
        }
        this.configuration.addGBean(gbean);
    }

    public void removeGBean(AbstractName name) throws GBeanNotFoundException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.configuration.removeGBean(name);
    }

    public Set<AbstractName> getGBeanNames() {
        return new HashSet<AbstractName>(this.configuration.getGBeans().keySet());
    }

    public Set<AbstractName> listGBeans(AbstractNameQuery pattern) {
        return this.findGBeans(pattern);
    }

    public AbstractName findGBean(AbstractNameQuery pattern) throws GBeanNotFoundException {
        return this.configuration.findGBean(pattern);
    }

    public AbstractName findGBean(Set<AbstractNameQuery> patterns) throws GBeanNotFoundException {
        return this.configuration.findGBean(patterns);
    }

    public LinkedHashSet<AbstractName> findGBeans(AbstractNameQuery pattern) {
        return this.configuration.findGBeans(pattern);
    }

    public LinkedHashSet<GBeanData> findGBeanDatas(Configuration configuration, AbstractNameQuery pattern) {
        return configuration.findGBeanDatas(configuration, Collections.singleton(pattern));
    }

    public LinkedHashSet<AbstractName> findGBeans(Set<AbstractNameQuery> patterns) {
        return this.configuration.findGBeans(patterns);
    }

    public GBeanData getGBeanInstance(AbstractName name) throws GBeanNotFoundException {
        Map gbeans = this.configuration.getGBeans();
        GBeanData gbeanData = (GBeanData)gbeans.get(name);
        if (gbeanData == null) {
            throw new GBeanNotFoundException(name);
        }
        return gbeanData;
    }

    public void addIncludeAsPackedJar(URI targetPath, JarFile jarFile) throws IOException {
        this.resourceContext.addIncludeAsPackedJar(targetPath, jarFile);
    }

    public void addInclude(URI targetPath, ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        this.resourceContext.addInclude(targetPath, zipFile, zipEntry);
    }

    public void addInclude(URI targetPath, URL source) throws IOException {
        this.resourceContext.addInclude(targetPath, source);
    }

    public void addInclude(URI targetPath, File source) throws IOException {
        this.resourceContext.addInclude(targetPath, source);
    }

    public void getCompleteManifestClassPath(JarFile moduleFile, URI moduleBaseUri, URI resolutionUri, ClassPathList classpath, ModuleList exclusions) throws DeploymentException {
        ArrayList<DeploymentException> problems = new ArrayList<DeploymentException>();
        this.getCompleteManifestClassPath(moduleFile, moduleBaseUri, resolutionUri, classpath, exclusions, new DefaultJarFileFactory(), problems);
        if (!problems.isEmpty()) {
            if (problems.size() == 1) {
                throw (DeploymentException)problems.get(0);
            }
            throw new DeploymentException("Determining complete manifest classpath unsuccessful: ", problems);
        }
    }

    public void getCompleteManifestClassPath(JarFile moduleFile, URI moduleBaseUri, URI resolutionUri, ClassPathList classpath, ModuleList exclusions, JarFileFactory factory, List<DeploymentException> problems) throws DeploymentException {
        String manifestClassPath;
        try {
            manifestClassPath = factory.getManifestClassPath(moduleFile);
        }
        catch (IOException e) {
            problems.add(new DeploymentException(this.printInfo("Could not read manifest: " + moduleBaseUri, moduleBaseUri, classpath, exclusions), (Throwable)e));
            return;
        }
        if (manifestClassPath == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(manifestClassPath, " ");
        while (tokenizer.hasMoreTokens()) {
            URI pathUri;
            String path = tokenizer.nextToken();
            try {
                pathUri = new URI(path);
            }
            catch (URISyntaxException e) {
                problems.add(new DeploymentException(this.printInfo("Invalid manifest classpath entry, path= " + path, moduleBaseUri, classpath, exclusions)));
                continue;
            }
            if (pathUri.isAbsolute()) {
                problems.add(new DeploymentException(this.printInfo("Manifest class path entries must be relative (J2EE 1.4 Section 8.2): path= " + path, moduleBaseUri, classpath, exclusions)));
                continue;
            }
            URI targetUri = moduleBaseUri.resolve(pathUri);
            try {
                if (factory.isDirectory(targetUri)) {
                    if (!targetUri.getPath().endsWith("/")) {
                        targetUri = URI.create(targetUri.getPath() + "/");
                    }
                    for (File file : factory.listFiles(targetUri)) {
                        if (file.isDirectory()) {
                            log.debug((Object)("Sub directory [" + file.getAbsolutePath() + "] in the manifest entry directory is ignored"));
                            continue;
                        }
                        if (!file.getName().endsWith(".jar")) {
                            log.debug((Object)("Only jar files are added to classpath, file [" + file.getAbsolutePath() + "] is ignored"));
                            continue;
                        }
                        this.addToClassPath(moduleBaseUri, resolutionUri, targetUri.resolve(file.getName()), classpath, exclusions, factory, problems);
                    }
                    continue;
                }
                if (!pathUri.getPath().endsWith(".jar")) {
                    if (manifestClassLoaderMode == 2) {
                        problems.add(new DeploymentException(this.printInfo("Manifest class path entries must end with the .jar extension (J2EE 1.4 Section 8.2): path= " + path, moduleBaseUri, classpath, exclusions)));
                        continue;
                    }
                    log.info((Object)("The " + manifestClassLoaderMessage + " processing mode is in effect.\n" + "Therefore, a manifest classpath entry which does not end with .jar, " + pathUri + " is being permitted and ignored."));
                    continue;
                }
                this.addToClassPath(moduleBaseUri, resolutionUri, targetUri, classpath, exclusions, factory, problems);
            }
            catch (IOException e) {
                if (manifestClassLoaderMode == 2) {
                    problems.add(new DeploymentException("An IOException resulting from manifest classpath : targetUri= " + targetUri, (Throwable)e));
                    continue;
                }
                log.info((Object)("The " + manifestClassLoaderMessage + " processing mode is in effect.\n" + "Therefore, an IOException resulting from manifest classpath " + targetUri + " is being ignored."));
            }
        }
    }

    private void addToClassPath(URI moduleBaseUri, URI resolutionUri, URI targetUri, ClassPathList classpath, ModuleList exclusions, JarFileFactory factory, List<DeploymentException> problems) throws DeploymentException {
        JarFile classPathJarFile;
        String targetEntry = targetUri.toString();
        if (exclusions.contains(targetEntry)) {
            return;
        }
        URI resolvedUri = resolutionUri.resolve(targetUri);
        String classpathEntry = resolvedUri.toString();
        if (classpath.contains(classpathEntry)) {
            return;
        }
        classpath.add(classpathEntry);
        try {
            classPathJarFile = factory.newJarFile(targetUri);
        }
        catch (IOException e) {
            if (manifestClassLoaderMode == 2) {
                problems.add(new DeploymentException(this.printInfo("Manifest class path entries must be a valid jar file, or if it is a directory, all the files with jar suffix in it must be a valid jar file (JAVAEE 5 Section 8.2):  resolved to targetURI= " + targetUri, moduleBaseUri, classpath, exclusions), (Throwable)e));
            } else {
                log.info((Object)("The " + manifestClassLoaderMessage + " processing mode is in effect.\n" + "Therefore, an IOException resulting from manifest classpath " + targetUri + " is being ignored."));
            }
            return;
        }
        this.getCompleteManifestClassPath(classPathJarFile, targetUri, resolutionUri, classpath, exclusions, factory, problems);
    }

    private String printInfo(String message, URI moduleBaseUri, ClassPathList classpath, ModuleList exclusions) {
        StringBuffer buf = new StringBuffer(message).append("\n");
        buf.append("    looking at: ").append(moduleBaseUri);
        buf.append("    current classpath: ").append(classpath);
        buf.append("    ignoring modules: ").append(exclusions);
        return buf.toString();
    }

    public void addManifestClassPath(JarFile moduleFile, URI moduleBaseUri) throws DeploymentException {
        ArrayList<DeploymentException> problems = new ArrayList<DeploymentException>();
        this.addManifestClassPath(moduleFile, moduleBaseUri, new DefaultJarFileFactory(), problems);
        if (!problems.isEmpty()) {
            if (problems.size() == 1) {
                throw (DeploymentException)problems.get(0);
            }
            throw new DeploymentException("Determining complete manifest classpath unsuccessful: ", problems);
        }
    }

    public void addManifestClassPath(JarFile moduleFile, URI moduleBaseUri, JarFileFactory factory, List<DeploymentException> problems) throws DeploymentException {
        String manifestClassPath;
        try {
            manifestClassPath = factory.getManifestClassPath(moduleFile);
        }
        catch (IOException e) {
            problems.add(new DeploymentException("Could not read manifest: " + moduleBaseUri, (Throwable)e));
            return;
        }
        if (manifestClassPath == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(manifestClassPath, " ");
        while (tokenizer.hasMoreTokens()) {
            URI pathUri;
            String path = tokenizer.nextToken();
            try {
                pathUri = new URI(path);
            }
            catch (URISyntaxException e) {
                problems.add(new DeploymentException("Invalid manifest classpath entry: module= " + moduleBaseUri + ", path= " + path));
                continue;
            }
            if (pathUri.isAbsolute()) {
                problems.add(new DeploymentException("Manifest class path entries must be relative (J2EE 1.4 Section 8.2): path= " + path + ", module= " + moduleBaseUri));
                continue;
            }
            URI targetUri = moduleBaseUri.resolve(pathUri);
            try {
                if (factory.isDirectory(targetUri)) {
                    if (!targetUri.getPath().endsWith("/")) {
                        targetUri = URI.create(targetUri.getPath() + "/");
                    }
                    for (File file : factory.listFiles(targetUri)) {
                        if (file.isDirectory()) {
                            log.debug((Object)("Sub directory [" + file.getAbsolutePath() + "] in the manifest entry directory is ignored"));
                            continue;
                        }
                        if (!file.getName().endsWith(".jar")) {
                            log.debug((Object)("Only jar files are added to classpath, file [" + file.getAbsolutePath() + "] is ignored"));
                            continue;
                        }
                        this.addToClassPath(targetUri.resolve(file.getName()), problems);
                    }
                    continue;
                }
                if (!pathUri.getPath().endsWith(".jar")) {
                    if (manifestClassLoaderMode == 2) {
                        problems.add(new DeploymentException("Manifest class path entries must end with the .jar extension (J2EE 1.4 Section 8.2): path= " + path + ", module= " + moduleBaseUri));
                        continue;
                    }
                    log.info((Object)("The " + manifestClassLoaderMessage + " processing mode is in effect.\n" + "Therefore, a manifest classpath entry which does not end with .jar, " + pathUri + " is being permitted and ignored."));
                    continue;
                }
                this.addToClassPath(targetUri, problems);
            }
            catch (IOException e) {
                if (manifestClassLoaderMode == 2) {
                    problems.add(new DeploymentException("An IOException resulting from manifest classpath : targetUri= " + targetUri, (Throwable)e));
                    continue;
                }
                log.info((Object)("The " + manifestClassLoaderMessage + " processing mode is in effect.\n" + "Therefore, an IOException resulting from manifest classpath " + targetUri + " is being ignored."));
            }
        }
    }

    private void addToClassPath(URI targetUri, List<DeploymentException> problems) throws DeploymentException {
        try {
            this.configuration.addToClassPath(targetUri.getPath());
        }
        catch (IOException e) {
            if (manifestClassLoaderMode == 2) {
                problems.add(new DeploymentException("Failure to add targetURI to configuration classpath: " + targetUri.getPath(), (Throwable)e));
            } else {
                log.info((Object)("The " + manifestClassLoaderMessage + " processing mode is in effect.\n" + "Therefore, an IOException resulting from manifest classpath " + targetUri.getPath() + " is being ignored."));
            }
            return;
        }
    }

    public void addClass(URI targetPath, String fqcn, byte[] bytes) throws IOException, URISyntaxException {
        if (!targetPath.getPath().endsWith("/")) {
            throw new IllegalStateException("target path must end with a '/' character: " + targetPath);
        }
        String classFileName = fqcn.replace('.', '/') + ".class";
        this.resourceContext.addFile(new URI(targetPath.toString() + classFileName), bytes);
        this.configuration.addToClassPath(targetPath.toString());
    }

    public void addFile(URI targetPath, ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        this.resourceContext.addFile(targetPath, zipFile, zipEntry);
    }

    public void addFile(URI targetPath, URL source) throws IOException {
        this.resourceContext.addFile(targetPath, source);
    }

    public void addFile(URI targetPath, File source) throws IOException {
        this.resourceContext.addFile(targetPath, source);
    }

    public void addFile(URI targetPath, String source) throws IOException {
        this.resourceContext.addFile(targetPath, source);
    }

    public File getTargetFile(URI targetPath) {
        return this.resourceContext.getTargetFile(targetPath);
    }

    public ClassLoader getClassLoader() throws DeploymentException {
        return this.configuration.getConfigurationClassLoader();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void flush() throws IOException {
        this.resourceContext.flush();
    }

    public void close() throws IOException, DeploymentException {
        if (this.configurationManager != null) {
            try {
                this.configurationManager.unloadConfiguration(this.configuration.getId());
            }
            catch (NoSuchConfigException noSuchConfigException) {
                // empty catch block
            }
        }
    }

    public void addChildConfiguration(String moduleName, ConfigurationData configurationData) {
        this.childConfigurationDatas.put(moduleName, configurationData);
    }

    public ConfigurationData getConfigurationData() throws DeploymentException {
        List<String> failures = this.verify(this.configuration);
        if (!failures.isEmpty()) {
            StringBuffer message = new StringBuffer();
            for (String failure : failures) {
                if (message.length() > 0) {
                    message.append("\n");
                }
                message.append(failure);
            }
            throw new DeploymentException(message.toString());
        }
        ArrayList gbeans = new ArrayList(this.configuration.getGBeans().values());
        Collections.sort(gbeans, new GBeanData.PriorityComparator());
        ConfigurationData configurationData = new ConfigurationData(this.configuration.getModuleType(), new LinkedHashSet(this.configuration.getClassPath()), gbeans, this.childConfigurationDatas, this.configuration.getEnvironment(), this.baseDir, this.inPlaceConfigurationDir, this.naming);
        for (ConfigurationData ownedConfiguration : this.additionalDeployment) {
            configurationData.addOwnedConfigurations(ownedConfiguration.getId());
        }
        return configurationData;
    }

    public void addAdditionalDeployment(ConfigurationData configurationData) {
        this.additionalDeployment.add(configurationData);
    }

    public List<ConfigurationData> getAdditionalDeployment() {
        return this.additionalDeployment;
    }

    public AbstractName getModuleName() {
        return this.moduleName;
    }

    public List<String> verify(Configuration configuration) throws DeploymentException {
        ArrayList<String> failures = new ArrayList<String>();
        for (Map.Entry entry : this.configuration.getGBeans().entrySet()) {
            AbstractName name = (AbstractName)entry.getKey();
            GBeanData gbean = (GBeanData)entry.getValue();
            for (Map.Entry referenceEntry : gbean.getReferences().entrySet()) {
                ReferencePatterns referencePatterns;
                String referenceName = (String)referenceEntry.getKey();
                String failure = this.verifyReference(gbean, referenceName, referencePatterns = (ReferencePatterns)referenceEntry.getValue(), configuration);
                if (failure == null) continue;
                failures.add(failure);
            }
            for (ReferencePatterns referencePatterns : gbean.getDependencies()) {
                String failure = this.verifyDependency(name, referencePatterns, configuration);
                if (failure == null) continue;
                failures.add(failure);
            }
        }
        return failures;
    }

    private String verifyReference(GBeanData gbean, String referenceName, ReferencePatterns referencePatterns, Configuration configuration) {
        GReferenceInfo referenceInfo = gbean.getGBeanInfo().getReference(referenceName);
        if (referenceInfo == null) {
            return null;
        }
        if (referenceInfo.getProxyType().equals(Collection.class.getName())) {
            return null;
        }
        String message = this.isVerifyReference(referencePatterns, configuration);
        if (message != null) {
            return "Unable to resolve reference \"" + referenceName + "\"\n" + "    in gbean " + gbean.getAbstractName() + "\n    to a gbean matching the pattern " + referencePatterns.getPatterns() + "\n    due to: " + message;
        }
        return null;
    }

    private String verifyDependency(AbstractName name, ReferencePatterns referencePatterns, Configuration configuration) {
        String message = this.isVerifyReference(referencePatterns, configuration);
        if (message != null) {
            return "Unable to resolve dependency in gbean " + name + "\n    to a gbean matching the pattern " + referencePatterns.getPatterns() + "\n    due to: " + message;
        }
        return null;
    }

    private String isVerifyReference(ReferencePatterns referencePatterns, Configuration configuration) {
        if (referencePatterns.isResolved()) {
            return null;
        }
        Set patterns = referencePatterns.getPatterns();
        for (AbstractNameQuery query : patterns) {
            if (query.getArtifact() == null) continue;
            return null;
        }
        try {
            configuration.findGBean(patterns);
            return null;
        }
        catch (GBeanNotFoundException e) {
            if (e.hasMatches()) {
                return null;
            }
            return e.getMessage();
        }
    }

    static {
        String mode = System.getProperty("Xorg.apache.geronimo.deployment.LenientMFCP");
        int mfcpMode = 2;
        String mfcpModeMessage = "Strict Manifest Classpath";
        if (mode != null && mode.equals("true")) {
            mfcpMode = 1;
            mfcpModeMessage = "Lenient Manifest Classpath";
        }
        manifestClassLoaderMode = mfcpMode;
        manifestClassLoaderMessage = mfcpModeMessage;
        log.info((Object)("The " + manifestClassLoaderMessage + " processing mode is in effect.\n" + "This option can be altered by specifying -DXorg.apache.geronimo.deployment.LenientMFCP=true|false\n" + "Specify =\"true\" for more lenient processing such as ignoring missing jars and references that are not spec compliant."));
    }

    private class DefaultJarFileFactory
    implements JarFileFactory {
        private DefaultJarFileFactory() {
        }

        public JarFile newJarFile(URI relativeURI) throws IOException {
            File targetFile = DeploymentContext.this.getTargetFile(relativeURI);
            try {
                return new JarFile(targetFile);
            }
            catch (IOException e) {
                throw (IOException)new IOException("Could not create JarFile for file: " + targetFile).initCause(e);
            }
        }

        public String getManifestClassPath(JarFile jarFile) throws IOException {
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                return null;
            }
            return manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        }

        public boolean isDirectory(URI relativeURI) {
            File targetFile = DeploymentContext.this.getTargetFile(relativeURI);
            return targetFile.isDirectory();
        }

        public File[] listFiles(URI relativeURI) throws IOException {
            File targetFile = DeploymentContext.this.getTargetFile(relativeURI);
            if (targetFile.isDirectory()) {
                File[] files = targetFile.listFiles();
                return files == null ? new File[]{} : files;
            }
            throw new IOException(targetFile + " is not a directory");
        }
    }

    static interface JarFileFactory {
        public JarFile newJarFile(URI var1) throws IOException;

        public String getManifestClassPath(JarFile var1) throws IOException;

        public boolean isDirectory(URI var1) throws IOException;

        public File[] listFiles(URI var1) throws IOException;
    }
}

