/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.apache.geronimo.cli.shutdown.ShutdownCLParser;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.cli.StreamConsoleReader;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.util.Main;
import org.osgi.framework.Bundle;

public class StopServer
implements Main {
    public static final String DEFAULT_PORT = "1099";
    private String host;
    private Integer port;
    private String user;
    private String password;
    private boolean secure;
    private final Bundle bundle;
    public static final GBeanInfo GBEAN_INFO;

    public StopServer(Bundle bundle) {
        this.bundle = bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(Object opaque) {
        if (!(opaque instanceof ShutdownCLParser)) {
            throw new IllegalArgumentException("Argument type is [" + opaque.getClass() + "]; expected [" + ShutdownCLParser.class + "]");
        }
        ShutdownCLParser parser = (ShutdownCLParser)opaque;
        this.port = parser.getPort();
        if (this.port == null) {
            this.port = new Integer(DEFAULT_PORT);
        }
        this.host = parser.getHost();
        if (this.host == null) {
            this.host = "localhost";
        }
        this.secure = parser.isSecure();
        if (this.secure) {
            try {
                DeployUtils.setSecurityProperties();
            }
            catch (DeploymentException e) {
                System.err.println(e.getMessage());
                return 1;
            }
        }
        this.user = parser.getUser();
        this.password = parser.getPassword();
        if (this.user == null && this.password == null) {
            String uri = DeployUtils.getConnectionURI(this.host, this.port, this.secure);
            ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(DeployUtils.class.getClassLoader());
            try {
                DeployUtils.SavedAuthentication savedAuthentication = DeployUtils.readSavedCredentials(uri);
                if (savedAuthentication != null) {
                    this.user = savedAuthentication.getUser();
                    this.password = new String(savedAuthentication.getPassword());
                }
            }
            catch (IOException e) {
                System.out.println("Warning: " + e.getMessage());
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
        }
        if (this.user == null || this.password == null) {
            try {
                StreamConsoleReader consoleReader = new StreamConsoleReader(System.in, System.out);
                if (this.user == null) {
                    this.user = consoleReader.readLine("Username: ");
                }
                if (this.password == null) {
                    this.password = new String(consoleReader.readPassword("Password: "));
                }
            }
            catch (Exception e) {
                System.out.println("Unable to prompt for login.");
                return 1;
            }
        }
        System.out.print("Locating server on " + this.host + ":" + this.port + "... ");
        MBeanServerConnection conn = null;
        try {
            conn = this.getMBeanServerConnection();
        }
        catch (Exception e) {
            System.err.println("Could not communicate with the server.  The server may not be running or the port number may be incorrect (" + e.getMessage() + ")");
            return 1;
        }
        if (conn != null) {
            System.out.println("Server found.");
            try {
                this.shutdown(conn);
            }
            catch (Exception e) {
                System.err.println("Error shutting down the server");
                e.printStackTrace();
                return 2;
            }
        }
        return 0;
    }

    public MBeanServerConnection getMBeanServerConnection() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jmx.remote.credentials", new String[]{this.user, this.password});
        String connectorName = "/JMXConnector";
        if (this.secure) {
            connectorName = "/JMXSecureConnector";
            SslRMIClientSocketFactory csf = new SslRMIClientSocketFactory();
            map.put("jmx.remote.rmi.client.socket.factory", csf);
        }
        JMXServiceURL address = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + this.host + ":" + this.port + connectorName);
        JMXConnector jmxConnector = JMXConnectorFactory.connect(address, map);
        return jmxConnector.getMBeanServerConnection();
    }

    public void shutdown(MBeanServerConnection mbServerConnection) throws Exception {
        Set<ObjectName> objectNameSet = mbServerConnection.queryNames(new ObjectName("osgi.core:type=framework,*"), null);
        if (objectNameSet.isEmpty()) {
            throw new Exception("Framework mbean not found");
        }
        if (objectNameSet.size() != 1) {
            throw new Exception("Found multiple framework mbeans");
        }
        System.out.println("Server shutdown started");
        mbServerConnection.invoke(objectNameSet.iterator().next(), "stopBundle", new Object[]{0}, new String[]{Long.TYPE.getName()});
        System.out.println("Server shutdown completed");
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(StopServer.class, (String)"StopServer");
        infoBuilder.addAttribute("bundle", Bundle.class, false);
        infoBuilder.setConstructor(new String[]{"bundle"});
        infoBuilder.addInterface(Main.class);
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

