/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import jline.Terminal;
import jline.UnsupportedTerminal;
import org.apache.geronimo.deployment.cli.ConsoleReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamConsoleReader
implements ConsoleReader {
    private static final Logger logger = LoggerFactory.getLogger(StreamConsoleReader.class);
    protected BufferedReader keyboard;
    protected PrintWriter console;
    private jline.console.ConsoleReader jlineConsoleReader;
    private boolean jlineConsoleEnabled = true;

    public StreamConsoleReader(InputStream in, PrintStream out) {
        this(in, new PrintWriter(out, true));
    }

    public StreamConsoleReader(InputStream in, PrintWriter out) {
        try {
            this.jlineConsoleReader = "jline.UnsupportedTerminal".equals(System.getProperty("jline.terminal")) ? new jline.console.ConsoleReader(in, (Writer)out, (Terminal)new UnsupportedTerminal()) : new jline.console.ConsoleReader(in, (Writer)out);
        }
        catch (Throwable e) {
            logger.warn("Fail to create jline console, some features like password mask will be disabled, you might change the log level to debug to show the detailed information");
            if (logger.isDebugEnabled()) {
                logger.debug("Fail to create jline console, some features like password mask will be disabled", e);
            }
            this.jlineConsoleEnabled = false;
            this.keyboard = new BufferedReader(new InputStreamReader(in));
            this.console = out;
        }
    }

    @Override
    public void printNewline() throws IOException {
        if (this.jlineConsoleEnabled) {
            this.jlineConsoleReader.println();
        } else {
            this.console.println();
        }
    }

    @Override
    public void printString(String s) throws IOException {
        if (this.jlineConsoleEnabled) {
            this.jlineConsoleReader.print((CharSequence)s);
        } else {
            this.console.print(s);
        }
    }

    @Override
    public void println(String s) throws IOException {
        if (this.jlineConsoleEnabled) {
            this.jlineConsoleReader.print((CharSequence)s);
            this.jlineConsoleReader.println();
        } else {
            this.console.println(s);
            this.console.println();
        }
    }

    @Override
    public String readLine() throws IOException {
        if (this.jlineConsoleEnabled) {
            return this.jlineConsoleReader.readLine();
        }
        return this.keyboard.readLine();
    }

    @Override
    public String readLine(String prompt) throws IOException {
        if (this.jlineConsoleEnabled) {
            return this.jlineConsoleReader.readLine(prompt);
        }
        this.printString(prompt);
        this.flushConsole();
        return this.keyboard.readLine();
    }

    @Override
    public void flushConsole() throws IOException {
        if (this.jlineConsoleEnabled) {
            this.jlineConsoleReader.flush();
        } else {
            this.console.flush();
        }
    }

    @Override
    public String readPassword() throws IOException {
        if (this.jlineConsoleEnabled) {
            return this.jlineConsoleReader.readLine(Character.valueOf('*'));
        }
        return this.keyboard.readLine();
    }

    @Override
    public String readPassword(String prompt) throws IOException {
        if (this.jlineConsoleEnabled) {
            return this.jlineConsoleReader.readLine(prompt, Character.valueOf('*'));
        }
        this.printString(prompt);
        this.flushConsole();
        return this.keyboard.readLine();
    }
}

