/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.Serializable;
import javax.enterprise.deploy.spi.DeploymentManager;
import jline.ConsoleReader;
import org.apache.geronimo.cli.deployer.CommandArgs;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.crypto.EncryptionManager;
import org.apache.geronimo.deployment.cli.AbstractCommand;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.cli.ServerConnection;
import org.apache.geronimo.deployment.plugin.jmx.RemoteDeploymentManager;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.system.util.ConfiguredEncryption;

public class CommandEncrypt
extends AbstractCommand {
    public void execute(ConsoleReader consoleReader, ServerConnection connection, CommandArgs commandArgs) throws DeploymentException {
        try {
            consoleReader.printString(DeployUtils.reformat("String to encrypt: " + commandArgs.getArgs()[0], 4, 72));
            DeploymentManager dm = connection.getDeploymentManager();
            if (dm instanceof RemoteDeploymentManager) {
                Kernel k = ((RemoteDeploymentManager)dm).getKernel();
                Object ret = k.invoke(ConfiguredEncryption.class, "encrypt", new Object[]{commandArgs.getArgs()[0]}, new String[]{"java.lang.String"});
                consoleReader.printString(DeployUtils.reformat("Online encryption result: " + ret, 4, 72));
            } else {
                String ret = EncryptionManager.encrypt((Serializable)((Object)commandArgs.getArgs()[0]));
                consoleReader.printString(DeployUtils.reformat("Offline encryption result: " + ret, 4, 72));
            }
            consoleReader.printNewline();
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to reach the server to do the encryption.", (Throwable)e);
        }
    }
}

