/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.jmx;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.FailedLoginException;
import org.apache.geronimo.deployment.plugin.GeronimoDeploymentManager;
import org.apache.geronimo.deployment.plugin.jmx.JMXDeploymentManager;
import org.apache.geronimo.deployment.spi.ModuleConfigurer;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InvalidGBeanException;
import org.apache.geronimo.kernel.NoSuchOperationException;
import org.apache.geronimo.kernel.config.ConfigurationInfo;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.NoSuchStoreException;
import org.apache.geronimo.kernel.management.State;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Dependency;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.system.bundle.BundleRecorder;
import org.apache.geronimo.system.plugin.DownloadPoller;
import org.apache.geronimo.system.plugin.DownloadResults;
import org.apache.geronimo.system.plugin.PluginInstaller;
import org.apache.geronimo.system.plugin.PluginRepositoryList;
import org.apache.geronimo.system.plugin.ServerArchiver;
import org.apache.geronimo.system.plugin.model.AttributesType;
import org.apache.geronimo.system.plugin.model.PluginListType;
import org.apache.geronimo.system.plugin.model.PluginType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtendedDeploymentManager
extends JMXDeploymentManager
implements GeronimoDeploymentManager {
    private static final Logger log = LoggerFactory.getLogger(ExtendedDeploymentManager.class);

    public ExtendedDeploymentManager(Collection<ModuleConfigurer> moduleConfigurers) {
        super(moduleConfigurers);
    }

    @Override
    public <T> T getImplementation(Class<T> clazz) {
        try {
            return (T)this.kernel.getGBean(clazz);
        }
        catch (GBeanNotFoundException e) {
            throw new IllegalStateException("No implementation for " + clazz.getName(), e);
        }
    }

    protected <T> T getImplementation(AbstractName name, Class<T> clazz) {
        try {
            return clazz.cast(this.kernel.getGBean(name));
        }
        catch (GBeanNotFoundException e) {
            throw new IllegalStateException("No implementation for " + clazz.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginListType listPlugins(URL mavenRepository) throws FailedLoginException, IOException {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            PluginListType pluginListType = installer.listPlugins(mavenRepository);
            return pluginListType;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validatePlugin(PluginType plugin) throws MissingDependencyException {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            boolean bl = installer.validatePlugin(plugin);
            return bl;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dependency[] checkPrerequisites(PluginType plugin) {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            Dependency[] dependencyArray = installer.checkPrerequisites(plugin);
            return dependencyArray;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadResults install(PluginListType configsToInstall, String defaultRepository, boolean restrictToDefaultRepository, String username, String password) {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            DownloadResults downloadResults = installer.install(configsToInstall, defaultRepository, restrictToDefaultRepository, username, password);
            return downloadResults;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(PluginListType configsToInstall, String defaultRepository, boolean restrictToDefaultRepository, String username, String password, DownloadPoller poller) {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            installer.install(configsToInstall, defaultRepository, restrictToDefaultRepository, username, password, poller);
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object startInstall(PluginListType configsToInstall, String defaultRepository, boolean restrictToDefaultRepository, String username, String password) {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            Object object = installer.startInstall(configsToInstall, defaultRepository, restrictToDefaultRepository, username, password);
            return object;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object startInstall(File carFile, String defaultRepository, boolean restrictToDefaultRepository, String username, String password) {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            Object object = installer.startInstall(carFile, defaultRepository, restrictToDefaultRepository, username, password);
            return object;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadResults checkOnInstall(Object key) {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            DownloadResults downloadResults = installer.checkOnInstall(key);
            return downloadResults;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadResults checkOnInstall(Object key, boolean remove) {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            DownloadResults downloadResults = installer.checkOnInstall(key, remove);
            return downloadResults;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)installer);
        }
    }

    private PluginInstaller getPluginInstaller() {
        return this.getImplementation(PluginInstaller.class);
    }

    private ServerArchiver getServerArchiver() {
        return this.getImplementation(ServerArchiver.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginListType createPluginListForRepositories(String repo) throws NoSuchStoreException {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            PluginListType pluginListType = installer.createPluginListForRepositories(repo);
            return pluginListType;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Artifact> getInstalledPlugins() {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            Map map = installer.getInstalledPlugins();
            return map;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginType getPluginMetadata(Artifact configId) {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            PluginType pluginType = installer.getPluginMetadata(configId);
            return pluginType;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePluginMetadata(PluginType metadata) {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            installer.updatePluginMetadata(metadata);
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL[] getRepositories() {
        ArrayList list = new ArrayList();
        Set set = this.kernel.listGBeans(new AbstractNameQuery(PluginRepositoryList.class.getName()));
        for (AbstractName name : set) {
            PluginRepositoryList repo = this.getImplementation(name, PluginRepositoryList.class);
            try {
                list.addAll(repo.getRepositories());
            }
            finally {
                this.kernel.getProxyManager().destroyProxy((Object)repo);
            }
        }
        return list.toArray(new URL[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Artifact installLibrary(File libFile, String groupId) throws IOException {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            Artifact artifact = installer.installLibrary(libFile, groupId);
            return artifact;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadResults installPluginList(String targetRepositoryPath, String relativeTargetServerPath, PluginListType pluginList) throws Exception {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            DownloadResults downloadResults = installer.installPluginList(targetRepositoryPath, relativeTargetServerPath, pluginList);
            return downloadResults;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeOverrides(String server, AttributesType overrides) throws InvalidGBeanException, IOException {
        PluginInstaller installer = this.getPluginInstaller();
        try {
            installer.mergeOverrides(server, overrides);
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)installer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File archive(String sourcePath, String destPath, Artifact artifact) throws IOException {
        ServerArchiver archiver = this.getServerArchiver();
        try {
            File file = archiver.archive(sourcePath, destPath, artifact);
            return file;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)archiver);
        }
    }

    @Override
    public Artifact[] getEBAConfigurationIds() {
        List stores = this.configurationManager.listStores();
        if (stores.isEmpty()) {
            return null;
        }
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        for (AbstractName store : stores) {
            try {
                List infos = this.configurationManager.listConfigurations(store);
                for (Object info : infos) {
                    ConfigurationInfo configInfo = (ConfigurationInfo)info;
                    if (!ConfigurationModuleType.EBA.equals(configInfo.getType())) continue;
                    result.add(configInfo.getConfigID());
                }
            }
            catch (NoSuchStoreException e) {
                e.printStackTrace();
            }
        }
        return result.size() == 0 ? null : result.toArray(new Artifact[result.size()]);
    }

    @Override
    public long[] getEBAContentBundleIds(AbstractName applicationGBeanName) throws GBeanNotFoundException, NoSuchOperationException, Exception {
        long[] ids = (long[])this.kernel.getAttribute(applicationGBeanName, "applicationContentBundleIds");
        return ids;
    }

    @Override
    public String getEBAContentBundleSymbolicName(AbstractName applicationGBeanName, long bundleId) throws GBeanNotFoundException, NoSuchOperationException, Exception {
        Object name = this.kernel.invoke(applicationGBeanName, "getApplicationContentBundleSymbolicName", new Object[]{bundleId}, new String[]{Long.TYPE.getName()});
        if (name != null) {
            return (String)name;
        }
        return null;
    }

    @Override
    public void updateEBAContent(AbstractName applicationGBeanName, long bundleId, File bundleFile) throws GBeanNotFoundException, NoSuchOperationException, Exception {
        this.kernel.invoke(applicationGBeanName, "updateApplicationContent", new Object[]{bundleId, bundleFile}, new String[]{Long.TYPE.getName(), bundleFile.getClass().getName()});
    }

    @Override
    public AbstractName getApplicationGBeanName(Artifact configurationId) {
        Set applicationGBeanNames = this.kernel.listGBeans(new AbstractNameQuery(configurationId, Collections.EMPTY_MAP, "org.apache.geronimo.aries.ApplicationGBean"));
        if (applicationGBeanNames.size() != 1) {
            throw new IllegalStateException("An EBA should have one and only one ApplicationGean object");
        }
        return (AbstractName)applicationGBeanNames.iterator().next();
    }

    private BundleRecorder getBundleRecorder() {
        return this.getImplementation(BundleRecorder.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long recordInstall(File bundleFile, String groupId, int startLevel) throws IOException {
        BundleRecorder recorder = this.getBundleRecorder();
        try {
            long l = recorder.recordInstall(bundleFile, groupId, startLevel);
            return l;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)recorder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseUninstall(long bundleId) throws IOException {
        BundleRecorder recorder = this.getBundleRecorder();
        try {
            recorder.eraseUninstall(bundleId);
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)recorder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBundleId(String symbolicName, String version) {
        BundleRecorder recorder = this.getBundleRecorder();
        try {
            long l = recorder.getBundleId(symbolicName, version);
            return l;
        }
        finally {
            this.kernel.getProxyManager().destroyProxy((Object)recorder);
        }
    }

    public State getModulesState(Artifact moduleID) {
        if (this.kernel == null) {
            throw new IllegalStateException("Disconnected");
        }
        return this.getState(moduleID);
    }

    public State[] getModulesState(Artifact[] moduleIDList) {
        if (this.kernel == null) {
            throw new IllegalStateException("Disconnected");
        }
        if (moduleIDList == null) {
            return null;
        }
        State[] states = new State[moduleIDList.length];
        for (int i = 0; i < moduleIDList.length; ++i) {
            Artifact moduleID = moduleIDList[i];
            states[i] = this.getState(moduleID);
        }
        return states;
    }

    private State getState(Artifact moduleID) {
        if (moduleID != null && this.configurationManager.isInstalled(moduleID)) {
            if (this.configurationManager.isRunning(moduleID)) {
                return State.RUNNING;
            }
            return State.STOPPED;
        }
        return null;
    }
}

