/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.factories;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.apache.geronimo.deployment.ModuleConfigurer;
import org.apache.geronimo.deployment.plugin.DisconnectedDeploymentManager;
import org.apache.geronimo.deployment.plugin.factories.AuthenticationFailedException;
import org.apache.geronimo.deployment.plugin.jmx.LocalDeploymentManager;
import org.apache.geronimo.deployment.plugin.jmx.RemoteDeploymentManager;
import org.apache.geronimo.kernel.KernelRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseDeploymentFactory
implements DeploymentFactory {
    private static final Logger log = LoggerFactory.getLogger(BaseDeploymentFactory.class);
    public static final String URI_PREFIX = "deployer:geronimo:";
    private static final int DEFAULT_PORT = 1099;

    public String getDisplayName() {
        return "Apache Geronimo";
    }

    public String getProductVersion() {
        return "1.0";
    }

    public boolean handlesURI(String uri) {
        return this.parseURI(uri) != null;
    }

    private ConnectParams parseURI(String uri) {
        uri = uri.trim();
        if (log.isDebugEnabled()) {
            log.debug("Parsing URI=" + uri);
        }
        if (!uri.startsWith(URI_PREFIX)) {
            return null;
        }
        int pos = (uri = uri.substring(URI_PREFIX.length())).indexOf(":");
        String protocol = pos == -1 ? uri : uri.substring(0, pos);
        String string = uri = pos == -1 ? "" : uri.substring(pos + 1);
        if (protocol.equals("jmx") || protocol.equals("jmxs")) {
            boolean secure = protocol.equals("jmxs");
            if (!uri.startsWith("//")) {
                return new ConnectParams(protocol, "localhost", 1099, secure);
            }
            pos = (uri = uri.substring(2)).indexOf(58);
            if (pos == -1) {
                return new ConnectParams(protocol, uri.equals("") ? "localhost" : uri, 1099, secure);
            }
            if (uri.indexOf(47, pos + 1) > -1) {
                return null;
            }
            if (uri.indexOf(58, pos + 1) > -1) {
                return null;
            }
            String host = uri.substring(0, pos);
            String port = uri.substring(pos + 1);
            try {
                return new ConnectParams(protocol, host.equals("") ? "localhost" : host, Integer.parseInt(port), secure);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (protocol.equals("inVM")) {
            if (uri.startsWith("//")) {
                String kernel = uri.substring(2);
                return new ConnectParams(protocol, kernel, -1);
            }
            return new ConnectParams(protocol, KernelRegistry.getSingleKernel() == null ? null : KernelRegistry.getSingleKernel().getKernelName(), -1);
        }
        return null;
    }

    public DeploymentManager getDisconnectedDeploymentManager(String uri) throws DeploymentManagerCreationException {
        if (!this.handlesURI(uri)) {
            return null;
        }
        Collection<ModuleConfigurer> moduleConfigurers = this.getModuleConfigurers();
        return new DisconnectedDeploymentManager(moduleConfigurers);
    }

    public DeploymentManager getDeploymentManager(String uri, String username, String password) throws DeploymentManagerCreationException {
        ConnectParams params = this.parseURI(uri);
        if (params == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Using protocol=" + params.getProtocol() + ", host=" + params.getHost() + ", port=" + params.getPort());
        }
        try {
            if (params.getProtocol().equals("jmx") || params.getProtocol().equals("jmxs")) {
                return this.newRemoteDeploymentManager(username, password, params);
            }
            if (params.getProtocol().equals("inVM")) {
                return new LocalDeploymentManager(KernelRegistry.getKernel((String)params.getHost()));
            }
            throw new DeploymentManagerCreationException("Invalid URI: " + uri);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Error e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    protected Collection<ModuleConfigurer> getModuleConfigurers() throws DeploymentManagerCreationException {
        return Collections.EMPTY_LIST;
    }

    protected DeploymentManager newRemoteDeploymentManager(String username, String password, ConnectParams params) throws DeploymentManagerCreationException, AuthenticationFailedException {
        HashMap<String, Object> environment = new HashMap<String, Object>();
        String[] credentials = new String[]{username, password};
        environment.put("jmx.remote.credentials", credentials);
        environment.put("jmx.remote.default.class.loader", BaseDeploymentFactory.class.getClassLoader());
        String connectorName = "/JMXConnector";
        if (params.isSecure()) {
            connectorName = "/JMXSecureConnector";
            SslRMIClientSocketFactory csf = new SslRMIClientSocketFactory();
            environment.put("jmx.remote.rmi.client.socket.factory", csf);
        }
        try {
            String host = params.getHost();
            if (host.indexOf(":") >= 0) {
                host = "[" + host + "]";
            }
            if (log.isDebugEnabled()) {
                log.debug("Using JMXServiceURL with host=" + host + ", port=" + params.getPort() + ", secure=" + params.isSecure());
            }
            JMXServiceURL address = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + host + ":" + params.getPort() + connectorName);
            JMXConnector jmxConnector = JMXConnectorFactory.connect(address, environment);
            RemoteDeploymentManager manager = this.getRemoteDeploymentManager();
            manager.init(jmxConnector, host);
            if (!manager.isSameMachine()) {
                manager.setAuthentication(username, password);
            }
            return manager;
        }
        catch (IOException e) {
            DeploymentManagerCreationException deploymentManagerCreationException = (DeploymentManagerCreationException)new DeploymentManagerCreationException(e.getMessage()).initCause((Throwable)e);
            log.debug("throwing ", (Throwable)deploymentManagerCreationException);
            throw deploymentManagerCreationException;
        }
        catch (SecurityException e) {
            AuthenticationFailedException authenticationFailedException = (AuthenticationFailedException)((Object)new AuthenticationFailedException("Invalid login.").initCause(e));
            log.debug("throwing ", (Throwable)((Object)authenticationFailedException));
            throw authenticationFailedException;
        }
    }

    protected RemoteDeploymentManager getRemoteDeploymentManager() throws DeploymentManagerCreationException {
        Collection<ModuleConfigurer> moduleConfigurers = this.getModuleConfigurers();
        return new RemoteDeploymentManager(moduleConfigurers);
    }

    private static final class ConnectParams {
        private String protocol;
        private String host;
        private int port;
        private boolean secure;

        public ConnectParams(String protocol, String host, int port) {
            this(protocol, host, port, false);
        }

        public ConnectParams(String protocol, String host, int port, boolean secure) {
            this.protocol = protocol;
            this.host = host;
            this.port = port;
            this.secure = secure;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public String toString() {
            return this.protocol + " / " + this.host + " / " + this.port;
        }
    }
}

