/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.util;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.geronimo.kernel.ClassLoading;

public final class XmlUtil {
    public static final String DOCUMENT_BUILDER_FACTORY = "geronimo.xml.parsers.DocumentBuilderFactory";
    public static final String SAX_PARSER_FACTORY = "geronimo.xml.parsers.SAXParserFactory";
    public static final String TRANSFORMER_FACTORY = "geronimo.xml.transform.TransformerFactory";

    private XmlUtil() {
    }

    public static DocumentBuilderFactory newDocumentBuilderFactory() {
        return XmlUtil.newDocumentBuilderFactory(XmlUtil.getClassLoader());
    }

    public static DocumentBuilderFactory newDocumentBuilderFactory(ClassLoader classLoader) {
        String documentBuilderName = XmlUtil.getSystemProperty(DOCUMENT_BUILDER_FACTORY);
        if (documentBuilderName != null && documentBuilderName.length() != 0) {
            try {
                Class documentBuilderClass = ClassLoading.loadClass(documentBuilderName, classLoader);
                DocumentBuilderFactory documentBuilderFactory = (DocumentBuilderFactory)documentBuilderClass.newInstance();
                return documentBuilderFactory;
            }
            catch (Exception e) {
                throw new FactoryConfigurationError(e, "Unable to create DocumentBuilderFactory " + documentBuilderName + ", which was specified in the " + DOCUMENT_BUILDER_FACTORY + " system property");
            }
        }
        return DocumentBuilderFactory.newInstance();
    }

    public static SAXParserFactory newSAXParserFactory() {
        return XmlUtil.newSAXParserFactory(XmlUtil.getClassLoader());
    }

    public static SAXParserFactory newSAXParserFactory(ClassLoader classLoader) {
        String saxParserName = XmlUtil.getSystemProperty(SAX_PARSER_FACTORY);
        if (saxParserName != null && saxParserName.length() != 0) {
            try {
                Class saxParserClass = ClassLoading.loadClass(saxParserName, classLoader);
                SAXParserFactory saxParserFactory = (SAXParserFactory)saxParserClass.newInstance();
                return saxParserFactory;
            }
            catch (Exception e) {
                throw new FactoryConfigurationError(e, "Unable to create SAXParserFactory " + saxParserName + ", which was specified in the " + SAX_PARSER_FACTORY + " system property");
            }
        }
        return SAXParserFactory.newInstance();
    }

    public static TransformerFactory newTransformerFactory() {
        return XmlUtil.newTransformerFactory(XmlUtil.getClassLoader());
    }

    public static TransformerFactory newTransformerFactory(ClassLoader classLoader) {
        String transformerName = XmlUtil.getSystemProperty(TRANSFORMER_FACTORY);
        if (transformerName != null && transformerName.length() != 0) {
            try {
                Class transformerClass = ClassLoading.loadClass(transformerName, classLoader);
                TransformerFactory transformerFactory = (TransformerFactory)transformerClass.newInstance();
                return transformerFactory;
            }
            catch (Exception e) {
                throw new TransformerFactoryConfigurationError(e, "Unable to create TransformerFactory " + transformerName + ", which was specified in the " + TRANSFORMER_FACTORY + " system property");
            }
        }
        return TransformerFactory.newInstance();
    }

    private static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            return classLoader;
        }
        return XmlUtil.class.getClassLoader();
    }

    private static String getSystemProperty(String key) {
        String value = System.getProperty(key);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }
}

