/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.util;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputUtils {
    private static final Logger log = LoggerFactory.getLogger(InputUtils.class);
    private static final Pattern ILLEGAL_CHARS = Pattern.compile("[\\.]{2}|[<>:\\\\/\"'\\|]");

    public static final void validateSafeInput(String input) {
        Matcher inputMatcher;
        if (input != null && (inputMatcher = ILLEGAL_CHARS.matcher(input)).find()) {
            log.warn("Illegal characters detected in input" + input);
            throw new IllegalArgumentException("input  " + input + " contains illegal characters: .. < > : / \\ ' \" | ");
        }
    }

    public static final void validateSafeInput(List<String> inputs) {
        for (String input : inputs) {
            InputUtils.validateSafeInput(input);
        }
    }
}

