/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationParent;
import org.apache.geronimo.kernel.config.ConfigurationResolver;
import org.apache.geronimo.kernel.config.DependencyNode;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.ManageableAttributeStore;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.apache.xbean.osgi.bundle.util.DelegatingBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
public class Configuration
implements GBeanLifecycle,
ConfigurationParent {
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);
    private final AbstractName abstractName;
    private final ConfigurationResolver configurationResolver;
    private final DependencyNode dependencyNode;
    private final List<Configuration> allServiceParents;
    private final Map<AbstractName, GBeanData> gbeans = new LinkedHashMap<AbstractName, GBeanData>();
    private final Naming naming;
    private final ConfigurationData configurationData;
    private final List<Configuration> children = new ArrayList<Configuration>();
    private Configuration parent = null;
    private ManageableAttributeStore attributeStore = null;
    private Bundle bundle;

    public static AbstractName getConfigurationAbstractName(Artifact configId) throws InvalidConfigException {
        return new AbstractName(configId, Collections.singletonMap("configurationName", configId.toString()), Configuration.getConfigurationObjectName(configId));
    }

    public static boolean isConfigurationObjectName(ObjectName name) {
        return name.getDomain().equals("geronimo.config") && name.getKeyPropertyList().size() == 1 && name.getKeyProperty("name") != null;
    }

    public static Artifact getConfigurationID(ObjectName objectName) {
        if (Configuration.isConfigurationObjectName(objectName)) {
            String name = ObjectName.unquote(objectName.getKeyProperty("name"));
            return Artifact.create(name);
        }
        throw new IllegalArgumentException("ObjectName " + objectName + " is not a Configuration name");
    }

    private static ObjectName getConfigurationObjectName(Artifact configId) throws InvalidConfigException {
        try {
            return new ObjectName("geronimo.config:name=" + ObjectName.quote(configId.toString()));
        }
        catch (MalformedObjectNameException e) {
            throw new InvalidConfigException("Could not construct object name for configuration", e);
        }
    }

    public Configuration(@ParamAttribute(name="configurationData") ConfigurationData configurationData, @ParamAttribute(name="dependencyNode") DependencyNode dependencyNode, @ParamAttribute(name="allServiceParents") List<Configuration> allServiceParents, @ParamAttribute(name="attributeStore") ManageableAttributeStore attributeStore, @ParamAttribute(name="configurationResolver") ConfigurationResolver configurationResolver, @ParamAttribute(name="configurationManager") ConfigurationManager configurationManager) throws InvalidConfigException {
        if (configurationData == null) {
            throw new NullPointerException("configurationData is null");
        }
        this.configurationData = configurationData;
        this.naming = configurationData.getNaming();
        this.attributeStore = attributeStore;
        this.dependencyNode = dependencyNode;
        this.allServiceParents = allServiceParents;
        this.configurationResolver = configurationResolver;
        this.abstractName = Configuration.getConfigurationAbstractName(dependencyNode.getId());
        this.bundle = configurationData.getBundleContext().getBundle();
        if (configurationData.isUseEnvironment() && configurationManager != null) {
            try {
                Collection<Bundle> bundles = this.getBundles(configurationData, configurationResolver, configurationManager);
                this.bundle = new DelegatingBundle(bundles);
            }
            catch (Exception e) {
                log.debug("Failed to identify bundle parents for " + configurationData.getId(), (Throwable)e);
            }
        }
        try {
            Collection<GBeanData> gbeans = configurationData.getGBeans(this.bundle);
            if (attributeStore != null) {
                gbeans = attributeStore.applyOverrides(dependencyNode.getId(), gbeans, this.bundle);
            }
            for (GBeanData gbeanData : gbeans) {
                this.gbeans.put(gbeanData.getAbstractName(), gbeanData);
            }
        }
        catch (RuntimeException e) {
            this.shutdown();
            throw e;
        }
        catch (Error e) {
            this.shutdown();
            throw e;
        }
        catch (InvalidConfigException e) {
            this.shutdown();
            throw e;
        }
    }

    private Collection<Bundle> getBundles(ConfigurationData configurationData, ConfigurationResolver configurationResolver, ConfigurationManager configurationManager) throws MissingDependencyException, InvalidConfigException {
        LinkedHashSet<Bundle> bundles = new LinkedHashSet<Bundle>();
        bundles.add(configurationData.getBundleContext().getBundle());
        this.getAllBundles(configurationData, configurationManager, new HashSet<Artifact>(), bundles);
        return bundles;
    }

    private void getAllBundles(ConfigurationData configurationData, ConfigurationManager configurationManager, Set<Artifact> artifacts, Collection<Bundle> bundles) throws MissingDependencyException, InvalidConfigException {
        LinkedHashSet<Artifact> parents = configurationManager.resolveParentIds(configurationData);
        for (Artifact parent : parents) {
            if (artifacts.contains(parent)) continue;
            artifacts.add(parent);
            boolean isConfiguration = configurationManager.isConfiguration(parent);
            if (isConfiguration) {
                Configuration configuration = configurationManager.getConfiguration(parent);
                this.getAllBundles(configuration.getConfigurationData(), configurationManager, artifacts, bundles);
                continue;
            }
            String location = Configuration.getBundleLocation(this.configurationResolver, parent);
            Bundle bundle = Configuration.getBundleByLocation(configurationData.getBundleContext(), location);
            if (bundle == null) continue;
            bundles.add(bundle);
        }
    }

    private static String getBundleLocation(ConfigurationResolver configurationResolver, Artifact configurationId) {
        if (configurationResolver == null) {
            throw new NullPointerException("ConfigurationResolver is null");
        }
        try {
            File file = configurationResolver.resolve(configurationId);
            return BundleUtils.toReferenceFileLocation((File)file);
        }
        catch (MissingDependencyException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static Bundle getBundleByLocation(BundleContext bundleContext, String location) {
        for (Bundle bundle : bundleContext.getBundles()) {
            if (!location.equals(bundle.getLocation())) continue;
            return bundle;
        }
        return null;
    }

    void addChild(Configuration child) {
        this.children.add(child);
        child.parent = this;
    }

    public Artifact getId() {
        return this.dependencyNode.getId();
    }

    public String getObjectName() {
        try {
            return Configuration.getConfigurationObjectName(this.getId()).getCanonicalName();
        }
        catch (InvalidConfigException e) {
            throw new AssertionError((Object)e);
        }
    }

    public AbstractName getAbstractName() {
        return this.abstractName;
    }

    public DependencyNode getDependencyNode() {
        return this.dependencyNode;
    }

    public Environment getEnvironment() {
        return this.configurationData.getEnvironment();
    }

    ConfigurationData getConfigurationData() {
        return this.configurationData;
    }

    public File getConfigurationDir() {
        return this.configurationData.getConfigurationDir();
    }

    public ConfigurationResolver getConfigurationResolver() {
        return this.configurationResolver;
    }

    public ConfigurationModuleType getModuleType() {
        return this.configurationData.getModuleType();
    }

    public long getCreated() {
        return this.configurationData.getCreated();
    }

    @Override
    public Bundle getBundle() {
        return this.bundle;
    }

    public BundleContext getBundleContext() {
        return this.bundle.getBundleContext();
    }

    public List<Configuration> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public Set<Artifact> getOwnedConfigurations() {
        return this.configurationData.getOwnedConfigurations();
    }

    public Map<AbstractName, GBeanData> getGBeans() {
        return Collections.unmodifiableMap(this.gbeans);
    }

    public synchronized boolean containsGBean(AbstractName gbean) {
        return this.gbeans.containsKey(gbean);
    }

    public Configuration getEnclosingConfiguration() {
        return this.parent;
    }

    ManageableAttributeStore getManageableAttributeStore() {
        return this.attributeStore;
    }

    public synchronized AbstractName addGBean(String name, GBeanData gbean) throws GBeanAlreadyExistsException {
        AbstractName abstractName = gbean.getAbstractName();
        if (abstractName != null) {
            throw new IllegalArgumentException("gbean already has an abstract name: " + abstractName);
        }
        String j2eeType = gbean.getGBeanInfo().getJ2eeType();
        if (j2eeType == null) {
            j2eeType = "GBean";
        }
        abstractName = this.naming.createRootName(this.getId(), name, j2eeType);
        gbean.setAbstractName(abstractName);
        if (this.gbeans.containsKey(abstractName)) {
            throw new GBeanAlreadyExistsException(gbean.getAbstractName().toString());
        }
        this.gbeans.put(abstractName, gbean);
        return abstractName;
    }

    public synchronized void addGBean(GBeanData gbean) throws GBeanAlreadyExistsException {
        if (this.gbeans.containsKey(gbean.getAbstractName())) {
            throw new GBeanAlreadyExistsException(gbean.getAbstractName().toString());
        }
        this.gbeans.put(gbean.getAbstractName(), gbean);
    }

    public synchronized void removeGBean(AbstractName name) throws GBeanNotFoundException {
        if (!this.gbeans.containsKey(name)) {
            throw new GBeanNotFoundException(name);
        }
        this.gbeans.remove(name);
    }

    public AbstractName findGBean(AbstractNameQuery pattern) throws GBeanNotFoundException {
        if (pattern == null) {
            throw new NullPointerException("pattern is null");
        }
        return this.findGBean(Collections.singleton(pattern));
    }

    public GBeanData findGBeanData(AbstractNameQuery pattern) throws GBeanNotFoundException {
        if (pattern == null) {
            throw new NullPointerException("pattern is null");
        }
        return this.findGBeanData(Collections.singleton(pattern));
    }

    public AbstractName findGBean(ReferencePatterns referencePatterns) throws GBeanNotFoundException {
        if (referencePatterns == null) {
            throw new NullPointerException("referencePatterns is null");
        }
        if (referencePatterns.isResolved()) {
            return referencePatterns.getAbstractName();
        }
        Set<AbstractNameQuery> patterns = referencePatterns.getPatterns();
        return this.findGBean(patterns);
    }

    public AbstractName findGBean(Set<AbstractNameQuery> patterns) throws GBeanNotFoundException {
        if (patterns == null) {
            throw new NullPointerException("patterns is null");
        }
        return this.findGBeanData(patterns).getAbstractName();
    }

    public GBeanData findGBeanData(Set<AbstractNameQuery> patterns) throws GBeanNotFoundException {
        if (patterns == null) {
            throw new NullPointerException("patterns is null");
        }
        LinkedHashSet<GBeanData> result = this.findGBeanDatas(this, patterns);
        if (result.size() > 1) {
            throw new GBeanNotFoundException("More than one match to referencePatterns in local configuration", patterns, this.mapToNames(result));
        }
        if (result.size() == 1) {
            return (GBeanData)result.iterator().next();
        }
        for (Configuration configuration : this.allServiceParents) {
            result.addAll(this.findGBeanDatas(configuration, patterns));
        }
        if (result.size() > 1) {
            ArrayList<AbstractName> names = new ArrayList<AbstractName>(result.size());
            for (GBeanData gBeanData : result) {
                names.add(gBeanData.getAbstractName());
            }
            throw new GBeanNotFoundException("More than one match to referencePatterns in parent configurations: " + ((Object)names).toString(), patterns, this.mapToNames(result));
        }
        if (result.isEmpty()) {
            throw new GBeanNotFoundException("No matches for referencePatterns", patterns, null);
        }
        return (GBeanData)result.iterator().next();
    }

    private Set<AbstractName> mapToNames(Set<GBeanData> datas) {
        HashSet<AbstractName> names = new HashSet<AbstractName>(datas.size());
        for (GBeanData gBeanData : datas) {
            names.add(gBeanData.getAbstractName());
        }
        return names;
    }

    public LinkedHashSet<AbstractName> findGBeans(AbstractNameQuery pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern is null");
        }
        return this.findGBeans(Collections.singleton(pattern));
    }

    public LinkedHashSet<AbstractName> findGBeans(ReferencePatterns referencePatterns) {
        if (referencePatterns == null) {
            throw new NullPointerException("referencePatterns is null");
        }
        if (referencePatterns.getAbstractName() != null) {
            LinkedHashSet<AbstractName> result = new LinkedHashSet<AbstractName>();
            result.add(referencePatterns.getAbstractName());
            return result;
        }
        Set<AbstractNameQuery> patterns = referencePatterns.getPatterns();
        return this.findGBeans(patterns);
    }

    public LinkedHashSet<AbstractName> findGBeans(Set<AbstractNameQuery> patterns) {
        if (patterns == null) {
            throw new NullPointerException("patterns is null");
        }
        LinkedHashSet<GBeanData> datas = this.findGBeanDatas(patterns);
        LinkedHashSet<AbstractName> result = new LinkedHashSet<AbstractName>(datas.size());
        for (GBeanData gBeanData : datas) {
            result.add(gBeanData.getAbstractName());
        }
        return result;
    }

    public LinkedHashSet<GBeanData> findGBeanDatas(Set<AbstractNameQuery> patterns) {
        if (patterns == null) {
            throw new NullPointerException("patterns is null");
        }
        LinkedHashSet<GBeanData> datas = this.findGBeanDatas(this, patterns);
        for (Configuration configuration : this.allServiceParents) {
            LinkedHashSet<GBeanData> match = this.findGBeanDatas(configuration, patterns);
            datas.addAll(match);
        }
        return datas;
    }

    public LinkedHashSet<GBeanData> findGBeanDatas(Configuration configuration, Set<AbstractNameQuery> patterns) {
        LinkedHashSet<GBeanData> result = new LinkedHashSet<GBeanData>();
        Set<Map.Entry<AbstractName, GBeanData>> gbeanNames = configuration.getGBeans().entrySet();
        for (AbstractNameQuery abstractNameQuery : patterns) {
            Artifact queryArtifact = abstractNameQuery.getArtifact();
            if (queryArtifact != null && !queryArtifact.matches(configuration.getId())) continue;
            for (Map.Entry<AbstractName, GBeanData> entry : gbeanNames) {
                GBeanData gbeanData;
                AbstractName abstractName = entry.getKey();
                if (!abstractNameQuery.matches(abstractName, (gbeanData = entry.getValue()).getGBeanInfo().getInterfaces())) continue;
                result.add(gbeanData);
            }
        }
        return result;
    }

    @Override
    public void doStart() throws Exception {
        log.debug("Started configuration {}", (Object)this.getId());
    }

    @Override
    public synchronized void doStop() throws Exception {
        log.debug("Stopping configuration {}", (Object)this.getId());
        this.shutdown();
    }

    @Override
    public void doFail() {
        log.debug("Failed configuration {}", (Object)this.getId());
        this.shutdown();
    }

    private void shutdown() {
        for (Configuration configuration : this.children) {
            configuration.shutdown();
        }
        this.gbeans.clear();
    }
}

