/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.basic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.runtime.LifecycleBroadcaster;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.lifecycle.LifecycleListener;
import org.apache.geronimo.kernel.lifecycle.LifecycleMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicLifecycleMonitor
implements LifecycleMonitor {
    private static final Logger log = LoggerFactory.getLogger(BasicLifecycleMonitor.class);
    private final Map boundListeners = new HashMap();
    private final Map listenerPatterns = new LinkedHashMap();

    public BasicLifecycleMonitor(Kernel kernel) {
        Set<AbstractName> names = kernel.listGBeans((AbstractNameQuery)null);
        for (AbstractName source : names) {
            GBeanData gBeanData;
            try {
                gBeanData = kernel.getGBeanData(source);
            }
            catch (GBeanNotFoundException e) {
                throw new AssertionError((Object)e);
            }
            this.addSource(source, gBeanData.getGBeanInfo().getInterfaces());
        }
    }

    public synchronized void destroy() {
        this.boundListeners.clear();
        this.listenerPatterns.clear();
    }

    private synchronized void addSource(AbstractName source, Set interfaceTypes) {
        if (this.boundListeners.containsKey(source)) {
            return;
        }
        SourceInfo sourceInfo = new SourceInfo(interfaceTypes);
        Set listeners = sourceInfo.getListeners();
        for (Map.Entry entry : this.listenerPatterns.entrySet()) {
            Set patterns = (Set)entry.getValue();
            for (AbstractNameQuery pattern : patterns) {
                if (!pattern.matches(source, interfaceTypes)) continue;
                LifecycleListener listener = (LifecycleListener)entry.getKey();
                listeners.add(listener);
            }
        }
        this.boundListeners.put(source, sourceInfo);
    }

    private synchronized void removeSource(AbstractName source) {
        this.boundListeners.remove(source);
    }

    @Override
    public synchronized void addLifecycleListener(LifecycleListener listener, AbstractNameQuery pattern) {
        this.addLifecycleListener(listener, Collections.singleton(pattern));
    }

    @Override
    public synchronized void addLifecycleListener(LifecycleListener listener, Set patterns) {
        for (AbstractNameQuery pattern : patterns) {
            for (Map.Entry entry : this.boundListeners.entrySet()) {
                SourceInfo sourceInfo;
                AbstractName source = (AbstractName)entry.getKey();
                if (!pattern.matches(source, (sourceInfo = (SourceInfo)entry.getValue()).getInterfaceTypes())) continue;
                Set listeners = sourceInfo.getListeners();
                listeners.add(listener);
            }
        }
        this.listenerPatterns.put(listener, patterns);
    }

    @Override
    public synchronized void removeLifecycleListener(LifecycleListener listener) {
        for (SourceInfo sourceInfo : this.boundListeners.values()) {
            sourceInfo.getListeners().remove(listener);
        }
        this.listenerPatterns.remove(listener);
    }

    private synchronized Collection getTargets(AbstractName source) {
        SourceInfo targets = (SourceInfo)this.boundListeners.get(source);
        if (targets == null) {
            return Collections.EMPTY_SET;
        }
        return new ArrayList(targets.getListeners());
    }

    private void fireLoadedEvent(AbstractName refInfoName) {
        Collection targets = this.getTargets(refInfoName);
        for (LifecycleListener listener : targets) {
            try {
                listener.loaded(refInfoName);
            }
            catch (Throwable e) {
                log.warn("Exception occured while notifying listener", e);
            }
        }
    }

    private void fireStartingEvent(AbstractName source) {
        Collection targets = this.getTargets(source);
        for (LifecycleListener listener : targets) {
            try {
                listener.starting(source);
            }
            catch (Throwable e) {
                log.warn("Exception occured while notifying listener", e);
            }
        }
    }

    private void fireRunningEvent(AbstractName source) {
        Collection targets = this.getTargets(source);
        for (LifecycleListener listener : targets) {
            try {
                listener.running(source);
            }
            catch (Throwable e) {
                log.warn("Exception occured while notifying listener", e);
            }
        }
    }

    private void fireStoppingEvent(AbstractName source) {
        Collection targets = this.getTargets(source);
        for (LifecycleListener listener : targets) {
            try {
                listener.stopping(source);
            }
            catch (Throwable e) {
                log.warn("Exception occured while notifying listener", e);
            }
        }
    }

    private void fireStoppedEvent(AbstractName source) {
        Collection targets = this.getTargets(source);
        for (LifecycleListener listener : targets) {
            try {
                listener.stopped(source);
            }
            catch (Throwable e) {
                log.warn("Exception occured while notifying listener", e);
            }
        }
    }

    private void fireFailedEvent(AbstractName source) {
        Collection targets = this.getTargets(source);
        for (LifecycleListener listener : targets) {
            try {
                listener.failed(source);
            }
            catch (Throwable e) {
                log.warn("Exception occured while notifying listener", e);
            }
        }
    }

    private void fireUnloadedEvent(AbstractName source) {
        Collection targets = this.getTargets(source);
        for (LifecycleListener listener : targets) {
            try {
                listener.unloaded(source);
            }
            catch (Throwable e) {
                log.warn("Exception occured while notifying listener", e);
            }
        }
    }

    public LifecycleBroadcaster createLifecycleBroadcaster(AbstractName abstractName, Set interfaceTypes) {
        return new RawLifecycleBroadcaster(abstractName, interfaceTypes);
    }

    private final class SourceInfo {
        private final Set interfaceTypes;
        private final HashSet listeners = new LinkedHashSet();

        public SourceInfo(Set interfaceTypes) {
            this.interfaceTypes = interfaceTypes;
        }

        public Set getInterfaceTypes() {
            return this.interfaceTypes;
        }

        public Set getListeners() {
            return this.listeners;
        }
    }

    private class RawLifecycleBroadcaster
    implements LifecycleBroadcaster {
        private final AbstractName abstractName;
        private final Set interfaceTypes;

        public RawLifecycleBroadcaster(AbstractName abstractName, Set interfaceTypes) {
            this.abstractName = abstractName;
            this.interfaceTypes = interfaceTypes;
        }

        @Override
        public void fireLoadedEvent() {
            BasicLifecycleMonitor.this.addSource(this.abstractName, this.interfaceTypes);
            BasicLifecycleMonitor.this.fireLoadedEvent(this.abstractName);
        }

        @Override
        public void fireStartingEvent() {
            BasicLifecycleMonitor.this.fireStartingEvent(this.abstractName);
        }

        @Override
        public void fireRunningEvent() {
            BasicLifecycleMonitor.this.fireRunningEvent(this.abstractName);
        }

        @Override
        public void fireStoppingEvent() {
            BasicLifecycleMonitor.this.fireStoppingEvent(this.abstractName);
        }

        @Override
        public void fireStoppedEvent() {
            BasicLifecycleMonitor.this.fireStoppedEvent(this.abstractName);
        }

        @Override
        public void fireFailedEvent() {
            BasicLifecycleMonitor.this.fireFailedEvent(this.abstractName);
        }

        @Override
        public void fireUnloadedEvent() {
            BasicLifecycleMonitor.this.fireUnloadedEvent(this.abstractName);
            BasicLifecycleMonitor.this.removeSource(this.abstractName);
        }
    }
}

