/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.remote;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.plugin.local.AbstractDeployCommand;
import org.apache.geronimo.deployment.plugin.remote.FileUploadProgress;
import org.apache.geronimo.deployment.plugin.remote.FileUploadServletClient;

public class RemoteDeployUtil {
    public static void uploadFilesToServerException(File[] files, final AbstractDeployCommand command) throws Exception {
        URL url = command.getRemoteDeployUploadURL();
        if (url == null) {
            throw new DeploymentException("Cannot perform remote file upload. Remote upload service may not be running.");
        }
        String username = command.getCommandContext().getUsername();
        String password = command.getCommandContext().getPassword();
        FileUploadServletClient uploadServletClient = new FileUploadServletClient();
        final ArrayList exceptions = new ArrayList();
        uploadServletClient.uploadFilesToServer(url, username, password, files, new FileUploadProgress(){

            @Override
            public void updateStatus(String message) {
                command.updateStatus(message);
            }

            @Override
            public void fail(String message) {
                exceptions.add(new IOException(message));
            }

            @Override
            public void fail(Exception exception) {
                exceptions.add(exception);
            }
        });
        if (!exceptions.isEmpty()) {
            throw new DeploymentException("Remote file upload failed", exceptions);
        }
    }

    public static void uploadFilesToServer(File[] files, AbstractDeployCommand command) {
        FileUploadServletClient uploadServletClient = new FileUploadServletClient();
        try {
            uploadServletClient.uploadFilesToServer(command.getRemoteDeployUploadURL(), command.getCommandContext().getUsername(), command.getCommandContext().getPassword(), files, new FileUploadServletProgressAdapter(command));
        }
        catch (Exception e) {
            command.doFail(e);
        }
    }

    protected static class FileUploadServletProgressAdapter
    implements FileUploadProgress {
        private final AbstractDeployCommand command;

        public FileUploadServletProgressAdapter(AbstractDeployCommand command) {
            this.command = command;
        }

        @Override
        public void fail(String message) {
            this.command.fail(message);
        }

        @Override
        public void fail(Exception exception) {
            this.command.doFail(exception);
        }

        @Override
        public void updateStatus(String message) {
            this.command.updateStatus(message);
        }
    }
}

